/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.explorer.mview;

import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.model.Node;
import oracle.javatools.db.Column;
import oracle.javatools.db.ora.MaterializedView;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.jdbc.MViewNode;
import oracle.jdevimpl.cm.dt.explorer.BaseCMExplorer;
import oracle.jdevimpl.cm.dt.explorer.DBObjectExplorerCellRenderer;

public final class MViewExplorer
extends BaseCMExplorer {
    protected DefaultMutableTreeNode buildTree() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MaterializedView materializedView;
        Node node = this.getNode();
        MaterializedView materializedView2 = materializedView = node instanceof MViewNode ? ((MViewNode)node).getMView() : null;
        if (materializedView != null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode(materializedView.getName());
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(ConnectionArb.getString(566));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            String[] stringArray = materializedView.getMasters();
            int n = 0;
            while (n < stringArray.length) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(stringArray[n]));
                ++n;
            }
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(ConnectionArb.getString(551));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(552, materializedView.isUpdatable() ? "Y" : "N")));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(553, materializedView.isRewrite() ? "Y" : "N")));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(554, MViewExplorer._getRewriteString(materializedView))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(555, MViewExplorer._getRefreshModeString(materializedView))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(556, MViewExplorer._getRefreshMethodString(materializedView))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(557, MViewExplorer._getFastRefreshableString(materializedView))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(558, MViewExplorer._getLastRefreshTypeString(materializedView))));
            Date date = materializedView.getLastRefreshDate();
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(559, date != null ? date.toString() : "")));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(560, MViewExplorer._getStalenessString(materializedView))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(562, MViewExplorer._getBuildTypeString(materializedView))));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(564, materializedView.isUseNoIndex() ? "Y" : "N")));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(ConnectionArb.format(565, materializedView.isCache() ? "Y" : "N")));
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(ConnectionArb.getString(196));
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            Column[] columnArray = materializedView.getColumns();
            int n2 = 0;
            while (n2 < columnArray.length) {
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(columnArray[n2]));
                ++n2;
            }
        } else {
            defaultMutableTreeNode = new DefaultMutableTreeNode(node.getShortLabel());
        }
        return defaultMutableTreeNode;
    }

    protected boolean isValidNode(Node node) {
        return node instanceof MViewNode;
    }

    private static final String _getRewriteString(MaterializedView materializedView) {
        String string;
        switch (materializedView.getRewriteType()) {
            case 1: {
                string = "TEXTMATCH";
                break;
            }
            case 2: {
                string = "GENERAL";
                break;
            }
            default: {
                string = "NONE";
            }
        }
        return string;
    }

    private static final String _getRefreshModeString(MaterializedView materializedView) {
        String string;
        switch (materializedView.getRefreshMode()) {
            case 1: {
                string = "COMMIT";
                break;
            }
            case 0: {
                string = "DEMAND";
                break;
            }
            default: {
                string = "NEVER";
            }
        }
        return string;
    }

    private static final String _getRefreshMethodString(MaterializedView materializedView) {
        String string;
        switch (materializedView.getRefreshMethod()) {
            case 0: {
                string = "COMPLETE";
                break;
            }
            case 2: {
                string = "FAST";
                break;
            }
            case 1: {
                string = "FORCE";
                break;
            }
            default: {
                string = "NEVER";
            }
        }
        return string;
    }

    private static final String _getFastRefreshableString(MaterializedView materializedView) {
        String string;
        switch (materializedView.getFastRefresh()) {
            case 1: {
                string = "DIRLOAD";
                break;
            }
            case 2: {
                string = "DML";
                break;
            }
            case 3: {
                string = "DIRLOAD_DML";
                break;
            }
            case 4: {
                string = "DIRLOAD_LIMITEDDML";
                break;
            }
            default: {
                string = "NO";
            }
        }
        return string;
    }

    private static final String _getLastRefreshTypeString(MaterializedView materializedView) {
        String string;
        switch (materializedView.getLastRefreshType()) {
            case 0: {
                string = "COMPLETE";
                break;
            }
            case 2: {
                string = "FAST";
                break;
            }
            default: {
                string = "NA";
            }
        }
        return string;
    }

    private static final String _getStalenessString(MaterializedView materializedView) {
        String string;
        switch (materializedView.getStaleness()) {
            case 0: {
                string = "FRESH";
                break;
            }
            case 1: {
                string = "STALE";
                break;
            }
            case 2: {
                string = "UNUSABLE";
                break;
            }
            case 4: {
                string = "UNDEFINED";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    private static final String _getBuildTypeString(MaterializedView materializedView) {
        String string;
        switch (materializedView.getBuildType()) {
            case 1: {
                string = "DEFERRED";
                break;
            }
            case 0: {
                string = "IMMEDIATE";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    protected TreeCellRenderer getCellRenderer() {
        return new DBObjectExplorerCellRenderer();
    }
}

