/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.folding;

import java.util.Stack;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.folding.DefaultCodeFoldingModel;
import oracle.javatools.editor.folding.FoldingBlock;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.syntax.PlsqlLexer;
import oracle.jdevimpl.cm.dt.folding.PlSqlFoldingBlock;

public class PlSqlFoldingModel
extends DefaultCodeFoldingModel {
    private Lexer _lexer;
    private LexerToken _token;

    void $init$() {
        this._lexer = new PlsqlLexer();
        this._token = this._lexer.createLexerToken();
    }

    public PlSqlFoldingModel(BasicDocument basicDocument) {
        super(basicDocument);
        this.$init$();
        this.reload();
    }

    public void reload() {
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        textBuffer.readLock();
        try {
            Stack<PlSqlFoldingBlock> stack = new Stack<PlSqlFoldingBlock>();
            PlSqlFoldingBlock plSqlFoldingBlock = new PlSqlFoldingBlock(0, textBuffer.getLength(), PlSqlFoldingBlock.BlockType.FILE, "");
            stack.push(plSqlFoldingBlock);
            this.parse(textBuffer, plSqlFoldingBlock);
            this.setRoot((Object)plSqlFoldingBlock);
        }
        finally {
            textBuffer.readUnlock();
        }
        super.reload();
    }

    private void parse(TextBuffer textBuffer, PlSqlFoldingBlock plSqlFoldingBlock) {
        this._lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        this._lexer.setPosition(0);
        this.start(plSqlFoldingBlock);
    }

    private void start(PlSqlFoldingBlock plSqlFoldingBlock) {
        block12: while (true) {
            int n = this._lexer.lex(this._token);
            switch (n) {
                case 0: {
                    return;
                }
                case 228: 
                case 341: {
                    int n2 = this._lexer.lex(this._token);
                    if (!PlSqlFoldingModel.isOperator(n2)) {
                        int n3 = this._lexer.lex(this._token);
                        if (n3 == 72) {
                            int n4 = this._lexer.lex(this._token);
                            if (PlSqlFoldingModel.isOperator(n4)) {
                                this._lexer.setPosition(this._token.getStartOffset());
                            }
                        } else {
                            this._lexer.setPosition(this._token.getStartOffset());
                        }
                    }
                    PlSqlFoldingBlock.BlockType blockType = n == 341 ? PlSqlFoldingBlock.BlockType.PROCEDURE : PlSqlFoldingBlock.BlockType.FUNCTION;
                    plSqlFoldingBlock = this.push(plSqlFoldingBlock, blockType, "...");
                    break;
                }
                case 137: 
                case 256: {
                    plSqlFoldingBlock.setSeenIs(true);
                    break;
                }
                case 143: {
                    PlSqlFoldingBlock.BlockType blockType = plSqlFoldingBlock.getType();
                    boolean bl = true;
                    if (!(blockType != PlSqlFoldingBlock.BlockType.PROCEDURE && blockType != PlSqlFoldingBlock.BlockType.FUNCTION || plSqlFoldingBlock.hasSeenBegin())) {
                        bl = false;
                        plSqlFoldingBlock.setSeenBegin(true);
                    }
                    if (!bl) continue block12;
                    plSqlFoldingBlock = this.push(plSqlFoldingBlock, PlSqlFoldingBlock.BlockType.BEGIN_END, "BEGIN...");
                    break;
                }
                case 271: {
                    plSqlFoldingBlock = this.push(plSqlFoldingBlock, PlSqlFoldingBlock.BlockType.LOOP, "LOOP...");
                    break;
                }
                case 159: {
                    plSqlFoldingBlock = this.push(plSqlFoldingBlock, PlSqlFoldingBlock.BlockType.CASE, "CASE...");
                    break;
                }
                case 239: {
                    plSqlFoldingBlock = this.push(plSqlFoldingBlock, PlSqlFoldingBlock.BlockType.THEN, "THEN...");
                    plSqlFoldingBlock.setWaitingForThenAfterIf(true);
                    break;
                }
                case 404: {
                    if (!plSqlFoldingBlock.isWaitingForThenAfterIf()) continue block12;
                    int n5 = this._token.getStartOffset();
                    plSqlFoldingBlock.setStartOffset(n5);
                    break;
                }
                case 209: {
                    PlSqlFoldingBlock plSqlFoldingBlock2 = (PlSqlFoldingBlock)plSqlFoldingBlock.getParent();
                    if (plSqlFoldingBlock2 == null) continue block12;
                    int n6 = this._token.getEndOffset();
                    int n7 = this._lexer.lex(this._token);
                    if (!PlSqlFoldingModel.isOperator(n7)) {
                        n7 = this._lexer.lex(this._token);
                        n6 = this._token.getEndOffset();
                    }
                    if (n7 == 94) {
                        n6 = this._token.getEndOffset();
                    } else {
                        this._lexer.setPosition(this._token.getStartOffset());
                    }
                    int n8 = plSqlFoldingBlock.getStartOffset();
                    if (this.isSameLine(n8, n6)) {
                        plSqlFoldingBlock2.remove((FoldingBlock)plSqlFoldingBlock);
                    } else {
                        plSqlFoldingBlock.setEndOffset(n6);
                    }
                    plSqlFoldingBlock = plSqlFoldingBlock2;
                    break;
                }
                case 94: {
                    PlSqlFoldingBlock.BlockType blockType = plSqlFoldingBlock.getType();
                    if (blockType != PlSqlFoldingBlock.BlockType.FUNCTION && blockType != PlSqlFoldingBlock.BlockType.PROCEDURE || plSqlFoldingBlock.hasSeenIs()) continue block12;
                    int n9 = plSqlFoldingBlock.getStartOffset();
                    int n10 = this._token.getEndOffset();
                    PlSqlFoldingBlock plSqlFoldingBlock3 = (PlSqlFoldingBlock)plSqlFoldingBlock.getParent();
                    if (this.isSameLine(n9, n10)) {
                        plSqlFoldingBlock3.remove((FoldingBlock)plSqlFoldingBlock);
                    } else {
                        plSqlFoldingBlock.setEndOffset(n10);
                    }
                    plSqlFoldingBlock = plSqlFoldingBlock3;
                }
            }
        }
    }

    private boolean isSameLine(int n, int n2) {
        int n3;
        TextBuffer textBuffer = (TextBuffer)this._lexer.getTextBuffer();
        LineMap lineMap = textBuffer.getLineMap();
        int n4 = lineMap.getLineEndOffset(n3 = lineMap.getLineFromOffset(n));
        return n2 < n4;
    }

    private static boolean isOperator(int n) {
        return 64 <= n && n <= 99;
    }

    private PlSqlFoldingBlock push(PlSqlFoldingBlock plSqlFoldingBlock, PlSqlFoldingBlock.BlockType blockType, String string) {
        int n = this._token.getStartOffset();
        PlSqlFoldingBlock plSqlFoldingBlock2 = new PlSqlFoldingBlock(n, blockType, string);
        plSqlFoldingBlock.add((FoldingBlock)plSqlFoldingBlock2);
        return plSqlFoldingBlock2;
    }
}

