/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.insight;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.ListDataItemListModel;
import oracle.jdeveloper.cm.ds.db.insight.BaseInsightableItem;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdevimpl.cm.dt.insight.AbstractListInsightData;
import oracle.jdevimpl.cm.dt.insight.CompletionInsight;
import oracle.jdevimpl.cm.dt.insight.DatabaseDataItem;
import oracle.jdevimpl.java.JavaArb;

public class DatabaseListInsightData
extends AbstractListInsightData {
    final CompletionInsight _insight;
    private static final EditDescriptor _editDescriptor;
    private String _context;
    private String _schema;
    public static final String DATABASE_INSIGHT_PROPERTY = "database-insight-data";

    void $init$() {
        this._context = null;
    }

    static {
        String string = JavaArb.getString((int)52);
        _editDescriptor = new EditDescriptor(string);
    }

    public DatabaseListInsightData(CompletionInsight completionInsight, String string) {
        this.$init$();
        this._insight = completionInsight;
        this._context = string;
        URL uRL = this._insight.getURL();
        this._schema = CmUtil.getSchema(uRL);
        if (this._schema == null) {
            try {
                this._schema = this._insight.getDatabase().getDatabase().getUserName();
            }
            catch (Exception exception) {
                this._schema = null;
            }
        }
        this.updateContext(string);
    }

    protected String getUserPrefix() {
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        int n2 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
        int n3 = n - n2;
        String string = textBuffer.getString(n2, n3);
        return string;
    }

    public boolean complete(Object object) {
        DatabaseDataItem databaseDataItem = (DatabaseDataItem)((Object)object);
        String string = databaseDataItem.getName();
        BasicDocument basicDocument = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        int n2 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
        int n3 = this.getNameEndOffset((ReadTextBuffer)textBuffer, n);
        BasicEditorPane basicEditorPane = this._insight.getEditorPane();
        basicEditorPane.beginEdit(DatabaseListInsightData.getEditDescriptor());
        try {
            try {
                basicDocument.remove(n2, n3 - n2);
                basicDocument.insertString(n2, string, null);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Exception occurred in completion: " + badLocationException);
                badLocationException.printStackTrace();
            }
        }
        finally {
            basicEditorPane.endEdit();
        }
        return false;
    }

    public void partialComplete() {
        BasicDocument basicDocument = this._insight.getDocument();
        TextBuffer textBuffer = this._insight.getTextBuffer();
        int n = this._insight.getCaretPosition();
        basicDocument.readLock();
        try {
            int n2 = this.getNameStartOffset((ReadTextBuffer)textBuffer, n);
            int n3 = this.getNameEndOffset((ReadTextBuffer)textBuffer, n);
            int n4 = n - n2;
            String string = textBuffer.getString(n2, n4);
            ListDataItemListModel listDataItemListModel = this.buildListModel();
            String string2 = listDataItemListModel.findCommonPrefix(string);
            if (string2.length() == 0) {
                basicDocument.readUnlock();
                return;
            }
            BasicEditorPane basicEditorPane = this._insight.getEditorPane();
            basicEditorPane.beginEdit(DatabaseListInsightData.getEditDescriptor());
            try {
                try {
                    basicDocument.remove(n2, n3 - n2);
                    basicDocument.insertString(n2, string2, null);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println("Exception occurred in partial completion: " + badLocationException);
                    badLocationException.printStackTrace();
                }
            }
            finally {
                basicEditorPane.endEdit();
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    void updateContext(String string) {
        this._context = this._cleanContext(string);
        BaseInsightableItem baseInsightableItem = this._insight.getBaseInsightableItem();
        if (baseInsightableItem == null) {
            return;
        }
        List list = DatabaseListInsightData.parseContext(this._context);
        Iterator iterator = list.iterator();
        BaseInsightableItem baseInsightableItem2 = baseInsightableItem;
        if (list.size() > 0) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                BaseInsightableItem baseInsightableItem3 = baseInsightableItem2 == baseInsightableItem ? this.findItemTopLevel(baseInsightableItem, string2) : this.findItemInSearchRoot(baseInsightableItem2, string2);
                if (baseInsightableItem3 == null) break;
                baseInsightableItem2 = baseInsightableItem3;
            }
        }
        if (list.size() > 0 && baseInsightableItem2 == baseInsightableItem) {
            this.clearData();
        } else {
            this.setDataAtItem(baseInsightableItem2);
        }
    }

    String _cleanContext(String string) {
        String string2 = string.trim();
        if (string2.indexOf(46) == -1) {
            return "";
        }
        return string2.substring(0, string2.lastIndexOf(46));
    }

    BaseInsightableItem findItemInSearchRoot(BaseInsightableItem baseInsightableItem, String string) {
        return baseInsightableItem.getChild(string);
    }

    BaseInsightableItem findItemTopLevel(BaseInsightableItem baseInsightableItem, String string) {
        if (string == null) {
            return baseInsightableItem;
        }
        BaseInsightableItem baseInsightableItem2 = baseInsightableItem.getChild(string);
        if (baseInsightableItem2 != null) {
            return baseInsightableItem2;
        }
        baseInsightableItem2 = baseInsightableItem.getChild(this._schema);
        if (baseInsightableItem2 == null) {
            return baseInsightableItem.getChild(string);
        }
        BaseInsightableItem baseInsightableItem3 = baseInsightableItem2.getChild(string);
        if (baseInsightableItem3 == null) {
            baseInsightableItem2 = baseInsightableItem.getChild("PUBLIC");
            return baseInsightableItem2.getChild(string);
        }
        return baseInsightableItem3;
    }

    private void setDefaultRootData() {
        BaseInsightableItem baseInsightableItem = this._insight.getBaseInsightableItem();
        if (baseInsightableItem != null) {
            Iterator iterator = Collections.EMPTY_LIST.iterator();
            iterator = this._schema != null ? BaseInsightableItem.getSchemaLevelIterator(baseInsightableItem, this._schema) : BaseInsightableItem.getTopLevelIterator(baseInsightableItem);
            this.setData(DatabaseDataItem.createDataItems(iterator));
        }
    }

    private void setDataAtItem(BaseInsightableItem baseInsightableItem) {
        BaseInsightableItem baseInsightableItem2 = this._insight.getBaseInsightableItem();
        if (baseInsightableItem == baseInsightableItem2) {
            this.setDefaultRootData();
        } else if (baseInsightableItem == null) {
            this.clearData();
        } else {
            if (!baseInsightableItem.isChildrenLoaded()) {
                this._insight.getDatabase().loadChildren(baseInsightableItem);
            }
            Iterator iterator = baseInsightableItem.getChildrenIterator();
            this.setData(DatabaseDataItem.createDataItems(iterator));
        }
    }

    private void clearData() {
        this.setData(DatabaseDataItem.EMPTY_LIST);
    }

    int getNameStartOffset(ReadTextBuffer readTextBuffer, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = readTextBuffer.getChar(n2);
            if (DatabaseListInsightData.isPlSqlDelimiter(c)) break;
            --n2;
        }
        return n2 + 1;
    }

    int getNameEndOffset(ReadTextBuffer readTextBuffer, int n) {
        int n2 = n;
        int n3 = readTextBuffer.getLength();
        while (n2 < n3) {
            char c = readTextBuffer.getChar(n2);
            if (DatabaseListInsightData.isPlSqlDelimiter(c)) break;
            ++n2;
        }
        return n2;
    }

    static boolean isPlSqlDelimiter(char c) {
        return CompletionInsight.isPlSqlDelimiter(c) || c == '.';
    }

    static EditDescriptor getEditDescriptor() {
        return _editDescriptor;
    }

    static List parseContext(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        try {
            String string2 = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                string3 = string3.startsWith("\"") && string3.endsWith("\"") && string3.length() > 2 ? string3.substring(1, string3.length() - 1) : string3.toUpperCase();
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }
}

