/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.newobj.plsql;

import java.sql.SQLException;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdeveloper.cm.dt.compiler.PlSqlCreationException;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser;
import oracle.jdevimpl.cm.dt.newobj.plsql.NewPlsqlModel;

public final class PlSqlBuilder {
    int _dbType;
    NewPlsqlModel _model;
    private static final String PROC_TXT = " AS\nBEGIN\n  NULL;\nEND;\n\n";
    private static final String FUNC_TXT = "\nRETURN VARCHAR2\nAS\nBEGIN\n  RETURN('');\nEND;\n\n";
    private static final String PKG_TXT = " AS\nEND;\n\n";

    void $init$() {
        this._dbType = -1;
        this._model = null;
    }

    private PlSqlBuilder(NewPlsqlModel newPlsqlModel) {
        this.$init$();
        this._model = newPlsqlModel;
    }

    public static PlSqlBuilder getInstance(NewPlsqlModel newPlsqlModel) {
        return new PlSqlBuilder(newPlsqlModel);
    }

    public String getPlSqlText() throws PlSqlCreationException {
        JdbcBrowser jdbcBrowser = this._getJdbcBrowser(this._model.getConnectionName());
        if (jdbcBrowser == null) {
            throw new PlSqlCreationException("Invalid Connection State");
        }
        Database database = jdbcBrowser.getDatabase();
        return this.getDefaultText(database);
    }

    private JdbcBrowser _getJdbcBrowser(String string) {
        ConnectionsProvider connectionsProvider = ConnectionsProvider.getInstance();
        ConnectionNode connectionNode = connectionsProvider.getConnectionNode(string);
        if (connectionNode == null) {
            return null;
        }
        JdbcBrowser jdbcBrowser = (JdbcBrowser)connectionNode.getConnectionBrowser();
        return jdbcBrowser;
    }

    private String getDefaultText(Database database) throws PlSqlCreationException {
        String string = this._model.getSchema();
        String string2 = null;
        try {
            string2 = database.getUserName();
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            throw throwable instanceof SQLException ? new PlSqlCreationException((SQLException)throwable) : new PlSqlCreationException((Exception)((Object)dBException));
        }
        String string3 = this._model.getObjectType();
        String string4 = this._model.getObjectName();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        fastStringBuffer.append("CREATE OR REPLACE\n");
        fastStringBuffer.append(string3).append(' ');
        if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
            fastStringBuffer.append('\"').append(string).append('\"').append('.');
        }
        fastStringBuffer.append('\"').append(string4).append('\"');
        if ("PROCEDURE".equals(string3)) {
            fastStringBuffer.append(PROC_TXT);
        } else if ("FUNCTION".equals(string3)) {
            fastStringBuffer.append(FUNC_TXT);
        } else if ("PACKAGE".equals(string3) || "PACKAGE BODY".equals(string3)) {
            fastStringBuffer.append(PKG_TXT);
        } else {
            throw new UnsupportedOperationException();
        }
        return fastStringBuffer.toString();
    }
}

