/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.newobj.plsql;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.TextNode;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdeveloper.cm.dt.compiler.PlSqlCreationException;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdevimpl.cm.dt.browser.jdbc.JdbcBrowser;
import oracle.jdevimpl.cm.dt.newobj.plsql.NewPlsqlModel;
import oracle.jdevimpl.cm.dt.newobj.plsql.NewPlsqlPanel;
import oracle.jdevimpl.cm.dt.newobj.plsql.PlSqlBuilder;

public final class PlSqlWizardHelper {
    private static final String[] SUPPORTED_TYPES = new String[]{"FUNCTION", "PACKAGE", "PROCEDURE"};

    private PlSqlWizardHelper() {
    }

    private static JdbcBrowser _getJdbcBrowser(String string) {
        ConnectionsProvider connectionsProvider = ConnectionsProvider.getInstance();
        ConnectionNode connectionNode = connectionsProvider.getConnectionNode(string);
        if (connectionNode == null) {
            return null;
        }
        JdbcBrowser jdbcBrowser = (JdbcBrowser)connectionNode.getConnectionBrowser();
        return jdbcBrowser;
    }

    private static JEWTDialog _createDialog(NewPlsqlModel newPlsqlModel, NewPlsqlPanel newPlsqlPanel) {
        String string;
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        String string2 = newPlsqlModel.getObjectType();
        String string3 = "f1_sqlplsqlsubprogram_html";
        boolean bl = false;
        if ("PACKAGE".equals(string2)) {
            string = ConnectionArb.getString(280);
            string3 = "f1_sqlplsqlpackage_html";
        } else if ("PROCEDURE".equals(string2)) {
            string = ConnectionArb.getString(282);
            string3 = "f1_sqlplsqlprocedure_html";
        } else if ("FUNCTION".equals(string2)) {
            string = ConnectionArb.getString(281);
            string3 = "f1_sqlplsqlfunction_html";
        } else {
            bl = true;
            string = ConnectionArb.getString(274);
        }
        JEWTDialog jEWTDialog = new JEWTDialog((Frame)ideMainWindow, string, 7);
        jEWTDialog.setContent((Component)newPlsqlPanel);
        jEWTDialog.setInitialFocus((Component)newPlsqlPanel.fldName);
        HelpSystem.getHelpSystem().registerTopic((JComponent)newPlsqlPanel, string3);
        jEWTDialog.setOKButtonEnabled(false);
        newPlsqlPanel.fldName.getDocument().addDocumentListener(new DialogListener(jEWTDialog, null));
        newPlsqlPanel.setUseType(bl);
        newPlsqlPanel.setTypesList(newPlsqlModel.getTypesList());
        return jEWTDialog;
    }

    private static URL _getSelectedURL(Context context) {
        Element[] elementArray = context.getSelection();
        return elementArray != null && elementArray.length > 0 && elementArray[0] instanceof Locatable ? ((Locatable)elementArray[0]).getURL() : null;
    }

    public static NewPlsqlModel _getDefaultModel(Context context, Database database) {
        URL uRL = PlSqlWizardHelper._getSelectedURL(context);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (CmUtil.isCMUrl(uRL)) {
            string = CmUtil.getConnName(uRL);
            string2 = CmUtil.getSchema(uRL);
            string3 = CmUtil.getDbObjectType(uRL);
            if (!PlSqlWizardHelper._isSupportedType(string3)) {
                string3 = null;
            }
        }
        if (string2 == null) {
            try {
                string2 = database.getUserName();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        NewPlsqlModel newPlsqlModel = new NewPlsqlModel(string, string3, null, string2);
        newPlsqlModel.setTypesList(PlSqlWizardHelper._getTypesList());
        return newPlsqlModel;
    }

    private static void _validateModel(String string, String string2, String string3, Database database) throws TraversalException {
        if (!database.isValidName(string3, string2)) {
            throw new TraversalException(ConnectionArb.getString(279), ConnectionArb.getString(278), null);
        }
        if (database.exists(string3, string, string2 = database.getInternalName(string2))) {
            throw new TraversalException(ConnectionArb.getString(277), ConnectionArb.getString(276), null);
        }
        try {
            String string4 = database.getUniqueName(string3, (DBObject)database.getSchema(string), string2);
            if (ModelUtil.areDifferent((Object)string4, (Object)string2)) {
                throw new TraversalException(ConnectionArb.getString(277), ConnectionArb.getString(276), null);
            }
        }
        catch (DBException dBException) {
            throw new TraversalException(dBException.getLocalizedMessage());
        }
    }

    public static boolean createPlSql(Context context, Database database) {
        NewPlsqlModel newPlsqlModel = PlSqlWizardHelper._getDefaultModel(context, database);
        String string = newPlsqlModel.getObjectType();
        NewPlsqlPanel newPlsqlPanel = new NewPlsqlPanel();
        JEWTDialog jEWTDialog = PlSqlWizardHelper._createDialog(newPlsqlModel, newPlsqlPanel);
        if (jEWTDialog != null) {
            jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 3(string, newPlsqlPanel, newPlsqlModel, database, jEWTDialog));
            boolean bl = WizardLauncher.runDialog((JDialog)jEWTDialog);
            if (bl) {
                PlSqlWizardHelper._createPlsql(newPlsqlModel);
            }
        }
        return true;
    }

    private static List _getTypesList() {
        return Arrays.asList(SUPPORTED_TYPES);
    }

    private static void _createPlsql(NewPlsqlModel newPlsqlModel) {
        block9: {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            try {
                PlSqlBuilder plSqlBuilder = PlSqlBuilder.getInstance(newPlsqlModel);
                String string = plSqlBuilder.getPlSqlText();
                JdbcBrowser jdbcBrowser = PlSqlWizardHelper._getJdbcBrowser(newPlsqlModel.getConnectionName());
                if (jdbcBrowser == null) break block9;
                String string2 = newPlsqlModel.getObjectType();
                Database database = jdbcBrowser.getDatabase();
                String string3 = "PACKAGE".equals(string2) || "TYPE".equals(string2) ? "Spec" : null;
                URL uRL = CmUtil.getNodeURL(newPlsqlModel.getConnectionName(), null, newPlsqlModel.getSchema(), string2, newPlsqlModel.getObjectName(), string3);
                Node node = JdbcNodeFactory.getNode(jdbcBrowser.getDatabase(), uRL);
                if (node instanceof TextNode) {
                    node.addNodeListener((NodeListener)new 2(database, newPlsqlModel, string2, (Frame)ideMainWindow, node));
                    TextBuffer textBuffer = null;
                    try {
                        textBuffer = ((TextNode)node).acquireTextBuffer();
                        textBuffer.beginEdit();
                        textBuffer.removeToEnd(0);
                        textBuffer.append(string.toCharArray());
                    }
                    finally {
                        if (textBuffer != null) {
                            textBuffer.endEdit();
                            ((TextNode)node).releaseTextBuffer();
                        }
                    }
                }
                EventQueue.invokeLater(new 1(node));
            }
            catch (PlSqlCreationException plSqlCreationException) {
                ExceptionDialog.showExceptionDialog((Window)ideMainWindow, (Exception)((Object)plSqlCreationException));
            }
            catch (ClassCastException classCastException) {
                ExceptionDialog.showExceptionDialog((Window)ideMainWindow, (Exception)classCastException);
            }
            catch (NullPointerException nullPointerException) {
                ExceptionDialog.showExceptionDialog((Window)ideMainWindow, (Exception)nullPointerException);
            }
        }
    }

    private static boolean _isSupportedType(String string) {
        int n = 0;
        while (n < SUPPORTED_TYPES.length) {
            if (SUPPORTED_TYPES[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static void maS$_validateModel(String string, String string2, String string3, Database database) {
        PlSqlWizardHelper._validateModel(string, string2, string3, database);
    }

    public static final class 3
    implements VetoableChangeListener {
        private final /* synthetic */ String v$objType;
        private final /* synthetic */ NewPlsqlPanel v$panel;
        private final /* synthetic */ NewPlsqlModel v$model;
        private final /* synthetic */ Database v$db;
        private final /* synthetic */ JEWTDialog v$dlg;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                String string = this.v$objType != null ? this.v$objType : this.v$panel.getObjectType();
                String string2 = this.v$panel.getObjectName();
                String string3 = this.v$model.getSchema();
                try {
                    PlSqlWizardHelper.maS$_validateModel(string3, string2, string, this.v$db);
                }
                catch (TraversalException traversalException) {
                    traversalException.showMessageDialog((Component)this.v$dlg);
                    throw new PropertyVetoException("no", propertyChangeEvent);
                }
                this.v$model.setObjectType(string);
                this.v$model.setObjectName(this.v$db.getInternalName(string2));
            }
        }

        public 3(String string, NewPlsqlPanel newPlsqlPanel, NewPlsqlModel newPlsqlModel, Database database, JEWTDialog jEWTDialog) {
            this.v$dlg = jEWTDialog;
            this.v$db = database;
            this.v$model = newPlsqlModel;
            this.v$panel = newPlsqlPanel;
            this.v$objType = string;
        }
    }

    public static final class 2
    extends NodeListener {
        private final /* synthetic */ Database v$db;
        private final /* synthetic */ NewPlsqlModel v$model;
        private final /* synthetic */ String v$dbType;
        private final /* synthetic */ Frame v$parent;
        private final /* synthetic */ Node v$cbn;

        public void nodeSaved(NodeEvent nodeEvent) {
            block7: {
                try {
                    try {
                        Schema schema = this.v$db.getSchema(this.v$model.getSchema());
                        SchemaObject schemaObject = this.v$db.getObject(this.v$dbType, schema, this.v$model.getObjectName());
                        if (schemaObject != null && this.v$db instanceof AbstractDatabase) {
                            ((AbstractDatabase)this.v$db).fireObjectsAdded(schema, new SchemaObject[]{schemaObject});
                        }
                    }
                    catch (DBException dBException) {
                        Throwable throwable = dBException.getCause();
                        if (throwable instanceof SQLException) {
                            SQLErrorDialog.showErrorDialog(this.v$parent, "Error Creating PL/SQL Subprogram", (SQLException)throwable);
                            break block7;
                        }
                        ExceptionDialog.showExceptionDialog((Window)this.v$parent, (Exception)((Object)dBException));
                    }
                }
                finally {
                    this.v$cbn.removeNodeListener((NodeListener)this);
                }
            }
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            this.v$cbn.removeNodeListener((NodeListener)this);
        }

        public 2(Database database, NewPlsqlModel newPlsqlModel, String string, Frame frame, Node node) {
            this.v$cbn = node;
            this.v$parent = frame;
            this.v$dbType = string;
            this.v$model = newPlsqlModel;
            this.v$db = database;
        }
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Node v$cbn;

        public void run() {
            EditorUtil.openDefaultEditorInFrame((Node)this.v$cbn);
        }

        public 1(Node node) {
            this.v$cbn = node;
        }
    }

    private static class DialogListener
    implements DocumentListener {
        private JEWTDialog _dlg;

        private DialogListener(JEWTDialog jEWTDialog) {
            this._dlg = jEWTDialog;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this._checkDocument(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this._checkDocument(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this._checkDocument(documentEvent);
        }

        private void _checkDocument(DocumentEvent documentEvent) {
            String string = DialogListener._getDocumentText(documentEvent.getDocument());
            if (ModelUtil.hasLength((String)string)) {
                this._dlg.setOKButtonEnabled(true);
            } else {
                this._dlg.setOKButtonEnabled(false);
            }
        }

        private static String _getDocumentText(Document document) {
            String string;
            try {
                string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                string = null;
            }
            return string;
        }

        DialogListener(JEWTDialog jEWTDialog, 1 var2_2) {
            this(jEWTDialog);
        }

        public final class 1 {
        }
    }
}

