/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.runner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.parser.plsql.data.PlsqlName;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlPkg;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.PlsqlSubprg;
import oracle.javatools.parser.plsql.data.PlsqlType;
import oracle.javatools.parser.plsql.data.PlsqlTypedef;
import oracle.javatools.parser.plsql.data.PlsqlVariable;
import oracle.jdevimpl.cm.dt.runner.Mode;
import oracle.jdevimpl.cm.dt.runner.ParamImpl;
import oracle.jdevimpl.cm.dt.runner.Parameter;
import oracle.jdevimpl.cm.dt.runner.Procedure;
import oracle.jdevimpl.cm.dt.runner.RunnerArb;
import oracle.jdevimpl.cm.dt.runner.Type;

public final class ParamTableModel
extends AbstractTableModel {
    private static final int NAME_IDX = 0;
    private static final int TYPE_IDX = 1;
    private static final int MODE_IDX = 2;
    private static final int HAS_DEF_IDX = 3;
    private static final int POSITION_POS = 1;
    private static final int NAME_POS = 2;
    private static final int LEVEL_POS = 3;
    private static final int DATA_TYPE_POS = 4;
    private static final int MODE_POS = 5;
    private static final int TYPE_LEN_POS = 6;
    private static final int TYPE_PREC_POS = 7;
    private static final int TYPE_SCALE_POS = 8;
    private static final int TYPE_OWNER_POS = 9;
    private static final int TYPE_NAME_POS = 10;
    private static final int TYPE_SUBNAME_POS = 11;
    private static final int PLS_TYPE_POS = 12;
    private String[] _headers;
    private List _paramList;
    private static final String QUERY = "SELECT POSITION, ARGUMENT_NAME, DATA_LEVEL, DATA_TYPE, IN_OUT, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, TYPE_OWNER, TYPE_NAME, TYPE_SUBNAME, PLS_TYPE FROM SYS.ALL_ARGUMENTS WHERE OWNER = ? AND OBJECT_ID = ? AND OBJECT_NAME = ? AND NVL(OVERLOAD, '0') = ? ORDER BY SEQUENCE";
    private static final String ORACLE7_QUERY = "SELECT POSITION, ARGUMENT_NAME, DATA_LEVEL, DATA_TYPE, IN_OUT, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULL, NULL, NULL, NULL FROM SYS.ALL_ARGUMENTS WHERE OWNER = ?  AND OBJECT_ID = ? AND OBJECT_NAME = ? AND NVL(OVERLOAD, '0') = ? ORDER BY SEQUENCE";
    private static final String ORACLE8_QUERY = "SELECT POSITION, ARGUMENT_NAME, DATA_LEVEL, DATA_TYPE, IN_OUT, DATA_LENGTH, DATA_PRECISION, DATA_SCALE, TYPE_OWNER, TYPE_NAME, TYPE_SUBNAME, NULL FROM SYS.ALL_ARGUMENTS WHERE OWNER = ?  AND OBJECT_ID = ? AND OBJECT_NAME = ? AND NVL(OVERLOAD, '0') = ? ORDER BY SEQUENCE";
    private static final Set FAKE_NAMES = new HashSet<String>(Arrays.asList("REF CURSOR", "PL/SQL TABLE"));
    private static final Map BOGUS_NAMES = new HashMap();

    static {
        BOGUS_NAMES.put("PL/SQL BOOLEAN", "BOOLEAN");
    }

    void $init$() {
        this._paramList = new ArrayList();
    }

    public ParamTableModel(Procedure procedure) throws SQLException {
        this();
        this._init(procedure);
    }

    public ParamTableModel() {
        this.$init$();
        this._headers = new String[4];
        this._headers[0] = RunnerArb.getString(0);
        this._headers[1] = RunnerArb.getString(1);
        this._headers[2] = RunnerArb.getString(2);
        this._headers[3] = RunnerArb.getString(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _init(Procedure procedure) throws SQLException {
        Connection connection;
        OracleDatabase oracleDatabase = procedure.getDatabase();
        String string = procedure.getOwner();
        String string2 = procedure.getName();
        int n = procedure.getOverload();
        int n2 = procedure.getObjectID();
        boolean bl = false;
        Connection connection2 = connection = oracleDatabase.getConnection();
        synchronized (connection2) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = connection.prepareStatement(ParamTableModel.getQuery(oracleDatabase));
                preparedStatement.setString(1, string);
                preparedStatement.setInt(2, n2);
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, Integer.toString(n));
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    Type type;
                    if (resultSet.getInt(3) != 0) continue;
                    String string3 = resultSet.getString(2);
                    int n3 = resultSet.getInt(1);
                    if (n3 != 0 && string3 == null) continue;
                    String string4 = resultSet.getString(12);
                    if (string4 != null) {
                        type = new Type(ParamTableModel.validateTypeName(string4));
                    } else {
                        String string5 = resultSet.getString(10);
                        if (string5 != null) {
                            string4 = "";
                            String string6 = resultSet.getString(9);
                            String string7 = resultSet.getString(11);
                            if (string6 != null) {
                                string4 = string4 + string6 + ".";
                            }
                            string4 = string4 + string5;
                            if (string7 != null) {
                                string4 = string4 + "." + string7;
                            }
                            type = new Type(string4, false);
                        } else {
                            string4 = resultSet.getString(4);
                            if (string4 == null) {
                                type = new Type("UNKOWN TYPE", false);
                            } else if (ParamTableModel.unknownType(string4)) {
                                type = new Type(null, string4, false);
                                bl = true;
                            } else {
                                type = new Type(ParamTableModel.validateTypeName(string4));
                            }
                        }
                    }
                    if (type.isCharType()) {
                        Object object = resultSet.getObject(6);
                        Number number = object instanceof Number ? (Number)((Number)object) : (Number)new Integer(200);
                        FastStringBuffer fastStringBuffer = new FastStringBuffer(type.getTypeName());
                        fastStringBuffer.append("(").append((Object)number).append(")");
                        string4 = fastStringBuffer.toString();
                        type.setTypeName(string4);
                    }
                    if (n3 == 0) {
                        this._paramList.add(new ParamImpl(type));
                        continue;
                    }
                    String string8 = resultSet.getString(5);
                    this._paramList.add(new ParamImpl(string3, type, Mode.getMode(string8), false));
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        if (bl) {
            PlsqlRoot plsqlRoot = procedure.getParseTree();
            PlsqlType[] plsqlTypeArray = this._resolveParsedProgram(plsqlRoot, procedure);
            PlsqlTypedef[] plsqlTypedefArray = ParamTableModel.getTypedefs(plsqlRoot);
            Parameter[] parameterArray = this._paramList.toArray(new Parameter[this._paramList.size()]);
            int n4 = 0;
            while (n4 < parameterArray.length) {
                Type type = parameterArray[n4].getType();
                if (type.getTypeName() == null) {
                    if (plsqlTypeArray.length == 0) {
                        type.setTypeName(type.getDeclaredName());
                    } else {
                        String string9 = plsqlTypeArray[n4].getTypeName().toString();
                        if (ParamTableModel.isLocalType(string9, plsqlTypedefArray)) {
                            string9 = ParamTableModel.getQualifiedName(string9, procedure);
                        }
                        type.setTypeName(string9);
                    }
                }
                ++n4;
            }
        }
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public int findColumn(String string) {
        int n = 0;
        while (n < this._headers.length) {
            if (this._headers[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getRowCount() {
        return this._paramList.size();
    }

    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n >= 0 && n < this.getRowCount()) {
            Parameter parameter = (Parameter)this._paramList.get(n);
            switch (n2) {
                case 0: {
                    object = parameter.getParamName();
                    break;
                }
                case 1: {
                    object = parameter.getType().getTypeName();
                    break;
                }
                case 2: {
                    object = parameter.getMode();
                    break;
                }
                case 3: {
                    object = parameter.isDefaultProvided() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                default: {
                    object = null;
                }
            }
        }
        return object;
    }

    public int getColumnCount() {
        return this._headers.length;
    }

    public String getColumnName(int n) {
        return this._headers[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Parameter getParameter(int n) {
        return (Parameter)this._paramList.get(n);
    }

    private PlsqlType[] _resolveParsedProgram(PlsqlRoot plsqlRoot, Procedure procedure) {
        PlsqlSubprg[] plsqlSubprgArray;
        PlsqlNode[] plsqlNodeArray = plsqlRoot != null ? plsqlRoot.getUnits() : null;
        int n = plsqlNodeArray != null ? plsqlNodeArray.length : 0;
        PlsqlSubprg plsqlSubprg = null;
        if (n > 0 && (plsqlSubprgArray = ParamTableModel._findProgramsByName(plsqlNodeArray[0], procedure.getName())).length > 0) {
            PlsqlSubprg plsqlSubprg2;
            int n2 = procedure.getOverload();
            plsqlSubprg = n2 == 0 ? plsqlSubprgArray[0] : (this.matches(plsqlSubprg2 = plsqlSubprgArray[n2 - 1]) ? plsqlSubprg2 : this.findMatch(plsqlSubprgArray));
        }
        return plsqlSubprg != null ? ParamTableModel.getTypeList(plsqlSubprg) : new PlsqlType[]{};
    }

    private static PlsqlSubprg[] _findProgramsByName(PlsqlNode plsqlNode, String string) {
        PlsqlSubprg[] plsqlSubprgArray = null;
        switch (plsqlNode.getTreeKind()) {
            case 18: {
                PlsqlNode[] plsqlNodeArray = ((PlsqlPkg)plsqlNode).getDeclarations();
                plsqlSubprgArray = new PlsqlSubprg[plsqlNodeArray.length];
                int n = 0;
                int n2 = 0;
                while (n2 < plsqlNodeArray.length) {
                    if (plsqlNodeArray[n2].getTreeKind() == 17 && string.equals(ParamTableModel.convertName(((PlsqlSubprg)plsqlNodeArray[n2]).getName().toString()))) {
                        plsqlSubprgArray[n++] = (PlsqlSubprg)plsqlNodeArray[n2];
                    }
                    ++n2;
                }
                if (n >= plsqlSubprgArray.length) break;
                PlsqlSubprg[] plsqlSubprgArray2 = plsqlSubprgArray;
                plsqlSubprgArray = new PlsqlSubprg[n];
                System.arraycopy(plsqlSubprgArray2, 0, plsqlSubprgArray, 0, n);
                break;
            }
            case 17: {
                PlsqlName plsqlName = ((PlsqlSubprg)plsqlNode).getName();
                if (!string.equals(ParamTableModel.convertName(plsqlName.toString()))) break;
                plsqlSubprgArray = new PlsqlSubprg[]{(PlsqlSubprg)plsqlNode};
                break;
            }
        }
        return plsqlSubprgArray != null ? plsqlSubprgArray : new PlsqlSubprg[]{};
    }

    private boolean matches(PlsqlSubprg plsqlSubprg) {
        Parameter parameter;
        boolean bl = false;
        Parameter[] parameterArray = this._paramList.toArray(new Parameter[this._paramList.size()]);
        PlsqlType plsqlType = plsqlSubprg.getReturnType();
        if (plsqlType == null == ((parameter = parameterArray.length > 0 && parameterArray[0].isReturn() ? parameterArray[0] : null) == null)) {
            Parameter[] parameterArray2;
            PlsqlVariable[] plsqlVariableArray = plsqlSubprg.getFormalParameters();
            if (parameter != null && (parameterArray = new Parameter[(parameterArray2 = parameterArray).length - 1]).length > 0) {
                System.arraycopy(parameterArray2, 1, parameterArray, 0, parameterArray.length);
            }
            if (plsqlVariableArray.length == parameterArray.length && ParamTableModel.paramsMatch(plsqlType, parameter != null ? parameter.getType() : null)) {
                bl = true;
                int n = 0;
                while (n < plsqlVariableArray.length) {
                    if (!ParamTableModel.paramsMatch(plsqlVariableArray[n].getVariableType(), parameterArray[n].getType())) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    private PlsqlSubprg findMatch(PlsqlSubprg[] plsqlSubprgArray) {
        int n = 0;
        while (n < plsqlSubprgArray.length) {
            if (this.matches(plsqlSubprgArray[n])) {
                return plsqlSubprgArray[n];
            }
            ++n;
        }
        return null;
    }

    private static boolean paramsMatch(PlsqlType plsqlType, Type type) {
        int n;
        String string;
        String string2;
        boolean bl = true;
        if (plsqlType != null && type != null && (string2 = type.getTypeName()) != null && !string2.equals(string = ParamTableModel.convertName(plsqlType.getTypeName().toString())) && !type.isOutputSupported() && (n = string2.lastIndexOf(46)) != -1) {
            string2 = string2.substring(n + 1);
            bl = string2.equals(string);
        }
        return bl;
    }

    private static PlsqlType[] getTypeList(PlsqlSubprg plsqlSubprg) {
        PlsqlType plsqlType = plsqlSubprg.getReturnType();
        PlsqlVariable[] plsqlVariableArray = plsqlSubprg.getFormalParameters();
        PlsqlType[] plsqlTypeArray = new PlsqlType[plsqlVariableArray.length + (plsqlType != null ? 1 : 0)];
        int n = 0;
        if (plsqlType != null) {
            plsqlTypeArray[n++] = plsqlType;
        }
        int n2 = 0;
        while (n2 < plsqlVariableArray.length) {
            plsqlTypeArray[n++] = plsqlVariableArray[n2].getVariableType();
            ++n2;
        }
        return plsqlTypeArray;
    }

    private static String getQuery(OracleDatabase oracleDatabase) {
        String string = null;
        int n = oracleDatabase.getOracleDatabaseType();
        switch (n) {
            case 0: {
                string = ORACLE7_QUERY;
                break;
            }
            case 1: {
                string = ORACLE8_QUERY;
                break;
            }
            default: {
                string = QUERY;
            }
        }
        return string;
    }

    private static boolean unknownType(String string) {
        return string == null || FAKE_NAMES.contains(string.toUpperCase());
    }

    private static String validateTypeName(String string) {
        String string2 = (String)BOGUS_NAMES.get(string = string.toString());
        return string2 != null ? string2 : string;
    }

    private static String convertName(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    private static PlsqlTypedef[] getTypedefs(PlsqlRoot plsqlRoot) {
        PlsqlNode plsqlNode;
        int n;
        PlsqlTypedef[] plsqlTypedefArray = null;
        PlsqlNode[] plsqlNodeArray = plsqlRoot != null ? plsqlRoot.getUnits() : null;
        int n2 = n = plsqlNodeArray != null ? plsqlNodeArray.length : 0;
        if (n > 0 && (plsqlNode = plsqlNodeArray[0]).getTreeKind() == 18) {
            PlsqlNode[] plsqlNodeArray2 = ((PlsqlPkg)plsqlNode).getDeclarations();
            plsqlTypedefArray = new PlsqlTypedef[plsqlNodeArray2.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < plsqlNodeArray2.length) {
                switch (plsqlNodeArray2[n4].getTreeKind()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        plsqlTypedefArray[n3++] = (PlsqlTypedef)plsqlNodeArray2[n4];
                        break;
                    }
                }
                ++n4;
            }
            if (n3 < plsqlTypedefArray.length) {
                PlsqlTypedef[] plsqlTypedefArray2 = plsqlTypedefArray;
                plsqlTypedefArray = new PlsqlTypedef[n3];
                if (n3 > 0) {
                    System.arraycopy(plsqlTypedefArray2, 0, plsqlTypedefArray, 0, n3);
                }
            }
        }
        return plsqlTypedefArray != null ? plsqlTypedefArray : new PlsqlTypedef[]{};
    }

    private static boolean isLocalType(String string, PlsqlTypedef[] plsqlTypedefArray) {
        boolean bl = false;
        if (string != null) {
            string = ParamTableModel.convertName(string);
            int n = 0;
            while (n < plsqlTypedefArray.length) {
                String string2 = plsqlTypedefArray[n].getName().toString();
                if (string.equals(ParamTableModel.convertName(string2))) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    private static String getQualifiedName(String string, Procedure procedure) {
        String string2 = procedure.getOwner();
        String string3 = procedure.getPackage();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
        if (ModelUtil.hasLength((String)string2)) {
            fastStringBuffer.append(string2).append('.');
        }
        if (ModelUtil.hasLength((String)string3)) {
            fastStringBuffer.append(string3).append('.');
        }
        fastStringBuffer.append(string);
        return fastStringBuffer.toString();
    }
}

