/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.runner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.browser.jdbc.PlSqlBaseNode;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.layout.BoxLayout2;
import oracle.jdevimpl.cm.dt.runner.ParamTableModel;
import oracle.jdevimpl.cm.dt.runner.Procedure;
import oracle.jdevimpl.cm.dt.runner.RunnerArb;

public class PlSqlRunnerPanel
extends JPanel {
    BorderLayout layMain;
    JSplitPane splContent;
    JSplitPane splTop;
    JPanel pnlTarget;
    JPanel pnlParams;
    JPanel pnlBlock;
    GridBagLayout layTarget;
    JLabel lblTarget;
    JScrollPane scrTarget;
    JList lstTarget;
    GridBagLayout layParams;
    JLabel lblParams;
    JScrollPane scrParams;
    GridBagLayout layBlock;
    JScrollPane scrBlock;
    JTable tblParams;
    TableColumnModel colMdl;
    BasicEditorPane txtBlock;
    JLabel lblBlock;
    ListSelectionModel selModel;
    LineGutterPlugin sqlGutter;
    LineHighlightPlugin sqlHighlite;
    JButton btnReset;
    Component glue;
    JPanel pnlButtons;
    BoxLayout2 layButtons;
    TableColumn colName;
    TableColumn colType;
    TableColumn colMode;
    private PlSqlBaseNode _node;
    private JEWTDialog _dlg;
    private static final String PACKAGE_QUERY = "SELECT DISTINCT A.OBJECT_NAME, A.OVERLOAD, A.OBJECT_ID FROM SYS.ALL_ARGUMENTS A, SYS.ALL_OBJECTS B WHERE A.OBJECT_ID = B.OBJECT_ID AND B.OWNER = ? AND B.OBJECT_NAME = ? AND B.OBJECT_TYPE = 'PACKAGE'";
    private static final String PROC_QUERY = "SELECT OBJECT_ID FROM SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_NAME = ?";
    private static final String PARSE_CODE = "DECLARE\n  cur integer;\n  txt SYS.DBMS_SQL.varchar2s;\n   len number;\nBEGIN\n  txt := ?;\n  len := ?;\n  cur := DBMS_SQL.OPEN_CURSOR;\n  DBMS_SQL.PARSE( cur, txt, 1, len, FALSE, DBMS_SQL.NATIVE );\n  DBMS_SQL.CLOSE_CURSOR( cur );EXCEPTION\nWHEN OTHERS THEN\n  DBMS_SQL.CLOSE_CURSOR( cur );  RAISE;\nEND;";

    void $init$() {
        this.layMain = new BorderLayout();
        this.splContent = new JSplitPane();
        this.splTop = new JSplitPane();
        this.pnlTarget = new JPanel();
        this.pnlParams = new JPanel();
        this.pnlBlock = new JPanel();
        this.layTarget = new GridBagLayout();
        this.lblTarget = new JLabel();
        this.scrTarget = new JScrollPane();
        this.lstTarget = new JList();
        this.layParams = new GridBagLayout();
        this.lblParams = new JLabel();
        this.scrParams = new JScrollPane();
        this.layBlock = new GridBagLayout();
        this.scrBlock = new JScrollPane();
        this.tblParams = new JTable();
        this.colMdl = new DefaultTableColumnModel();
        this.txtBlock = EditorFactory.createIdeEditorPane();
        this.lblBlock = new JLabel();
        this.selModel = new DefaultListSelectionModel();
        this.sqlHighlite = new LineHighlightPlugin();
        this.btnReset = new JButton();
        this.glue = Box.createHorizontalGlue();
        this.pnlButtons = new JPanel();
        this.layButtons = new BoxLayout2();
        this.colName = new TableColumn();
        this.colType = new TableColumn();
        this.colMode = new TableColumn();
    }

    public PlSqlRunnerPanel() {
        this.$init$();
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_run_plsql_html");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static TextBuffer runDialog(PlSqlBaseNode plSqlBaseNode, boolean bl) {
        if (!plSqlBaseNode.isValid()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)RunnerArb.getString(14), (String)RunnerArb.getString(13), null);
            return null;
        }
        PlSqlRunnerPanel plSqlRunnerPanel = new PlSqlRunnerPanel();
        plSqlRunnerPanel.setNode(plSqlBaseNode);
        String string = RunnerArb.getString(bl ? 5 : 4);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)plSqlRunnerPanel, (Component)plSqlRunnerPanel.lstTarget, (String)string);
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 5(plSqlRunnerPanel));
        jEWTDialog.setResizable(true);
        jEWTDialog.addWindowListener((WindowListener)new 4(plSqlRunnerPanel));
        plSqlRunnerPanel._dlg = jEWTDialog;
        TextBuffer textBuffer = null;
        try {
            if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                BasicDocument basicDocument = (BasicDocument)plSqlRunnerPanel.txtBlock.getDocument();
                textBuffer = basicDocument.getTextBuffer();
            }
        }
        finally {
            plSqlRunnerPanel.txtBlock.dispose();
        }
        return textBuffer;
    }

    private void _updateOK(boolean bl) {
        this._dlg.setOKButtonEnabled(bl);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.min(dimension.width, 600), dimension.height);
    }

    public void setNode(PlSqlBaseNode plSqlBaseNode) {
        this._node = plSqlBaseNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Connection connection;
        DefaultListModel<Procedure> defaultListModel = new DefaultListModel<Procedure>();
        String string = this._node.getObjectType();
        OracleDatabase oracleDatabase = (OracleDatabase)this._node.getDatabase();
        Connection connection2 = connection = oracleDatabase.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                try {
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    TextBuffer textBuffer = this._node.acquireTextBuffer();
                    PlsqlRoot plsqlRoot = PlsqlParser.parsePlsql((ReadTextBuffer)textBuffer);
                    URL uRL = this._node.getURL();
                    String string2 = CmUtil.getSchema(uRL);
                    String string3 = CmUtil.getName(uRL);
                    if ("PACKAGE".equals(string)) {
                        statement = connection.prepareStatement(PACKAGE_QUERY);
                        statement.setString(1, string2);
                        statement.setString(2, string3);
                        resultSet = statement.executeQuery();
                        boolean bl = false;
                        while (resultSet.next()) {
                            String string4 = resultSet.getString(1);
                            int n = resultSet.getInt(2);
                            int n2 = resultSet.getInt(3);
                            defaultListModel.addElement(new Procedure(string2, string3, string4, n2, n, oracleDatabase, plsqlRoot));
                        }
                    } else {
                        statement = connection.prepareStatement(PROC_QUERY);
                        statement.setString(1, string2);
                        statement.setString(2, string3);
                        resultSet = statement.executeQuery();
                        if (resultSet.next()) {
                            int n = resultSet.getInt(1);
                            defaultListModel.addElement(new Procedure(string2, string3, n, oracleDatabase, plsqlRoot));
                        }
                    }
                    this._updateOK(true);
                }
                catch (SQLException sQLException) {
                    SQLErrorDialog.showErrorDialog(this, RunnerArb.getString(9), sQLException);
                    this._updateOK(false);
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
                this._node.releaseTextBuffer();
            }
        }
        this.lstTarget.setModel(defaultListModel);
        if (defaultListModel.size() > 0) {
            this.lstTarget.setSelectedIndex(0);
        }
        this.splContent.invalidate();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layMain);
        this.layButtons.setAxis(0);
        this.pnlButtons.setLayout((LayoutManager)this.layButtons);
        this.splContent.setOrientation(0);
        this.pnlTarget.setLayout(this.layTarget);
        this.pnlParams.setLayout(this.layParams);
        this.pnlBlock.setLayout(this.layBlock);
        ResourceUtils.resLabel((JLabel)this.lblTarget, (Component)this.lstTarget, (String)RunnerArb.getString(6));
        this.scrTarget.setMinimumSize(new Dimension(150, 100));
        this.lstTarget.setSelectionModel(this.selModel);
        this.lstTarget.setVisibleRowCount(5);
        ResourceUtils.resLabel((JLabel)this.lblParams, (Component)this.tblParams, (String)RunnerArb.getString(7));
        this.txtBlock.installPlugin((EditorPlugin)this.sqlHighlite);
        this.scrBlock.setHorizontalScrollBarPolicy(32);
        this.scrBlock.setVerticalScrollBarPolicy(22);
        this.tblParams.setAutoCreateColumnsFromModel(false);
        this.colName.setModelIndex(0);
        this.colName.setPreferredWidth(220);
        this.colName.setHeaderValue(RunnerArb.getString(0));
        this.colMdl.addColumn(this.colName);
        this.colType.setModelIndex(1);
        this.colType.setPreferredWidth(110);
        this.colType.setHeaderValue(RunnerArb.getString(1));
        this.colMdl.addColumn(this.colType);
        this.colMode.setModelIndex(2);
        this.colMode.setPreferredWidth(50);
        this.colMode.setHeaderValue(RunnerArb.getString(2));
        this.colMdl.addColumn(this.colMode);
        this.tblParams.setColumnModel(this.colMdl);
        ResourceUtils.resLabel((JLabel)this.lblBlock, (Component)this.txtBlock, (String)RunnerArb.getString(8));
        this.selModel.setSelectionMode(0);
        this.selModel.addListSelectionListener(new 3());
        ResourceUtils.resButton((AbstractButton)this.btnReset, (String)RunnerArb.getString(12));
        this.btnReset.addActionListener(new 2());
        this.pnlButtons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.addHierarchyListener(new 1());
        this.pnlTarget.add((Component)this.lblTarget, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrTarget.getViewport().add((Component)this.lstTarget, null);
        this.pnlTarget.add((Component)this.scrTarget, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.splTop.add((Component)this.pnlTarget, "left");
        this.pnlParams.add((Component)this.lblParams, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrParams.getViewport().add((Component)this.tblParams, null);
        this.pnlParams.add((Component)this.scrParams, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.splTop.add((Component)this.pnlParams, "right");
        this.splContent.add((Component)this.splTop, "top");
        this.scrBlock.getViewport().add((Component)this.txtBlock, null);
        this.pnlBlock.add((Component)this.lblBlock, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBlock.add((Component)this.scrBlock, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.splContent.add((Component)this.pnlBlock, "bottom");
        this.add((Component)this.splContent, "Center");
        this.pnlButtons.add(this.glue);
        this.pnlButtons.add(this.btnReset);
        this.add((Component)this.pnlButtons, "South");
    }

    private void _resetDocument() {
        Procedure procedure = (Procedure)this.lstTarget.getSelectedValue();
        if (procedure != null) {
            procedure.resetDocument();
            this._targetChanged();
        }
    }

    private void _targetChanged() {
        Document document = this.txtBlock.getDocument();
        ParamTableModel paramTableModel = null;
        BasicDocument basicDocument = null;
        Procedure procedure = (Procedure)this.lstTarget.getSelectedValue();
        if (procedure != null) {
            try {
                paramTableModel = procedure.getTableModel();
                basicDocument = procedure.getDocument();
                this._updateOK(true);
            }
            catch (SQLException sQLException) {
                SQLErrorDialog.showErrorDialog(this, RunnerArb.getString(9), sQLException);
            }
        }
        if (paramTableModel == null || basicDocument == null) {
            paramTableModel = new ParamTableModel();
            basicDocument = new BasicDocument("foo.plsql");
            this._updateOK(false);
        }
        boolean bl = paramTableModel.getRowCount() > 0;
        this.tblParams.setEnabled(bl);
        this.lblParams.setEnabled(bl);
        if (document != basicDocument) {
            if (this.sqlGutter != null) {
                this.txtBlock.deinstallPlugin((EditorPlugin)this.sqlGutter);
            }
            this.tblParams.setModel(paramTableModel);
            this.txtBlock.setDocument((Document)basicDocument);
            this.sqlGutter = new LineGutterPlugin();
            this.txtBlock.installPlugin((EditorPlugin)this.sqlGutter);
            this.scrBlock.setRowHeaderView((Component)this.sqlGutter);
            this.txtBlock.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        }
    }

    private boolean _commit() {
        boolean bl = false;
        BasicDocument basicDocument = (BasicDocument)this.txtBlock.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        Database database = this._node.getDatabase();
        try {
            PlSqlRunnerPanel.checkPlSql(database, textBuffer);
            Procedure procedure = (Procedure)this.lstTarget.getSelectedValue();
            if (procedure != null) {
                procedure.saveDocument();
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            SQLErrorDialog.showErrorDialog(this, RunnerArb.getString(9), sQLException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkPlSql(Database database, TextBuffer textBuffer) throws SQLException {
        Connection connection;
        String string = textBuffer.getString(0, textBuffer.getLength());
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        int n2 = 0;
        while (n > 0) {
            if (n > 256) {
                arrayList.add(string.substring(n2, n2 + 256));
                n2 += 256;
                n -= 256;
                continue;
            }
            arrayList.add(string.substring(n2));
            n2 += n;
            n = 0;
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        Connection connection2 = connection = database.getConnection();
        synchronized (connection2) {
            OracleCallableStatement oracleCallableStatement = null;
            try {
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(PARSE_CODE);
                oracleCallableStatement.setPlsqlIndexTable(1, (Object)stringArray, stringArray.length, stringArray.length, 12, 256);
                oracleCallableStatement.setInt(2, stringArray.length);
                oracleCallableStatement.execute();
            }
            finally {
                if (oracleCallableStatement != null) {
                    try {
                        oracleCallableStatement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    static boolean mav$_commit(PlSqlRunnerPanel plSqlRunnerPanel) {
        return plSqlRunnerPanel._commit();
    }

    static void mav$init(PlSqlRunnerPanel plSqlRunnerPanel) {
        plSqlRunnerPanel.init();
    }

    static void mav$_targetChanged(PlSqlRunnerPanel plSqlRunnerPanel) {
        plSqlRunnerPanel._targetChanged();
    }

    static void mav$_resetDocument(PlSqlRunnerPanel plSqlRunnerPanel) {
        plSqlRunnerPanel._resetDocument();
    }

    public static final class 5
    implements VetoableChangeListener {
        private final /* synthetic */ PlSqlRunnerPanel v$panel;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && !PlSqlRunnerPanel.mav$_commit(this.v$panel)) {
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
        }

        public 5(PlSqlRunnerPanel plSqlRunnerPanel) {
            this.v$panel = plSqlRunnerPanel;
        }
    }

    public static final class 4
    extends WindowAdapter {
        private final /* synthetic */ PlSqlRunnerPanel v$panel;

        public void windowOpened(WindowEvent windowEvent) {
            PlSqlRunnerPanel.mav$init(this.v$panel);
        }

        public 4(PlSqlRunnerPanel plSqlRunnerPanel) {
            this.v$panel = plSqlRunnerPanel;
        }
    }

    public final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                PlSqlRunnerPanel.mav$_targetChanged(PlSqlRunnerPanel.this);
            }
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            PlSqlRunnerPanel.mav$_resetDocument(PlSqlRunnerPanel.this);
        }
    }

    public final class 1
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & (long)4) != 0L && PlSqlRunnerPanel.this.isShowing()) {
                PlSqlRunnerPanel.this.splContent.setDividerLocation(0.33);
                PlSqlRunnerPanel.this.splTop.setDividerLocation(0.4);
                PlSqlRunnerPanel.this.removeHierarchyListener(this);
            }
        }
    }
}

