/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.wizards;

import java.util.HashMap;
import oracle.ide.panels.Navigable;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.jdeveloper.cm.dt.ui.DBObjectEditDialog;
import oracle.jdeveloper.cm.dt.ui.DBObjectOnePageDialog;
import oracle.jdeveloper.cm.dt.ui.SequencePanel;
import oracle.jdeveloper.cm.dt.ui.SynonymPanel;
import oracle.jdeveloper.cm.dt.ui.sql.SQLQueryEditDialog;
import oracle.jdeveloper.cm.dt.ui.table.ColumnInfoPanel;
import oracle.jdeveloper.cm.dt.ui.table.IndexInfoPanel;
import oracle.jdeveloper.cm.dt.ui.table.StorageInfoPanel;
import oracle.jdeveloper.cm.dt.ui.table.TableInfoPanel;
import oracle.jdeveloper.cm.dt.ui.view.ViewInfoPanel;
import oracle.jdeveloper.cm.dt.verifier.SequenceInfoVerifier;
import oracle.jdeveloper.cm.dt.verifier.SynonymInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;
import oracle.jdevimpl.cm.dt.wizards.index.EditTopLevelIndexVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.EditColumnInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.EditConstraintInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.EditIndexInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.EditStorageInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.EditTableInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.table.TablePanelLibrary;
import oracle.jdevimpl.cm.dt.wizards.view.EditViewVerifier;

public class OracleDBObjectEditor {
    public static final String HELP_DB_SEQUENCE_INFO = "f1_dbnewsequencewizardsequenceinfo_html";
    public static final String HELP_DB_SYNONYM_INFO = "f1_dbnewsynonymwizardsynonyminfo_html";
    public static final String HELP_DB_INDEX_INFO = "f1_edit_Index_info_html";

    private OracleDBObjectEditor() {
    }

    public static boolean editSequence(OracleDatabase oracleDatabase, Sequence sequence) {
        DBObjectOnePageDialog dBObjectOnePageDialog = new DBObjectOnePageDialog();
        dBObjectOnePageDialog.registerVerifier(SequenceInfoVerifier.KEY, SequenceInfoVerifier.class);
        Namespace namespace = dBObjectOnePageDialog.createNamespace((DBObjectProvider)oracleDatabase, (SchemaObject)sequence, null);
        SequencePanel sequencePanel = new SequencePanel();
        sequencePanel.setHelpID(HELP_DB_SEQUENCE_INFO);
        boolean bl = dBObjectOnePageDialog.doOnePageEditDialog(CmWizardsArb.getString(361), sequencePanel, namespace);
        return bl;
    }

    public static boolean editSynonym(OracleDatabase oracleDatabase, Synonym synonym) {
        DBObjectOnePageDialog dBObjectOnePageDialog = new DBObjectOnePageDialog();
        dBObjectOnePageDialog.registerVerifier(SynonymInfoVerifier.KEY, SynonymInfoVerifier.class);
        Namespace namespace = dBObjectOnePageDialog.createNamespace((DBObjectProvider)oracleDatabase, (SchemaObject)synonym, null);
        SynonymPanel synonymPanel = new SynonymPanel();
        synonymPanel.setHelpID(HELP_DB_SYNONYM_INFO);
        boolean bl = dBObjectOnePageDialog.doOnePageEditDialog(CmWizardsArb.getString(373), synonymPanel, namespace);
        return false;
    }

    public static boolean editTable(OracleDatabase oracleDatabase, Table table) {
        Navigable[] navigableArray;
        DBObjectEditDialog dBObjectEditDialog = new DBObjectEditDialog();
        Navigable navigable = new Navigable(CmWizardsArb.getString(19), TableInfoPanel.class);
        navigable.setHelpID("f1_edit_table_info_html");
        dBObjectEditDialog.registerNavigable(navigable);
        dBObjectEditDialog.registerVerifier("TableInfoVerifier", EditTableInfoVerifier.class);
        dBObjectEditDialog.registerVerifier("ColumnInfoVerifier", EditColumnInfoVerifier.class);
        dBObjectEditDialog.registerVerifier("ConstraintsInfoVerifier", EditConstraintInfoVerifier.class);
        dBObjectEditDialog.registerVerifier("IndexVerifier", EditIndexInfoVerifier.class);
        dBObjectEditDialog.registerVerifier("StorageInfoVerifier", EditStorageInfoVerifier.class);
        HashMap<Class, String> hashMap = new HashMap<Class, String>();
        hashMap.put(ColumnInfoPanel.class, "f1_edit_table_col_info_html");
        hashMap.put(StorageInfoPanel.class, "f1_edit_table_store_html");
        TablePanelLibrary tablePanelLibrary = new TablePanelLibrary(hashMap);
        Navigable[] navigableArray2 = navigableArray = tablePanelLibrary.getEditNavigables(table, (DBObjectProvider)oracleDatabase);
        int n = 0;
        while (n < navigableArray2.length) {
            Navigable navigable2 = navigableArray2[n];
            dBObjectEditDialog.registerNavigable(navigable2);
            ++n;
        }
        Namespace namespace = dBObjectEditDialog.createNamespace((DBObjectProvider)oracleDatabase, (SchemaObject)table, null);
        namespace.put("PANEL_LIBRARY", (Object)tablePanelLibrary);
        namespace.put("Tablespaces", (Object)oracleDatabase.listTablespaces());
        namespace.put("DDlGenerator", (Object)oracleDatabase.getDDLGenerator());
        return dBObjectEditDialog.editObject(namespace, CmWizardsArb.getString(12), (String[])null);
    }

    public static boolean editIndex(OracleDatabase oracleDatabase, Index index) {
        DBObjectOnePageDialog dBObjectOnePageDialog = new DBObjectOnePageDialog(400, 500);
        dBObjectOnePageDialog.registerVerifier("IndexVerifier", EditTopLevelIndexVerifier.class);
        Namespace namespace = dBObjectOnePageDialog.createNamespace((DBObjectProvider)oracleDatabase, (SchemaObject)index, null);
        IndexInfoPanel indexInfoPanel = new IndexInfoPanel();
        indexInfoPanel.setHelpID(HELP_DB_INDEX_INFO);
        boolean bl = dBObjectOnePageDialog.doOnePageEditDialog(CmWizardsArb.getString(4), indexInfoPanel, namespace);
        return false;
    }

    public static boolean editView(OracleDatabase oracleDatabase, View view) {
        DBObjectEditDialog dBObjectEditDialog = new DBObjectEditDialog();
        Navigable navigable = new Navigable(CmWizardsArb.getString(285), ViewInfoPanel.class);
        navigable.setHelpID("f1_dbviewwizardviewinfo_html");
        dBObjectEditDialog.registerNavigable(navigable);
        SQLQueryEditDialog sQLQueryEditDialog = new SQLQueryEditDialog();
        dBObjectEditDialog.registerNavigable(sQLQueryEditDialog.getMasterNavigable());
        dBObjectEditDialog.registerVerifier("ViewInfoVerifier", EditViewVerifier.class);
        String string = null;
        if (!view.isDeclarative()) {
            string = CmWizardsArb.getString(294);
        }
        return dBObjectEditDialog.editObject(dBObjectEditDialog.createNamespace((DBObjectProvider)oracleDatabase, (SchemaObject)view, null), CmWizardsArb.getString(186), string);
    }
}

