/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.wizards.trigger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.verifier.trigger.TriggerVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;
import oracle.jdevimpl.cm.dt.wizards.trigger.BaseTriggerPanel;
import oracle.jdevimpl.cm.dt.wizards.trigger.DMLSubPanel;
import oracle.jdevimpl.cm.dt.wizards.trigger.TriggerPanel;

public class TableTriggerPanel
extends BaseTriggerPanel
implements ActionListener,
ItemListener {
    private GridBagLayout _layMain;
    private JPanel _pnlSub;
    private GridLayout _laySub;
    private JPanel _pnlSubLeft;
    private GridBagLayout _laySubLeft;
    private JPanel _pnlSubRight;
    private GridBagLayout _laySubRight;
    private JLabel _lblOwner;
    private JComboBox _cmbOwner;
    private DBObjectRenderer _ownerRenderer;
    private JLabel _lblTable;
    private JComboBox _cmbTable;
    private JRadioButton _radBefore;
    private JRadioButton _radAfter;
    private ButtonGroup _grpTiming;
    private JRadioButton _radStatement;
    private JRadioButton _radRow;
    private ButtonGroup _grpLevel;
    private DMLSubPanel _pnlDMLOption;
    private JLabel _lblAvail;
    private JList _lstAvail;
    private ListPicker _pckAvail;
    private JLabel _lblSel;
    private JList _lstSel;
    private ListPicker _pckSel;
    private Shuttle _shtCols;
    private JLabel _lblWhen;
    private JTextField _fldWhen;
    private HashMap _tableMap;
    private HashMap _columnMap;
    private static final BaseTriggerPanel.ModelPair DEFAULT_EMPTY_MODEL = new BaseTriggerPanel.ModelPair(new String[0], true);

    void $init$() {
        this._layMain = new GridBagLayout();
        this._pnlSub = new JPanel();
        this._laySub = new GridLayout();
        this._pnlSubLeft = new JPanel();
        this._laySubLeft = new GridBagLayout();
        this._pnlSubRight = new JPanel();
        this._laySubRight = new GridBagLayout();
        this._lblOwner = new JLabel();
        this._cmbOwner = new JComboBox();
        this._ownerRenderer = new DBObjectRenderer();
        this._lblTable = new JLabel();
        this._cmbTable = new JComboBox();
        this._radBefore = new JRadioButton();
        this._radAfter = new JRadioButton();
        this._grpTiming = new ButtonGroup();
        this._radStatement = new JRadioButton();
        this._radRow = new JRadioButton();
        this._grpLevel = new ButtonGroup();
        this._pnlDMLOption = new DMLSubPanel();
        this._lblAvail = new JLabel();
        this._lstAvail = new JList();
        this._pckAvail = new ListPicker(this._lstAvail);
        this._lblSel = new JLabel();
        this._lstSel = new JList();
        this._pckSel = new ListPicker(this._lstSel);
        this._shtCols = new Shuttle();
        this._lblWhen = new JLabel();
        this._fldWhen = new JTextField();
        this._tableMap = new HashMap();
        this._columnMap = new HashMap();
    }

    public TableTriggerPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void commit() throws TraversalException {
        Schema schema = (Schema)this._cmbOwner.getSelectedItem();
        String string = (String)this._cmbTable.getSelectedItem();
        int n = this._radBefore.isSelected() ? 0 : 1;
        boolean bl = this._radStatement.isSelected();
        ArrayList arrayList = new ArrayList();
        if (this._pnlDMLOption.isUpdateSelected() && this._lstAvail.getModel().getSize() > 0) {
            ListModel listModel = this._lstSel.getModel();
            int n2 = listModel.getSize();
            int n3 = 0;
            while (n3 < n2) {
                arrayList.add(listModel.getElementAt(n3));
                ++n3;
            }
        }
        Trigger trigger = this.getTrigger();
        trigger.setTableOwner(schema);
        trigger.setTableName(string);
        trigger.setTiming(n);
        trigger.setStatementLevel(bl);
        trigger.setColumns(arrayList);
        String string2 = this._fldWhen.getText();
        if (this._fldWhen.isEnabled() && ModelUtil.hasLength((String)string2)) {
            trigger.setWhenClause(string2);
        } else {
            trigger.setWhenClause(null);
        }
        this._pnlDMLOption.commit();
    }

    public void init(DBObjectProvider dBObjectProvider, Trigger trigger, Schema[] schemaArray, boolean bl, TriggerVerifier triggerVerifier) {
        super.init(dBObjectProvider, trigger, schemaArray, bl, triggerVerifier);
        this._cmbOwner.setModel(this.getSchemas());
        Schema schema = trigger.getTableOwner();
        if (schema == null) {
            schema = trigger.getSchema();
        }
        this._cmbOwner.setSelectedItem(schema);
        this._cmbOwner.setEnabled(bl);
        String string = trigger.getTableName();
        if (ModelUtil.hasLength((String)string)) {
            this._cmbTable.setSelectedItem(string);
        }
        this._pnlDMLOption.init(dBObjectProvider, trigger, schemaArray, bl, triggerVerifier);
        this._updateShuttle(this._pnlDMLOption.isUpdateSelected());
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layMain);
        this._pnlSub.setLayout(this._laySub);
        this._pnlSubLeft.setLayout(this._laySubLeft);
        this._pnlSubRight.setLayout(this._laySubRight);
        this._laySub.setColumns(2);
        this._laySub.setRows(1);
        this._laySub.setHgap(24);
        this._cmbOwner.setRenderer(this._ownerRenderer);
        ResourceUtils.resLabel((JLabel)this._lblOwner, (Component)this._cmbOwner, (String)CmWizardsArb.getString(210));
        this._cmbOwner.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this._lblTable, (Component)this._cmbTable, (String)CmWizardsArb.getString(211));
        this._cmbTable.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._radBefore, (String)CmWizardsArb.getString(208));
        this._grpTiming.add(this._radBefore);
        ResourceUtils.resButton((AbstractButton)this._radAfter, (String)CmWizardsArb.getString(209));
        this._grpTiming.add(this._radAfter);
        this._radBefore.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this._radStatement, (String)CmWizardsArb.getString(212));
        this._grpLevel.add(this._radStatement);
        this._radStatement.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this._radRow, (String)CmWizardsArb.getString(213));
        this._grpLevel.add(this._radRow);
        this._radStatement.setSelected(true);
        this._pnlDMLOption.addUpdateItemListener(this);
        ResourceUtils.resLabel((JLabel)this._lblAvail, (Component)this._lstAvail, (String)CmWizardsArb.getString(214));
        this._shtCols.setFromPicker((ItemPicker)this._pckAvail);
        this._lstAvail.addFocusListener(this);
        ResourceUtils.resLabel((JLabel)this._lblSel, (Component)this._lstSel, (String)CmWizardsArb.getString(215));
        this._shtCols.setToPicker((ItemPicker)this._pckSel);
        this._lstSel.addFocusListener(this);
        ResourceUtils.resLabel((JLabel)this._lblWhen, (Component)this._fldWhen, (String)CmWizardsArb.getString(216));
        this._pnlSubLeft.add((Component)this._lblOwner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSubLeft.add((Component)this._cmbOwner, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._pnlSubLeft.add((Component)this._radBefore, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSubLeft.add((Component)this._radAfter, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSubRight.add((Component)this._lblTable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSubRight.add((Component)this._cmbTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._pnlSubRight.add((Component)this._radStatement, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSubRight.add((Component)this._radRow, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._pnlSub.add((Component)this._pnlSubLeft, null);
        this._pnlSub.add((Component)this._pnlSubRight, null);
        this._shtCols.add((Component)this._lblAvail, (Object)"FromHeader");
        this._shtCols.add((Component)this._lblSel, (Object)"ToHeader");
        this.add(this._pnlSub, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this._pnlDMLOption), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this._shtCols, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._lblWhen, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this._fldWhen, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this._radStatement) {
            boolean bl = this._radStatement.isSelected() ^ true;
            this._pnlDMLOption.setReferencingEnabled(bl);
            this._fldWhen.setEnabled(bl);
        }
        this._updateShuttle(this._pnlDMLOption.isUpdateSelected());
    }

    private void _updateShuttle(boolean bl) {
        this._shtCols.setEnabled(bl);
        this._lstAvail.setEnabled(bl);
        this._lstSel.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._cmbOwner) {
            this._updateSchema((Schema)this._cmbOwner.getSelectedItem());
        } else if (object == this._cmbTable) {
            this._updateTable((Schema)this._cmbOwner.getSelectedItem(), (String)this._cmbTable.getSelectedItem());
        }
    }

    private void _updateSchema(Schema schema) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._tableMap.get(schema);
        if (defaultComboBoxModel == null) {
            defaultComboBoxModel = new NonNullableComboBoxModel();
            try {
                DBObjectProvider dBObjectProvider = this.getProvider();
                String[] stringArray = dBObjectProvider.listObjects("TABLE", schema);
                int n = 0;
                while (n < stringArray.length) {
                    defaultComboBoxModel.addElement(stringArray[n]);
                    ++n;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
            this._tableMap.put(schema, defaultComboBoxModel);
        }
        this._cmbTable.setModel(defaultComboBoxModel);
        this._updateTable(schema, (String)this._cmbTable.getSelectedItem());
    }

    private void _updateTable(Schema schema, String string) {
        String string2;
        BaseTriggerPanel.ModelPair modelPair = DEFAULT_EMPTY_MODEL;
        if (string != null && (modelPair = (BaseTriggerPanel.ModelPair)this._columnMap.get(string2 = this._getKey(schema, string))) == null) {
            Table table = null;
            try {
                DBObjectProvider dBObjectProvider = this.getProvider();
                table = (Table)dBObjectProvider.getObject("TABLE", schema, string);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (table != null) {
                Column[] columnArray = table.getColumns();
                String[] stringArray = new String[columnArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = columnArray[n].getName();
                    ++n;
                }
                modelPair = new BaseTriggerPanel.ModelPair(stringArray, true);
            }
            this._columnMap.put(string2, modelPair);
        }
        this._lstAvail.setModel(modelPair.getAvailableModel());
        this._lstSel.setModel(modelPair.getSelectedModel());
    }

    private String _getKey(Schema schema, String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        if (schema != null) {
            fastStringBuffer.append(schema.getName()).append('.');
        }
        fastStringBuffer.append(string);
        return fastStringBuffer.toString();
    }

    void setParent(TriggerPanel triggerPanel) {
        super.setParent(triggerPanel);
        this._pnlDMLOption.setParent(triggerPanel);
    }

    protected boolean getCurrentOKState() {
        return this._pnlDMLOption.getCurrentOKState() && (!this._pnlDMLOption.isUpdateSelected() || this._lstSel.getModel().getSize() > 0);
    }
}

