/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cm.dt.wizards.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.UpperCaseTextField;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.View;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.verifier.view.ViewVerifier;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;
import oracle.jdevimpl.cm.dt.wizards.view.CreateViewVerifier;

public class ViewPanel
extends BaseInfoPanel
implements VetoableChangeListener,
DocumentListener,
ItemListener {
    private BorderLayout layMain;
    private JMultiLineLabel lblTop;
    private JPanel pnlView;
    private GridBagLayout layView;
    private JLabel lblOwner;
    private JComboBox cmbOwner;
    private JTextField fldName;
    private JLabel lblName;
    private JScrollPane scrQuery;
    private JLabel lblAliases;
    private JTextField fldAliases;
    private JLabel lblCons;
    private JTextField fldCons;
    private JLabel lblQuery;
    private JTextArea txtQuery;
    private JPanel pnlRestrictions;
    private GridBagLayout layRestrictions;
    private DefaultComboBoxModel mdlOwner;
    private ButtonGroup grpRestrictions;
    private JPanel pnlOwner;
    private JLabel lblRestrictions;
    private JComboBox cmbRestrictions;
    private JCheckBox chkForce;
    private DefaultComboBoxModel mdlRestrictions;
    private DBObjectRenderer renderer;
    private View _view;
    private JEWTDialog _dlg;
    private static final String NO_RESTRICTIONS = "None";
    private static final String READ_ONLY = "Read Only";
    private static final String CHECK_OPTION = "Check Option";
    private static final String[] OPTIONS = new String[]{"None", "Read Only", "Check Option"};
    private GridLayout layOwner;
    private JCheckBox chkReplace;
    private JPanel pnlBottom;
    private GridLayout layBottom;
    private JPanel spacer;

    void $init$() {
        this.layMain = new BorderLayout();
        this.lblTop = new JMultiLineLabel();
        this.pnlView = new JPanel();
        this.layView = new GridBagLayout();
        this.lblOwner = new JLabel();
        this.cmbOwner = new JComboBox();
        this.fldName = new JTextField();
        this.lblName = new JLabel();
        this.scrQuery = new JScrollPane();
        this.lblAliases = new JLabel();
        this.fldAliases = new JTextField();
        this.lblCons = new JLabel();
        this.fldCons = new UpperCaseTextField();
        this.lblQuery = new JLabel();
        this.txtQuery = new JTextArea();
        this.pnlRestrictions = new JPanel();
        this.layRestrictions = new GridBagLayout();
        this.mdlOwner = new NonNullableComboBoxModel();
        this.grpRestrictions = new ButtonGroup();
        this.pnlOwner = new JPanel();
        this.lblRestrictions = new JLabel();
        this.cmbRestrictions = new JComboBox();
        this.chkForce = new JCheckBox();
        this.mdlRestrictions = new NonNullableComboBoxModel((Object[])OPTIONS);
        this.renderer = new DBObjectRenderer();
        this.layOwner = new GridLayout();
        this.chkReplace = new JCheckBox();
        this.pnlBottom = new JPanel();
        this.layBottom = new GridLayout();
        this.spacer = new JPanel();
    }

    public ViewPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layMain);
        this.lblTop.setText(CmWizardsArb.getString(191));
        this.pnlView.setLayout(this.layView);
        ResourceUtils.resLabel((JLabel)this.lblOwner, (Component)this.cmbOwner, (String)CmWizardsArb.getString(192));
        this.cmbOwner.setModel(this.mdlOwner);
        this.cmbOwner.setRenderer(this.renderer);
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)CmWizardsArb.getString(18));
        this.fldName.getDocument().addDocumentListener(this);
        this.txtQuery.getDocument().addDocumentListener(this);
        ResourceUtils.resLabel((JLabel)this.lblAliases, (Component)this.fldAliases, (String)CmWizardsArb.getString(194));
        this.txtQuery.setRows(6);
        ResourceUtils.resLabel((JLabel)this.lblCons, (Component)this.fldCons, (String)CmWizardsArb.getString(196));
        this.fldCons.setColumns(30);
        ResourceUtils.resLabel((JLabel)this.lblQuery, (Component)this.txtQuery, (String)CmWizardsArb.getString(193));
        this.pnlRestrictions.setLayout(this.layRestrictions);
        this.pnlOwner.setLayout(this.layOwner);
        ResourceUtils.resLabel((JLabel)this.lblRestrictions, (Component)this.cmbRestrictions, (String)CmWizardsArb.getString(195));
        this.cmbRestrictions.setModel(this.mdlRestrictions);
        this.cmbRestrictions.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.chkForce, (String)"&Force");
        this.layOwner.setHgap(24);
        this.layOwner.setColumns(2);
        this.layOwner.setRows(2);
        ResourceUtils.resButton((AbstractButton)this.chkReplace, (String)CmWizardsArb.getString(197));
        this.pnlBottom.setLayout(this.layBottom);
        this.layBottom.setColumns(2);
        this.layBottom.setHgap(24);
        this.add((Component)this.lblTop, "North");
        this.scrQuery.getViewport().add((Component)this.txtQuery, null);
        this.pnlView.add((Component)this.scrQuery, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlView.add((Component)this.lblAliases, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.pnlView.add((Component)this.fldAliases, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlView.add((Component)this.lblQuery, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlRestrictions.add((Component)this.lblCons, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 5, 12), 0, 0));
        this.pnlRestrictions.add((Component)this.fldCons, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlRestrictions.add((Component)this.lblRestrictions, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.pnlRestrictions.add((Component)this.cmbRestrictions, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlRestrictions.add((Component)this.spacer, new GridBagConstraints(3, 0, 1, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlView.add((Component)this.pnlRestrictions, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.pnlOwner.add((Component)this.lblOwner, null);
        this.pnlOwner.add((Component)this.lblName, null);
        this.pnlOwner.add((Component)this.cmbOwner, null);
        this.pnlOwner.add((Component)this.fldName, null);
        this.pnlView.add((Component)this.pnlOwner, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.chkForce, null);
        this.pnlBottom.add((Component)this.chkReplace, null);
        this.pnlView.add((Component)this.pnlBottom, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.pnlView, "Center");
    }

    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JEWTDialog) {
                this._dlg = (JEWTDialog)container;
                this._dlg.setResizable(true);
                break;
            }
            container = container.getParent();
        }
        this._updateState();
    }

    public void init(DBObjectProvider dBObjectProvider, View view, ViewVerifier viewVerifier) {
        super.init(dBObjectProvider, viewVerifier);
        this._view = view;
        try {
            Schema[] schemaArray = dBObjectProvider.listSchemas();
            int n = 0;
            while (n < schemaArray.length) {
                this.mdlOwner.addElement(schemaArray[n]);
                ++n;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        Schema schema = view.getSchema();
        int n = this.mdlOwner.getIndexOf(schema);
        if (n == -1) {
            this.mdlOwner.addElement(schema);
            n = this.mdlOwner.getIndexOf(schema);
        }
        if (this.mdlOwner.getSize() > 1) {
            Schema schema2 = (Schema)this.mdlOwner.getElementAt(n == 0 ? 1 : 0);
            this.cmbOwner.setEnabled(dBObjectProvider.hasPriviledge("VIEW", schema2, "CREATE"));
        }
        this.mdlOwner.setSelectedItem(schema);
        String string = this.getExternalName(view.getName());
        this.fldName.setText(string);
        this.cmbRestrictions.setSelectedItem(NO_RESTRICTIONS);
        this._updateState();
    }

    public boolean commit() {
        boolean bl = false;
        String string = this.txtQuery.getText();
        if (ModelUtil.hasLength((String)string)) {
            try {
                DBObjectProvider dBObjectProvider;
                Schema schema = (Schema)this.mdlOwner.getSelectedItem();
                String string2 = this.getInternalName(this.fldName.getText());
                FastStringBuffer fastStringBuffer = new FastStringBuffer();
                fastStringBuffer.append(string);
                Object object = this.cmbRestrictions.getSelectedItem();
                if (READ_ONLY.equals(object)) {
                    fastStringBuffer.append(" WITH READ ONLY");
                } else if (CHECK_OPTION.equals(object)) {
                    fastStringBuffer.append(" WITH CHECK OPTION");
                    String string3 = this.fldCons.getText();
                    if (ModelUtil.hasLength((String)string3)) {
                        fastStringBuffer.append(" CONSTRAINT ");
                        fastStringBuffer.append('\"').append(string3).append('\"');
                    }
                }
                this._view.setSchema(schema);
                this._view.setName(string2);
                this._view.setSQLQuery((SQLQuery)new NonDeclarativeSQLQuery(fastStringBuffer.toString()));
                ArrayList<Column> arrayList = new ArrayList<Column>();
                String string4 = this.fldAliases.getText();
                if (ModelUtil.hasLength((String)string4)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, ", ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        if (string5 == null || !ModelUtil.hasLength((String)(string5 = string5.trim()))) continue;
                        arrayList.add(new Column(string5));
                    }
                }
                Column[] columnArray = arrayList.toArray(new Column[arrayList.size()]);
                this._view.setColumns(columnArray);
                boolean bl2 = this.chkReplace.isSelected();
                ViewVerifier viewVerifier = (ViewVerifier)this.getVerifier();
                if (viewVerifier != null) {
                    viewVerifier.verifyView(bl2);
                }
                if ((dBObjectProvider = this.getProvider()) != null) {
                    dBObjectProvider.createObject((SchemaObject)this._view, bl2);
                    bl = true;
                }
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)this));
            }
            catch (DBException dBException) {
                Throwable throwable = dBException.getCause();
                if (throwable instanceof SQLException) {
                    SQLErrorDialog.showErrorDialog((Component)((Object)this), CmWizardsArb.getString(199), (SQLException)throwable);
                }
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(throwable != null ? throwable : dBException), (String)CmWizardsArb.getString(199), (String)CmWizardsArb.getString(198), null);
            }
        }
        return bl;
    }

    private void _updateState() {
        Object object = this.mdlRestrictions.getSelectedItem();
        this.fldCons.setEnabled(CHECK_OPTION.equals(object));
        if (this._dlg != null) {
            this._dlg.setOKButtonEnabled(ModelUtil.hasLength((String)this.txtQuery.getText()) && ModelUtil.hasLength((String)this.fldName.getText()));
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this._updateState();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this._updateState();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this._updateState();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this._updateState();
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && !this.commit()) {
            throw new PropertyVetoException("bogus", propertyChangeEvent);
        }
    }

    public static boolean createView(Context context, Database database) {
        boolean bl = false;
        View view = null;
        try {
            Schema schema = DBWizardLauncher.determineSchema(context, database);
            String string = database.getUniqueName("VIEW", (DBObject)schema, null);
            view = new View(string, schema);
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            if (throwable instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, "Error Getting Schema List", (SQLException)throwable);
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(throwable != null ? throwable : dBException), (String)"Error Getting Schema List", (String)"An error was encountered trying to get the list of schemas.", null);
            }
            boolean bl2 = false;
            return bl2;
        }
        if (view != null) {
            ViewPanel viewPanel = new ViewPanel();
            viewPanel.init((DBObjectProvider)database, view, new CreateViewVerifier((DBObjectProvider)database, view));
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)viewPanel), "f1_bdbdcreateview_html");
            bl = OnePageWizardDialogFactory.runDialog((Component)((Object)viewPanel), (Component)viewPanel.fldName, (String)CmWizardsArb.getString(185), (int)7, (VetoableChangeListener)viewPanel);
        }
        return bl;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

