/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.Set;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeRuntimeInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeThreadInfo;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

class DebugProbeBreakpoint
implements DebugBreakpoint {
    DebugProbe dp;
    String name;
    int passCount;
    DebugBreakpointCondition condition;
    String threadname;
    String threadnameNot;
    boolean enabled;
    boolean stop;
    boolean log;
    String enableOtherBPs;
    String disableOtherBPs;

    DebugProbeBreakpoint(DebugProbe debugProbe) {
        this.dp = debugProbe;
        this.stop = true;
        this.enabled = true;
        this.passCount = 1;
    }

    public void remove() {
        this.prepareForChange();
        if (this.dp != null) {
            this.dp.removeBreakpoint(this);
        }
    }

    public String getThreadname() {
        return this.threadname;
    }

    public void setThreadname(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.threadname = string;
        if (string != null && this.threadnameNot != null) {
            this.threadnameNot = null;
        }
    }

    public String getThreadnameNot() {
        return this.threadnameNot;
    }

    public void setThreadnameNot(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.threadnameNot = string;
        if (string != null && this.threadname != null) {
            this.threadname = null;
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean getStop() {
        return this.stop;
    }

    public void setStop(boolean bl) {
        this.stop = bl;
    }

    public boolean getLog() {
        return this.log;
    }

    public void setLog(boolean bl) {
        this.log = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getEnableOtherBPs() {
        return this.enableOtherBPs;
    }

    public void setEnableOtherBPs(String string) {
        this.enableOtherBPs = string;
    }

    public String getDisableOtherBPs() {
        return this.disableOtherBPs;
    }

    public void setDisableOtherBPs(String string) {
        this.disableOtherBPs = string;
    }

    public DebugBreakpointCondition getCondition() {
        return this.condition;
    }

    public void setCondition(DebugBreakpointCondition debugBreakpointCondition) {
        this.condition = debugBreakpointCondition;
    }

    public int getPassCount() {
        return this.passCount == 0 ? 1 : this.passCount;
    }

    public void setPassCount(int n) {
        this.passCount = n;
    }

    public boolean isInstanceFilterAppropriate(DebugDataObjectInfo debugDataObjectInfo, Set set) {
        return false;
    }

    public void addInstanceFilter(DebugDataObjectInfo debugDataObjectInfo) {
    }

    public void removeInstanceFilter(DebugDataObjectInfo debugDataObjectInfo) {
    }

    public void removeInstanceFilter(long l) {
    }

    public boolean isInstanceFilterSet(DebugDataObjectInfo debugDataObjectInfo) {
        return false;
    }

    public long[] getInstanceFilters() {
        return null;
    }

    public DebugLocation[] getLocations() {
        return new DebugLocation[0];
    }

    void prepareForChange() {
    }

    boolean isThisYourEvent(DebugProbeRuntimeInfo debugProbeRuntimeInfo, DebugProbeThreadInfo debugProbeThreadInfo) {
        return this.enabled && this.checkThread(debugProbeThreadInfo) && this.checkCondition(debugProbeThreadInfo) && this.checkPassCount();
    }

    boolean checkThread(DebugProbeThreadInfo debugProbeThreadInfo) {
        if (this.threadname != null) {
            return this.threadname.equals(debugProbeThreadInfo.name);
        }
        if (this.threadnameNot != null) {
            return this.threadnameNot.equals(debugProbeThreadInfo.name) ^ true;
        }
        return true;
    }

    boolean checkCondition(DebugProbeThreadInfo debugProbeThreadInfo) {
        DebugStackFrameInfo[] debugStackFrameInfoArray;
        return this.condition == null || this.condition.checkBreakpointCondition((DebugBreakpoint)this, (DebugVirtualMachine)this.dp, (DebugThreadInfo)debugProbeThreadInfo, debugStackFrameInfoArray = debugProbeThreadInfo.listStack());
    }

    boolean checkPassCount() {
        if (this.passCount > 0) {
            --this.passCount;
            if (this.dp.debugListener != null) {
                this.dp.debugListener.breakpointChanged((DebugBreakpoint)this);
            }
        }
        return this.passCount == 0;
    }
}

