/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import java.sql.Connection;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.ds.db.DatabaseFactory;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeArb;
import oracle.jdevimpl.debugger.probe.DebugProbeConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public final class DebugProbeConnector
implements DebugConnector {
    public static String getVersion() {
        return "8";
    }

    public synchronized DebugConnectArg[] getConnectArgs() {
        DebugConnectArg[] debugConnectArgArray = new DebugProbeConnectArg[]{new DebugProbeConnectArg("connection", DebugProbeArb.getString(0), "", false), new DebugProbeConnectArg("session", DebugProbeArb.getString(1), "", false)};
        return debugConnectArgArray;
    }

    public synchronized DebugVirtualMachine connect(DebugConnectArg[] debugConnectArgArray) throws Exception {
        DebugProbe debugProbe = null;
        String string = debugConnectArgArray[0].getValue();
        String string2 = debugConnectArgArray[1].getValue();
        if (string != null) {
            try {
                Database database = DatabaseFactory.createDatabase(string);
                Connection connection = database.getConnection();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("begin\n");
                stringBuffer.append("  DBMS_DEBUG.attach_session( '" + string2 + "', 0);\n");
                stringBuffer.append("  DBMS_DEBUG.probe_version(?, ?);\n");
                stringBuffer.append("  ? := DBMS_SESSION.unique_session_id;\n");
                stringBuffer.append("end;");
                String string3 = stringBuffer.toString();
                CallableStatement callableStatement = connection.prepareCall(string3);
                try {
                    callableStatement.registerOutParameter(1, 4);
                    callableStatement.registerOutParameter(2, 4);
                    callableStatement.registerOutParameter(3, 12);
                    callableStatement.execute();
                    int n = callableStatement.getInt(1);
                    int n2 = callableStatement.getInt(2);
                    String string4 = callableStatement.getString(3);
                    debugProbe = new DebugProbe(database, n, n2, string4);
                }
                finally {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return debugProbe;
    }

    public synchronized void startListening(DebugConnectArg[] debugConnectArgArray, DebugConnectionListener debugConnectionListener) throws Exception {
        throw new UnsupportedOperationException("Can not listen. Not supported.");
    }

    public synchronized void stopListening() {
        throw new IllegalStateException("Can not stop listening. Not currently listening.");
    }
}

