/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataArrayInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;

final class DebugProbeFieldInfo
implements DebugFieldInfo {
    DebugProbe dp;
    DebugProbeClassInfo declaringClass;
    String name;
    DebugProbeValue dpv;
    boolean isStatic;
    DebugProbeClassInfo classInfo;
    int stoppedCount;
    DebugProbeDataInfo dataInfo;

    DebugProbeFieldInfo(DebugProbe debugProbe, DebugProbeClassInfo debugProbeClassInfo, String string, DebugProbeValue debugProbeValue, boolean bl) {
        this.dp = debugProbe;
        this.declaringClass = debugProbeClassInfo;
        this.name = string;
        this.dpv = debugProbeValue;
        this.isStatic = bl;
        this.classInfo = debugProbe.getClassInfoForDataType(debugProbeValue);
        this.stoppedCount = debugProbe.stoppedCount;
    }

    public boolean hasExpired() {
        return this.stoppedCount != this.dp.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Field has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.classInfo;
    }

    public String getGenericSignature() {
        return null;
    }

    public DebugClassInfo getDeclaringClassInfo() {
        return this.declaringClass;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isFinal() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getAccess() {
        return 0;
    }

    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        if (this.dataInfo == null) {
            this.dataInfo = this.dpv.isArray() ? new DebugProbeDataArrayInfo(this.dp, this.classInfo, this.dpv, this) : new DebugProbeDataInfo(this.dp, this.classInfo, this.dpv, this);
        }
        return this.dataInfo;
    }

    public int hashCode() {
        return this.declaringClass.hashCode() + this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DebugProbeFieldInfo) {
            DebugProbeFieldInfo debugProbeFieldInfo = (DebugProbeFieldInfo)object;
            return ModelUtil.areEqual((Object)this.dp, (Object)debugProbeFieldInfo.dp) && ModelUtil.areEqual((Object)this.declaringClass, (Object)debugProbeFieldInfo.declaringClass) && ModelUtil.areEqual((Object)this.name, (Object)debugProbeFieldInfo.name);
        }
        return false;
    }
}

