/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import oracle.ide.util.ModelUtil;

class DebugProbeValue {
    private int result;
    private String value;
    private String type;

    DebugProbeValue(int n, String string, String string2) {
        switch (n) {
            case 0: {
                if (string2 == null || !string2.toUpperCase().startsWith("VARCHAR")) break;
                string = "'" + string + "'";
                break;
            }
            case 32: {
                string = "NULL";
                break;
            }
            case 18: {
                string = "";
            }
        }
        this.result = n;
        this.value = string;
        this.type = string2;
    }

    int getResult() {
        return this.result;
    }

    boolean isArray() {
        return this.result == 18;
    }

    String getValue() {
        return this.value;
    }

    String getType() {
        return this.type;
    }

    void setType(String string) {
        if (this.type == null) {
            this.type = string;
            if (string != null && string.toUpperCase().startsWith("VARCHAR")) {
                this.value = "'" + this.value + "'";
            }
        }
    }

    boolean isNull() {
        return this.result == 32;
    }

    boolean canModify() {
        return this.result == 0 || this.result == 32;
    }

    public int hashCode() {
        return this.result + this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DebugProbeValue) {
            DebugProbeValue debugProbeValue = (DebugProbeValue)object;
            return this.result == debugProbeValue.result && ModelUtil.areEqual((Object)this.value, (Object)debugProbeValue.value);
        }
        return false;
    }
}

