/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.runner.SimpleProcess;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionWrapper;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.deploy.common.CommandLine;

public class IasRemoteDcmConnectionWrapper
implements ConnectionWrapper {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("oracle.jdeveloper.cm.ConnectionRtBundle");
    private final ConnectionDescriptor _desc;

    IasRemoteDcmConnectionWrapper(ConnectionDescriptor connectionDescriptor) {
        this._desc = connectionDescriptor;
    }

    public ConnectionDescriptor getDescriptor() {
        return this._desc;
    }

    public Object getPresentation(String string) {
        return null;
    }

    public boolean containsPresentation(String string) {
        return "IAS_via_REMOTE_DCM".equals(string);
    }

    public Iterator getPresentationIterator() {
        return Collections.singletonList("IAS_via_REMOTE_DCM").iterator();
    }

    public void closeConnection() {
    }

    public void testPresentation(String string) throws CMException {
        ArrayList arrayList = new ArrayList();
        Map map = IasRemoteDcmConnectionWrapper.generateMacros(null, this._desc, arrayList);
        if (arrayList.size() > 0) {
            Iterator iterator = arrayList.iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next()).append("\n");
            }
            throw new CMException(stringBuffer.toString());
        }
        String string2 = "${java} -Djava.protocol.handler.pkgs=HTTPClient -jar ${Oc4jDcmClient.jar} ${dcm.servlet.url} ${username} ${password} listApplications ${remote.oracle.home}";
        CommandLine commandLine = new CommandLine();
        SimpleProcess simpleProcess = commandLine.createSimpleProcess("${java} -Djava.protocol.handler.pkgs=HTTPClient -jar ${Oc4jDcmClient.jar} ${dcm.servlet.url} ${username} ${password} listApplications ${remote.oracle.home}", map, bundle.getString("TEST_STATUS_LABEL"), "password");
        int n = simpleProcess.execAndWait();
        if (n != 0) {
            throw new CMException(MessageFormat.format(bundle.getString("TEST_FAILED"), new Integer(n), IasRemoteDcmConnectionWrapper.getErrorMessage(n)));
        }
    }

    private static String getErrorMessage(int n) {
        switch (n) {
            case 200: {
                return "Authorization failure.  Please, check your username/password.";
            }
            case -2: {
                return "Invalid Oracle Home directory";
            }
            case -3: {
                return "Invalid URL path";
            }
            case 404: {
                return "Invalid servlet path";
            }
            case 301: {
                return "Missing \"/\" at the end of the URL.";
            }
            case -4: {
                return "HTTP connection failure: unknown port number or missing HTTP listener";
            }
            case -5: {
                return "HTTP connection failure: unknown host";
            }
        }
        return "HTTP return code was " + n;
    }

    public static Map generateMacros(Project project, ConnectionDescriptor connectionDescriptor, List list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (project == null) {
            project = Ide.getDefaultProject();
        }
        String string = null;
        try {
            string = JProjectLibraries.getInstance((PropertyStorage)project).getJDK().getJavaExecutableNoConsole();
            hashMap.put("java", string);
        }
        catch (Exception exception) {
            list.add(MessageFormat.format(bundle.getString("ERROR_NO_JDK"), exception.getClass().getName()));
            list.add(bundle.getString("ERROR_NO_JDK_2"));
            exception.printStackTrace();
        }
        hashMap.put("Oc4jDcmClient.jar", new File(Ide.getLibDirectory(), "oc4j_remote_deploy.jar").getAbsolutePath());
        String string2 = connectionDescriptor.getHostname();
        if (!ModelUtil.hasLength((String)string2)) {
            list.add(bundle.getString("ERROR_NO_EM_HOSTNAME"));
        }
        String string3 = connectionDescriptor.getPort();
        int n = -1;
        if (!ModelUtil.hasLength((String)string3)) {
            list.add(bundle.getString("ERROR_NO_EM_PORT"));
        } else {
            try {
                n = Integer.parseInt(string3);
                if (n <= 0 || n > 65535) {
                    list.add(bundle.getString("ERROR_BAD_EM_PORT_NUMBER"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                list.add(bundle.getString("ERROR_BAD_NUMBER"));
            }
        }
        hashMap.put("dcm.servlet.url", IasRemoteDcmConnectionWrapper.getDcmServletURL(string2, n, connectionDescriptor.getURL()));
        String string4 = connectionDescriptor.getProperty("remote-oracle-home");
        if (!ModelUtil.hasLength((String)string4)) {
            list.add(bundle.getString("ERROR_MISSING_HOME"));
        }
        hashMap.put("remote.oracle.home", string4);
        String string5 = connectionDescriptor.getUsername();
        if (!ModelUtil.hasLength((String)string5)) {
            list.add(bundle.getString("ERROR_MISSING_USERNAME"));
        }
        hashMap.put("username", string5);
        String string6 = connectionDescriptor.getPassword();
        if (!ModelUtil.hasLength((String)string6)) {
            list.add(bundle.getString("ERROR_MISSING_PASSWORD"));
        }
        hashMap.put("password", string6);
        hashMap.put("oc4j.instance.name", connectionDescriptor.getProperty("oc4j-instance-name"));
        return hashMap;
    }

    private static String getDcmServletURL(String string, int n, String string2) {
        return ModelUtil.hasLength((String)string2) ? string2 : "http://" + string + ":" + n + "/Oc4jDcmServletAPI/";
    }
}

