/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.ds.db;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.IdeIcons;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideri.util.Product;
import oracle.jdeveloper.cm.ds.db.DBTypeDisplayRegistry;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class DefaultDBTypeRegistry
implements DBTypeDisplayRegistry {
    private static Map<String, TypeEntry> typeEntries = new HashMap<String, TypeEntry>();

    static {
        DefaultDBTypeRegistry.registerType("TABLE", ConnectionArb.getString(525), null, -1, ConnectionArb.getInstance(), 429);
        DefaultDBTypeRegistry.registerType("COLUMN", ConnectionArb.getString(540), null, -1, ConnectionArb.getInstance(), 444);
        DefaultDBTypeRegistry.registerType("INDEX", ConnectionArb.getString(536), null, -1, ConnectionArb.getInstance(), 443);
        DefaultDBTypeRegistry.registerType("SCHEMA", ConnectionArb.getString(534), null, -1, ConnectionArb.getInstance(), 422);
        DefaultDBTypeRegistry.registerType("FUNCTION", ConnectionArb.getString(522), null, -1, ConnectionArb.getInstance(), 415);
        DefaultDBTypeRegistry.registerType("PROCEDURE", ConnectionArb.getString(523), null, -1, ConnectionArb.getInstance(), 419);
        DefaultDBTypeRegistry.registerType("PACKAGE", ConnectionArb.getString(521), null, -1, ConnectionArb.getInstance(), 417);
        DefaultDBTypeRegistry.registerType("TYPE", ConnectionArb.getString(524), null, -1, ConnectionArb.getInstance(), 413);
        DefaultDBTypeRegistry.registerType("JAVA CLASS", ConnectionArb.getString(528), null, -1, ConnectionArb.getInstance(), 0);
        DefaultDBTypeRegistry.registerType("JAVA SOURCE", ConnectionArb.getString(530), null, -1, ConnectionArb.getInstance(), 0);
        DefaultDBTypeRegistry.registerType("JAVA RESOURCE", ConnectionArb.getString(529), null, -1, ConnectionArb.getInstance(), 421);
        DefaultDBTypeRegistry.registerType("JAVA", ConnectionArb.getString(528), null, -1, ConnectionArb.getInstance(), 421);
        DefaultDBTypeRegistry.registerType("SEQUENCE", ConnectionArb.getString(531), null, -1, ConnectionArb.getInstance(), 424);
        DefaultDBTypeRegistry.registerType("SYNONYM", ConnectionArb.getString(532), null, -1, ConnectionArb.getInstance(), 427);
        DefaultDBTypeRegistry.registerType("PUBLIC_SYNONYM", ConnectionArb.getString(533), null, -1, ConnectionArb.getInstance(), 427);
        DefaultDBTypeRegistry.registerType("TRIGGER", ConnectionArb.getString(527), null, -1, ConnectionArb.getInstance(), 431);
        DefaultDBTypeRegistry.registerType("BLOCK", ConnectionArb.getString(539), null, -1, ConnectionArb.getInstance(), 433);
        DefaultDBTypeRegistry.registerType("VIEW", ConnectionArb.getString(526), null, -1, ConnectionArb.getInstance(), 438);
        DefaultDBTypeRegistry.registerType("MATERIALIZED VIEW", ConnectionArb.getString(543), null, -1, ConnectionArb.getInstance(), 438);
        DefaultDBTypeRegistry.registerType("MATERIALIZED VIEW LOG", ConnectionArb.getString(544), null, -1, ConnectionArb.getInstance(), 438);
        DefaultDBTypeRegistry.registerType("RECYCLEBIN", ConnectionArb.getString(545), ConnectionArb.getInstance(), 450, IdeArb.getInstance(), 226);
        DefaultDBTypeRegistry.registerType("DATABASE LINK", ConnectionArb.getString(546), null, -1, ConnectionArb.getInstance(), 451);
        DefaultDBTypeRegistry.registerType("DIRECTORY", ConnectionArb.getString(547), null, -1, ConnectionArb.getInstance(), 421);
        DefaultDBTypeRegistry.registerType("Connections", Product.isRaptor() ? ModelArb.getString((int)44) : ConnectionArb.getString(1), null, null);
    }

    public String getDisplayName(String string) {
        TypeEntry typeEntry = typeEntries.get(string);
        return typeEntry != null ? typeEntry.getDisplayName() : string;
    }

    public Icon getNodeIcon(String string) {
        TypeEntry typeEntry = typeEntries.get(string);
        return typeEntry != null ? typeEntry.getNodeIcon() : null;
    }

    public Icon getFolderIcon(String string) {
        TypeEntry typeEntry = typeEntries.get(string);
        Icon icon = typeEntry != null ? typeEntry.getFolderIcon() : null;
        return icon != null ? icon : IdeIcons.getIcon((int)4);
    }

    public static void registerType(String string, String string2, Icon icon, Icon icon2) {
        typeEntries.put(string, new DefaultTypeEntry(string2, icon, icon2));
    }

    public static void registerType(String string, String string2, ArrayResourceBundle arrayResourceBundle, int n, ArrayResourceBundle arrayResourceBundle2, int n2) {
        typeEntries.put(string, new DeferredTypeEntry(string2, arrayResourceBundle, n, arrayResourceBundle2, n2));
    }

    private static interface TypeEntry {
        public String getDisplayName();

        public Icon getFolderIcon();

        public Icon getNodeIcon();
    }

    private static class DefaultTypeEntry
    implements TypeEntry {
        private String displayName;
        private Icon folderIcon;
        private Icon nodeIcon;
        private Class bundle;
        private String folderKey;
        private String nodeKey;

        DefaultTypeEntry(String string, Icon icon, Icon icon2) {
            this.displayName = string;
            this.folderIcon = icon;
            this.nodeIcon = icon2;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getFolderIcon() {
            return this.folderIcon;
        }

        public Icon getNodeIcon() {
            return this.nodeIcon;
        }
    }

    private static class DeferredTypeEntry
    implements TypeEntry {
        private String m_displayName;
        private ArrayResourceBundle m_folderBundle;
        private ArrayResourceBundle m_nodeBundle;
        private int m_folderKey;
        private int m_nodeKey;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = DeferredTypeEntry.class.desiredAssertionStatus() ^ true;
        }

        DeferredTypeEntry(String string, ArrayResourceBundle arrayResourceBundle, int n, ArrayResourceBundle arrayResourceBundle2, int n2) {
            if (!$assertionsDisabled && arrayResourceBundle != null && n < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && arrayResourceBundle2 != null && n2 < 0) {
                throw new AssertionError();
            }
            this.m_displayName = string;
            this.m_folderBundle = arrayResourceBundle;
            this.m_nodeBundle = arrayResourceBundle2;
            this.m_folderKey = n;
            this.m_nodeKey = n2;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public Icon getFolderIcon() {
            return this.m_folderBundle != null ? this.m_folderBundle.getIconImpl(this.m_folderKey) : null;
        }

        public Icon getNodeIcon() {
            return this.m_nodeBundle != null ? this.m_nodeBundle.getIconImpl(this.m_nodeKey) : null;
        }
    }
}

