/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.ds.db.insight;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.util.DuplexIterator;

public class BaseInsightableItem {
    private String _type;
    private String _name;
    private String _schema;
    private Map _children;
    private BaseInsightableItem _parent;
    private boolean _isChildrenLoaded;

    void $init$() {
        this._isChildrenLoaded = false;
    }

    public BaseInsightableItem(String string, String string2, String string3, BaseInsightableItem baseInsightableItem) {
        this.$init$();
        this._type = string;
        this._schema = string2;
        this._name = string3;
        this._parent = baseInsightableItem;
        this._children = new HashMap();
    }

    public BaseInsightableItem(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public void putChild(BaseInsightableItem baseInsightableItem) {
        this._isChildrenLoaded = true;
        this._children.put(baseInsightableItem.getName(), baseInsightableItem);
    }

    public BaseInsightableItem getChild(String string) {
        Object v = this._children.get(string);
        return (BaseInsightableItem)v;
    }

    public Iterator getChildrenIterator() {
        Collection collection = this._children.values();
        return collection != null ? collection.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public String getName() {
        return this._name;
    }

    public String getSchema() {
        return this._schema;
    }

    public String getType() {
        return this._type;
    }

    public boolean isChildrenLoaded() {
        return this._isChildrenLoaded;
    }

    public BaseInsightableItem getParent() {
        return this._parent;
    }

    public void setParent(BaseInsightableItem baseInsightableItem) {
        this._parent = baseInsightableItem;
    }

    public void copyChildrenTo(BaseInsightableItem baseInsightableItem) {
        Iterator iterator = this.getChildrenIterator();
        while (iterator.hasNext()) {
            baseInsightableItem.putChild((BaseInsightableItem)iterator.next());
        }
    }

    public String toString() {
        return "DEBUG: toString=[" + this._schema + "." + this._type + "." + this._name + "]";
    }

    public static Iterator getTopLevelIterator(BaseInsightableItem baseInsightableItem) {
        return new TopLevelIterator(baseInsightableItem);
    }

    public static Iterator getSchemaLevelIterator(BaseInsightableItem baseInsightableItem, String string) {
        Iterator iterator = baseInsightableItem.getChildrenIterator();
        BaseInsightableItem baseInsightableItem2 = baseInsightableItem.getChild("PUBLIC");
        BaseInsightableItem baseInsightableItem3 = baseInsightableItem.getChild(string);
        if (iterator == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        Iterator iterator2 = baseInsightableItem2 != null ? baseInsightableItem2.getChildrenIterator() : Collections.EMPTY_LIST.iterator();
        Iterator iterator3 = baseInsightableItem3 != null ? baseInsightableItem3.getChildrenIterator() : Collections.EMPTY_LIST.iterator();
        return new DuplexIterator((Iterator)new DuplexIterator(iterator3, iterator2), iterator);
    }

    public static class TopLevelIterator
    implements Iterator {
        private final BaseInsightableItem _root;
        private Iterator _topIter;
        private Iterator _childIter;

        void $init$() {
            this._topIter = null;
            this._childIter = null;
        }

        TopLevelIterator(BaseInsightableItem baseInsightableItem) {
            this.$init$();
            this._root = baseInsightableItem;
            this._topIter = this._root.getChildrenIterator();
            this._childIter = null;
        }

        public boolean hasNext() {
            return this._childIter != null && this._childIter.hasNext() || this._topIter.hasNext();
        }

        public Object next() {
            if (this._childIter == null) {
                BaseInsightableItem baseInsightableItem = (BaseInsightableItem)this._topIter.next();
                this._childIter = baseInsightableItem.getChildrenIterator();
                return baseInsightableItem;
            }
            if (this._childIter.hasNext()) {
                return this._childIter.next();
            }
            this._childIter = null;
            return this.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

