/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt;

import java.net.URL;
import java.util.StringTokenizer;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.CmJavaUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;

public final class CmUtil {
    public static final String CM_PROTOCOL = "jdev.cm";
    public static final String RC_PROTOCOL = "jdev.rc.";
    private static final String ARGUS_HEADER = "$Oracle";
    private static final int CATALOG_PART = 0;
    private static final int MP_PART = 1;
    private static final int CAT_PATH_PART = 2;
    public static final String RC_DB_PROVIDER_TYPE = "DatabaseProvider";
    private static final int RC_SCHEMA_PART = 0;
    private static final int RC_TYPE_PART = 1;
    private static final int RC_NAME_PART = 2;

    private CmUtil() {
    }

    public static final String getCatAndUser(String string, String string2) {
        try {
            String string3 = string == null ? string2 : string + "/" + string2;
            String string4 = string3;
            return string4;
        }
        catch (Exception exception) {
            return "/";
        }
    }

    public static final URL getSchemaURL(String string, String string2, String string3) {
        URL uRL = CmUtil.newCmURL(CmUtil.getCatAndUser(string2, string3) + "@" + string);
        return uRL;
    }

    public static final URL getFolderURL(String string, String string2, String string3, String string4) {
        String string5 = CmUtil.getCatAndUser(string2, string3);
        URL uRL = CmUtil.newCmURL((string5 != null ? string5 : "") + "@" + string + ":" + string4);
        return uRL;
    }

    public static final URL getNodeURL(String string, String string2, String string3, String string4, String string5) {
        return CmUtil.getNodeURL(string, string2, string3, string4, string5, "");
    }

    public static final URL getNodeURL(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = CmUtil.getCatAndUser(string2, string3);
        String string8 = string4;
        if (string6 != null && string6.length() > 0) {
            string8 = string8 + "/" + string6;
        }
        URL uRL = CmUtil.newCmURL((string7 != null ? string7 : "") + "@" + string + ":" + string8 + ":" + string5);
        return uRL;
    }

    public static final String getCatalog(URL uRL) {
        String string;
        int n;
        String string2 = null;
        if (CmUtil.isCMUrl(uRL) && (n = (string = uRL.getFile()).indexOf(47)) >= 0 && n < string.indexOf(64)) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static final String getUserName(URL uRL) {
        String string = null;
        if (CmUtil.isCMUrl(uRL)) {
            String string2 = uRL.getFile();
            int n = string2.indexOf(64);
            int n2 = string2.indexOf(47);
            if (n2 > n) {
                n2 = -1;
            }
            if (n > n2) {
                string = string2.substring(n2 + 1, n);
            }
        } else if (CmUtil.isRcDatabaseURL(uRL)) {
            string = CmUtil.getRcDatabaseURLPart(uRL, 0);
        }
        return string;
    }

    public static final String getSchema(URL uRL) {
        return CmUtil.getUserName(uRL);
    }

    public static final String getName(URL uRL) {
        String string = null;
        if (CmUtil.isCMUrl(uRL)) {
            String string2 = uRL.getFile();
            int n = string2.lastIndexOf(58);
            string = string2.substring(n + 1);
        } else if (CmUtil.isRcDatabaseURL(uRL)) {
            string = CmUtil.getRcDatabaseURLPart(uRL, 2);
        }
        return string;
    }

    public static final String getConnName(URL uRL) {
        return CmJavaUtil.getConnName((URL)uRL);
    }

    public static final URL renameConnection(URL uRL, String string) {
        String string2;
        URL uRL2 = null;
        if (uRL != null && ModelUtil.hasLength((String)(string2 = uRL.getFile())) && ModelUtil.hasLength((String)string)) {
            int n = string2.length();
            int n2 = string.length();
            int n3 = string2.indexOf(64) + 1;
            int n4 = string2.indexOf(58, n3);
            if (n4 == -1) {
                n4 = n;
            }
            char[] cArray = string2.toCharArray();
            char[] cArray2 = string.toCharArray();
            char[] cArray3 = new char[n - (n4 - n3) + n2];
            System.arraycopy(cArray, 0, cArray3, 0, n3);
            System.arraycopy(cArray2, 0, cArray3, n3, n2);
            if (n4 != n) {
                System.arraycopy(cArray, n4, cArray3, n3 + n2, n - n4);
            }
            uRL2 = CmUtil.newCmURL(new String(cArray3));
        }
        return uRL2;
    }

    public static final ConnectionNode getConnectionNode(URL uRL) {
        String string = CmUtil.getConnName(uRL);
        if (string == null) {
            return null;
        }
        return ConnectionsProvider.getInstance().getConnectionNode(string);
    }

    public static final ConnectionNode getConnectionNode(Context context) {
        Element element = context.getElement();
        return element instanceof Locatable ? CmUtil.getConnectionNode(((Locatable)element).getURL()) : null;
    }

    public static final String getDbObjectType(URL uRL) {
        int n;
        String string = CmUtil.getFullObjectType(uRL);
        if (string != null && (n = string.indexOf("/")) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static final String getSubType(URL uRL) {
        int n;
        String string = null;
        String string2 = CmUtil.getFullObjectType(uRL);
        if (string2 != null && (n = string2.indexOf("/")) != -1 && n < string2.length()) {
            string = string2.substring(n + 1);
        }
        return string;
    }

    public static final boolean isFolder(URL uRL) {
        boolean bl = false;
        if (CmUtil.isCMUrl(uRL)) {
            int n;
            String string = uRL.getFile();
            String string2 = string.substring((n = string.indexOf(58)) + 1);
            int n2 = string2.indexOf(58);
            bl = n2 == -1;
        } else if (CmUtil.isRcDatabaseURL(uRL)) {
            bl = CmUtil.getRcDatabaseURLPart(uRL, 2) == null;
        }
        return bl;
    }

    public static final boolean isCMUrl(URL uRL) {
        return CmJavaUtil.isCMUrl((URL)uRL);
    }

    public static final URL newCmURL(String string) {
        URL uRL = URLFactory.newURL((String)CM_PROTOCOL, (String)string);
        return uRL;
    }

    public static final URL argusStringToUrl(String string, String string2) {
        ArgusStringParser argusStringParser = ArgusStringParser.makeArgusStringParser(string);
        if (argusStringParser != null) {
            return CmUtil.getNodeURL(string2, null, argusStringParser.schema, argusStringParser.type, argusStringParser.programUnitName, argusStringParser.subtype);
        }
        return null;
    }

    public static final String getConnectionTypeForConnName(String string) {
        try {
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(string);
            String string2 = connectionDescriptor != null ? connectionDescriptor.getConnectionType() : "";
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static final String getFullObjectType(URL uRL) {
        String string = null;
        if (CmUtil.isCMUrl(uRL)) {
            String string2;
            int n;
            String string3 = uRL.getFile();
            int n2 = string3.indexOf(58);
            string = n2 == -1 ? (string3.indexOf(64) != -1 ? "SCHEMA" : null) : ((n = (string2 = string3.substring(n2 + 1)).indexOf(58)) == -1 ? string2 : string2.substring(0, n));
        } else if (CmUtil.isRcDatabaseURL(uRL) && (string = CmUtil.getRcDatabaseURLPart(uRL, 1)) == null && CmUtil.getRcDatabaseURLPart(uRL, 0) != null) {
            string = "SCHEMA";
        }
        return string;
    }

    public static void registerConnectionType(String string, URLFileSystemHelper uRLFileSystemHelper) {
        URLFileSystem.registerHelper((String)(RC_PROTOCOL + string), (URLFileSystemHelper)uRLFileSystemHelper);
    }

    public static final URL newRcURL(String string, String string2, String string3, String string4) {
        String string5 = RC_PROTOCOL + string;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null) {
            stringBuffer.append(string2).append(':');
        }
        stringBuffer.append(string3).append("!/");
        if (string4 != null) {
            stringBuffer.append(string4);
        }
        return URLFactory.newURL((String)string5, (String)stringBuffer.toString());
    }

    public static final boolean isRcURL(URL uRL) {
        return uRL != null && uRL.getProtocol().startsWith(RC_PROTOCOL);
    }

    public static final String getRcProviderType(URL uRL) {
        String string;
        String string2 = null;
        if (uRL != null && (string = uRL.getProtocol()).startsWith(RC_PROTOCOL)) {
            string2 = string.substring(RC_PROTOCOL.length());
        }
        return string2;
    }

    public static final String getMountPointID(URL uRL) {
        String string = null;
        if (CmUtil.isRcURL(uRL)) {
            string = CmUtil.parsePath(uRL.getPath())[1];
        }
        return string;
    }

    public static final String getRcCatalogPath(URL uRL) {
        String string = null;
        if (CmUtil.isRcURL(uRL)) {
            string = CmUtil.parsePath(uRL.getPath())[2];
        }
        return string;
    }

    private static String[] parsePath(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf("!/");
        return new String[]{n > 0 && n2 > n ? string.substring(0, n) : null, n2 > 0 && n2 > n ? string.substring(n + 1, n2) : null, n2 > 0 ? string.substring(n2 + 2) : null};
    }

    public static final boolean isRcDatabaseURL(URL uRL) {
        return ModelUtil.areEqual((Object)RC_DB_PROVIDER_TYPE, (Object)CmUtil.getRcProviderType(uRL));
    }

    private static String getRcDatabaseURLPart(URL uRL, int n) {
        String string = null;
        String string2 = CmUtil.getRcCatalogPath(uRL);
        int n2 = string2.indexOf(47);
        if (n == 0) {
            string = n2 > 0 ? string2.substring(0, n2) : string2;
        } else {
            int n3 = string2.indexOf(47, n2 + 1);
            string = n == 1 ? (n3 > 0 ? string2.substring(n2 + 1, n3) : string2.substring(n2 + 1)) : (n3 > 0 ? string2.substring(n3 + 1) : null);
        }
        return string;
    }

    private static class ArgusStringParser {
        String type;
        String subtype;
        String programUnitType;
        String programUnitName;
        String schema;

        ArgusStringParser(String string, String string2, String string3, String string4, String string5) {
            this.type = string;
            this.subtype = string2;
            this.programUnitType = string3;
            this.programUnitName = string4;
            this.schema = string5;
        }

        static ArgusStringParser makeArgusStringParser(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            int n = Math.min(stringTokenizer.countTokens(), 4);
            String[] stringArray = new String[n];
            int n2 = 0;
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n2++] = stringTokenizer.nextToken();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringArray[0].equals(CmUtil.ARGUS_HEADER)) {
                String string2;
                String string3;
                String string4 = stringArray[1];
                if (n2 > 3) {
                    string3 = stringArray[2];
                    string2 = stringArray[3];
                } else {
                    string3 = "";
                    string2 = stringArray[2];
                }
                String string5 = DBUtil.getArgusTypeForName(string4);
                String string6 = DBUtil.getArgusSubTypeForName(string4);
                return new ArgusStringParser(string5, string6, string4, string2, string3);
            }
            return null;
        }
    }
}

