/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionType;
import oracle.jdeveloper.cm.InSenHashtable;
import oracle.jdeveloper.cm.dt.BaseConnections;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;

public final class ConnectionsProvider {
    private boolean _open;
    private Map connNameMap;
    private Map connClassMap;
    private static ConnectionsProvider _instance;

    void $init$() {
        this._open = false;
        this.connNameMap = new InSenHashtable(7);
        this.connClassMap = new HashMap(7);
    }

    public static ConnectionsProvider getInstance() {
        if (_instance == null) {
            try {
                _instance = new ConnectionsProvider();
            }
            catch (SingletonClassException singletonClassException) {
                // empty catch block
            }
        }
        return _instance;
    }

    public ConnectionsProvider() throws SingletonClassException {
        this.$init$();
        if (_instance != null) {
            throw new SingletonClassException(ConnectionsProvider.class.getName());
        }
        _instance = this;
    }

    public void addConnection(String string) {
        this.addConnection(string, true);
    }

    public void addConnection(String string, boolean bl) {
        BaseConnections baseConnections = this._getParentNode(string);
        if (baseConnections != null) {
            ConnectionNode connectionNode = this.find(string);
            if (connectionNode == null) {
                connectionNode = this.create(string, baseConnections);
            }
            try {
                ConnectionManager connectionManager = ConnectionManager.getInstance();
                ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(string);
                connectionNode.setConnectionDescriptor(connectionDescriptor);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            baseConnections.add((Element)connectionNode);
            if (bl) {
                UpdateMessage.fireChildAdded((Subject)baseConnections, (Element)connectionNode);
            }
        }
    }

    public void addConnection(ConnectionDescriptor connectionDescriptor) {
        this.addConnection(connectionDescriptor.getConnectionName());
    }

    public void removeConnection(String string) {
        try {
            ConnectionNode connectionNode = this.find(string);
            if (connectionNode != null) {
                BaseConnections baseConnections = this._findParentNode(connectionNode);
                if (baseConnections != null) {
                    baseConnections.remove((Element)connectionNode);
                    UpdateMessage.fireChildRemoved((Subject)baseConnections, (Element)connectionNode);
                }
                this.remove(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeConnection(ConnectionDescriptor connectionDescriptor) {
        this.removeConnection(connectionDescriptor.getConnectionName());
    }

    public void loadConnections() {
        if (!this._open) {
            try {
                String[] stringArray = ConnectionManager.getInstance().getConnectionNames();
                this._open = true;
                int n = 0;
                while (n < stringArray.length) {
                    this.addConnection(stringArray[n], false);
                    ++n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ConnectionNode getConnectionNode(String string) {
        this.loadConnections();
        ConnectionNode connectionNode = this.find(string);
        if (connectionNode == null) {
            return null;
        }
        return connectionNode;
    }

    private ConnectionNode find(String string) {
        return (ConnectionNode)this.connNameMap.get(string);
    }

    private ConnectionNode create(String string, BaseConnections baseConnections) {
        URL uRL = CmUtil.newCmURL(string);
        ConnectionNode connectionNode = baseConnections.create(uRL);
        if (connectionNode != null) {
            this.connNameMap.put(string, connectionNode);
            NodeFactory.recache(null, (URL)uRL, (Node)connectionNode, (boolean)false);
        }
        return connectionNode;
    }

    void remove(String string) {
        this.connNameMap.remove(string);
    }

    BaseConnections _getParentNode(String string) {
        String string2 = CmUtil.getConnectionTypeForConnName(string);
        if (string2 == null) {
            return null;
        }
        ConnectionType connectionType = ConnectionManager.getInstance().getConnectionType(string2);
        if (connectionType == null) {
            return null;
        }
        String string3 = connectionType.getConnectionClassName();
        if (string3 == null) {
            return null;
        }
        return (BaseConnections)((Object)this.connClassMap.get(string3));
    }

    BaseConnections _findParentNode(ConnectionNode connectionNode) {
        for (BaseConnections baseConnections : this.connClassMap.values()) {
            if (!baseConnections.containsChild((Element)connectionNode)) continue;
            return baseConnections;
        }
        return null;
    }

    public void registerConnectionClass(String string, BaseConnections baseConnections) {
        this.connClassMap.put(string, baseConnections);
    }
}

