/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.feedback.FeedbackManager;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionEvent;
import oracle.jdeveloper.cm.ConnectionListener;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionWrapper;

public final class JdbcConnectionFactory
implements ConnectionListener {
    private Map<String, ConnectionInfo> s_conns;
    private ConnectInfoPrompter s_prompt;
    private static JdbcConnectionFactory INSTANCE;

    void $init$() {
        this.s_conns = new HashMap<String, ConnectionInfo>();
    }

    public static synchronized JdbcConnectionFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JdbcConnectionFactory();
        }
        return INSTANCE;
    }

    private JdbcConnectionFactory() {
        this.$init$();
        ConnectionManager connectionManager = ConnectionManager.getInstance();
        connectionManager.addConnectionListener((ConnectionListener)this);
    }

    public void setPrompter(ConnectInfoPrompter connectInfoPrompter) {
        this.s_prompt = connectInfoPrompter;
    }

    public Connection findConnection(String string) throws CMException {
        ConnectionInfo connectionInfo = this.findConnectionInfo(string, false);
        return connectionInfo != null ? connectionInfo.getConnection() : null;
    }

    public Connection findOrCreateConnection(String string) throws CMException {
        ConnectionInfo connectionInfo = this.findConnectionInfo(string, true);
        return connectionInfo != null ? connectionInfo.getConnection() : null;
    }

    private ConnectionInfo findConnectionInfo(String string, boolean bl) {
        ConnectionInfo connectionInfo = this.s_conns.get(string);
        if (connectionInfo == null && bl) {
            try {
                ConnectionManager connectionManager = ConnectionManager.getInstance();
                ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(string);
                if (connectionDescriptor != null) {
                    connectionInfo = new ConnectionInfo(string, connectionDescriptor);
                    this.s_conns.put(string, connectionInfo);
                }
            }
            catch (IOException iOException) {
                FeedbackManager.getFeedbackManager().reportException("Failed to resolve connection name:", (Throwable)iOException);
            }
        }
        return connectionInfo;
    }

    public Connection createConnection(String string) throws CMException {
        ConnectionInfo connectionInfo = this.findConnectionInfo(string, true);
        return connectionInfo != null ? connectionInfo.getUniqueConnection() : null;
    }

    public void closeConnection(String string) {
        ConnectionInfo connectionInfo = this.findConnectionInfo(string, false);
        if (connectionInfo != null) {
            connectionInfo.connectionClosed();
        }
    }

    private void removeConnection(String string) {
        ConnectionInfo connectionInfo = this.s_conns.get(string);
        if (connectionInfo != null) {
            connectionInfo.connectionClosed();
        }
        this.s_conns.remove(string);
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource();
        String string = connectionDescriptor.getConnectionName();
        this.removeConnection(string);
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)connectionEvent.getSource();
        ConnectionDescriptor connectionDescriptor2 = (ConnectionDescriptor)connectionEvent.getData();
        ConnectionInfo connectionInfo = this.findConnectionInfo(connectionDescriptor.getConnectionName(), false);
        if (connectionInfo != null) {
            connectionInfo.updateDescriptor(connectionDescriptor2);
        }
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    static ConnectInfoPrompter ra$s_prompt(JdbcConnectionFactory jdbcConnectionFactory) {
        return jdbcConnectionFactory.s_prompt;
    }

    private class ConnectionInfo {
        private String m_name;
        private ConnectionDescriptor m_origDesc;
        private ConnectionDescriptor m_authDesc;
        private Connection m_conn;

        ConnectionInfo(String string, ConnectionDescriptor connectionDescriptor) {
            this.setName(string);
            this.setDescriptor(connectionDescriptor);
        }

        Connection getConnection() throws CMException {
            if (this.m_conn == null) {
                this.m_conn = this.createConnection();
            }
            return this.m_conn;
        }

        Connection getUniqueConnection() throws CMException {
            return this.createConnection();
        }

        void setName(String string) {
            this.m_name = string;
        }

        void setDescriptor(ConnectionDescriptor connectionDescriptor) {
            if (ModelUtil.areDifferent((Object)this.m_origDesc, (Object)connectionDescriptor)) {
                this.m_origDesc = connectionDescriptor;
                this.m_conn = null;
            }
        }

        void connectionClosed() {
            this.m_conn = null;
            this.m_authDesc = null;
        }

        Connection createConnection() throws CMException {
            ConnectionDescriptor connectionDescriptor = this.m_authDesc;
            if (connectionDescriptor == null) {
                connectionDescriptor = (ConnectionDescriptor)this.m_origDesc.clone();
                if (JdbcConnectionFactory.ra$s_prompt(JdbcConnectionFactory.this) != null) {
                    JdbcConnectionFactory.ra$s_prompt(JdbcConnectionFactory.this).promptUser(connectionDescriptor);
                }
            }
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            ConnectionWrapper connectionWrapper = connectionManager.getConnection(connectionDescriptor, null);
            Connection connection = (Connection)connectionWrapper.getPresentation("JDBC");
            this.m_authDesc = connectionDescriptor;
            return connection;
        }

        void updateDescriptor(ConnectionDescriptor connectionDescriptor) {
            this.connectionClosed();
            this.m_origDesc = connectionDescriptor;
        }
    }
}

