/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.LazyLoadable;
import oracle.ide.model.Locatable;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.CBBaseNode;
import oracle.jdeveloper.cm.dt.browser.Filterable;
import oracle.jdeveloper.cm.dt.browser.JdbcNodeOverlayClient;
import oracle.jdeveloper.cm.dt.browser.Refreshable;
import oracle.jdeveloper.cm.dt.dialog.ExceptionDialogRunnable;

public class CBBaseFolder
extends CBBaseNode
implements Filterable,
LazyLoadable,
Refreshable,
Folder {
    protected List childNodes;

    void $init$() {
        this.childNodes = null;
    }

    public CBBaseFolder() {
        this.$init$();
    }

    public boolean add(Element element) {
        Locatable locatable;
        URL uRL;
        this.ensureOpen();
        if (element instanceof Locatable && !CmUtil.isCMUrl(uRL = (locatable = (Locatable)element).getURL())) {
            return false;
        }
        if (this.containsChild(element)) {
            return false;
        }
        return this.childNodes.add(element);
    }

    public boolean remove(Element element) {
        this.ensureOpen();
        if (this.childNodes != null) {
            return this.childNodes.remove(element);
        }
        return false;
    }

    public void removeAll(boolean bl) {
        this.ensureOpen();
        if (this.childNodes == null) {
            return;
        }
        if (bl && this.childNodes.size() > 0) {
            UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CHILD_REMOVED, (Object)this);
            updateMessage.getRemoveObjects().addAll(this.childNodes);
            this.notifyObservers(this, updateMessage);
        }
        try {
            this.childNodes.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public boolean canAdd(Element element) {
        return false;
    }

    public boolean canRemove(Element element) {
        return false;
    }

    public boolean containsChild(Element element) {
        this.ensureOpen();
        if (this.childNodes != null) {
            return this.childNodes.contains(element);
        }
        return false;
    }

    public int size() {
        this.ensureOpen();
        if (this.childNodes != null) {
            return this.childNodes.size();
        }
        return 0;
    }

    public void removeAll() {
        this.removeAll(false);
    }

    public Icon getIcon() {
        return null;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    protected void closeImpl() throws IOException {
        this.childNodes = null;
        super.closeImpl();
    }

    public void refresh() {
        ReadWriteLock readWriteLock = this._getReadWriteLockInternal();
        readWriteLock.writeLock();
        try {
            try {
                this.childNodes = null;
                this._loadChildren();
                UpdateMessage.fireStructureChanged((Subject)this);
            }
            catch (IOException iOException) {
                EventQueue.invokeLater(new ExceptionDialogRunnable(iOException));
            }
        }
        finally {
            readWriteLock.writeUnlock();
        }
    }

    protected void openImpl() throws IOException {
        super.openImpl();
        if (this.childNodes == null) {
            this._loadChildren();
        }
    }

    private void _loadChildren() throws IOException {
        1 var1_1 = new 1();
        var1_1.setTitle(ConnectionArb.getString(455));
        var1_1.setMessage(this._getLoadingMessage());
        var1_1.setCancelable(true);
        try {
            var1_1.start(this.loadInThread());
        }
        catch (ProgressException progressException) {
            Exception exception = (Exception)progressException.getCause();
            IOException iOException = exception instanceof IOException ? (IOException)exception : new ExceptionWrapper(exception, null);
            throw iOException;
        }
    }

    public boolean canBeFiltered() {
        return false;
    }

    public boolean isFiltered() {
        return false;
    }

    public final synchronized Iterator getChildren() {
        this.ensureOpen();
        return CBBaseFolder._getSafeIterator(this.childNodes);
    }

    private static final Iterator _getSafeIterator(List list) {
        return list == null ? Collections.EMPTY_LIST.iterator() : list.iterator();
    }

    protected List getChildrenList() throws CMException {
        return Collections.EMPTY_LIST;
    }

    protected String _getLoadingMessage() {
        return ConnectionArb.getString(456);
    }

    protected void updateTracker() {
        IconOverlayTracker iconOverlayTracker = JdbcNodeOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay((Element)this);
            iconOverlayTracker.repaintOverlays();
        }
    }

    protected boolean loadInThread() {
        return true;
    }

    protected Element findChild(URL uRL) {
        this.ensureOpen();
        if (this.childNodes != null) {
            for (Element element : this.childNodes) {
                if (!(element instanceof Locatable) || !ModelUtil.areEqual((Object)((Locatable)element).getURL(), (Object)uRL)) continue;
                return element;
            }
        }
        return null;
    }

    protected void reportOpenException(Exception exception) {
        if (exception instanceof ExceptionWrapper) {
            exception = (Exception)exception.getCause();
        }
        Exception exception2 = exception;
        IdeUtil.runNow((Runnable)new ExceptionDialogRunnable(exception2));
    }

    public final class oracle.jdeveloper.cm.dt.browser.CBBaseFolder$1
    extends ProgressRunnable {
        protected Object doWork() throws CMException {
            return CBBaseFolder.this.getChildrenList();
        }

        protected void finish(Object object) {
            if (object instanceof List) {
                CBBaseFolder.this.childNodes = (List)object;
            } else {
                try {
                    CBBaseFolder.this.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                SwingUtilities.invokeLater(new 1());
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                UpdateMessage.fireObjectClosed((Subject)CBBaseFolder.this);
            }
        }
    }

    private static class ExceptionWrapper
    extends IOException {
        private ExceptionWrapper(Exception exception) {
            this.initCause(exception);
        }

        ExceptionWrapper(Exception exception, 1 var2_2) {
            this(exception);
        }

        public final class 1 {
        }
    }
}

