/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.j2ee;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.swing.SwingUtilities;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.Refreshable;
import oracle.jdeveloper.cm.dt.browser.j2ee.J2EENodeFactory;
import oracle.jdeveloper.cm.dt.browser.j2ee.Jsr77Exception;
import oracle.jdeveloper.cm.dt.browser.j2ee.ManagedObjectNode;
import oracle.jdeveloper.cm.dt.dialog.ExceptionDialogRunnable;

abstract class ManagedObjectFolder
extends ManagedObjectNode
implements Refreshable,
Folder {
    protected List _children;

    public final Iterator getChildren() {
        this.ensureOpen();
        return this._children != null ? this._children.iterator() : Collections.EMPTY_LIST.iterator();
    }

    protected final void openImpl() throws IOException {
        super.openImpl();
        if (this.mayHaveChildren() && this._children == null) {
            this._children = this.loadChildren(new 3());
        }
    }

    protected void closeImpl() throws IOException {
        this._children = null;
        super.closeImpl();
    }

    public void refresh() {
        if (this.isOpen()) {
            ArrayList arrayList = new ArrayList(this._children);
            this._children = this.loadChildren(new 2(this, arrayList));
        }
    }

    protected static void recursiveClose(ManagedObjectNode managedObjectNode, boolean bl) {
        if (managedObjectNode.isOpen()) {
            Iterator iterator = managedObjectNode.getChildren();
            while (iterator.hasNext()) {
                ManagedObjectNode managedObjectNode2 = (ManagedObjectNode)iterator.next();
                ManagedObjectFolder.recursiveClose(managedObjectNode2, bl);
            }
            try {
                managedObjectNode.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (bl) {
                SwingUtilities.invokeLater(new 1(managedObjectNode));
            }
        }
    }

    protected List getChildList() throws Jsr77Exception {
        return Collections.EMPTY_LIST;
    }

    protected boolean loadInThread() {
        return true;
    }

    protected String getLoadingMessage() {
        return "Loading...";
    }

    protected ObjectName[] getChildObjects(String string) throws Jsr77Exception {
        ObjectName[] objectNameArray = new ObjectName[]{};
        Object object = this.getAttributeValue(string);
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            objectNameArray = new ObjectName[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectNameArray[n] = this.convertToObjectName(objectArray[n]);
                ++n;
            }
        } else {
            objectNameArray = new ObjectName[]{this.convertToObjectName(object)};
        }
        return objectNameArray;
    }

    protected List createChildList(String string) throws Jsr77Exception {
        ArrayList<ManagedObjectNode> arrayList = new ArrayList<ManagedObjectNode>();
        ObjectName[] objectNameArray = this.getChildObjects(string);
        int n = 0;
        while (n < objectNameArray.length) {
            ManagedObjectNode managedObjectNode;
            if (objectNameArray[n] != null && (managedObjectNode = this.findOrCreateNode(objectNameArray[n])) != null) {
                arrayList.add(managedObjectNode);
            }
            ++n;
        }
        return arrayList;
    }

    protected ManagedObjectNode findOrCreateNode(ObjectName objectName) throws Jsr77Exception {
        return J2EENodeFactory.createJ2EENode(objectName, this.getServer(), CmUtil.getConnName(this.getURL()));
    }

    protected ManagedObjectNode findNode(ObjectName objectName) throws Jsr77Exception {
        return J2EENodeFactory.findJ2EENode(objectName, CmUtil.getConnName(this.getURL()));
    }

    public boolean add(Element element) {
        this.ensureOpen();
        return this._children != null && this._children.add(element);
    }

    public boolean canAdd(Element element) {
        this.ensureOpen();
        return this._children != null && !this._children.contains(element);
    }

    public boolean canRemove(Element element) {
        return this.containsChild(element);
    }

    public boolean containsChild(Element element) {
        this.ensureOpen();
        return this._children != null && this._children.contains(element);
    }

    public boolean remove(Element element) {
        this.ensureOpen();
        return this._children != null && this._children.remove(element);
    }

    public void removeAll() {
        this._children.clear();
    }

    public int size() {
        this.ensureOpen();
        return this._children != null ? this._children.size() : 0;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    protected List loadChildren(LoadFinishCallback loadFinishCallback) {
        List list = new ArrayList();
        ChildRunnable childRunnable = new ChildRunnable(list, loadFinishCallback, null);
        try {
            childRunnable.start(this.loadInThread());
        }
        catch (ProgressException progressException) {
            EventQueue.invokeLater(new ExceptionDialogRunnable(progressException.getCause()));
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    ManagedObjectFolder() {
    }

    final class 3
    implements LoadFinishCallback {
        public void finishLoading(List list) {
            boolean bl;
            boolean bl2 = bl = list != null;
            if (!bl) {
                try {
                    ManagedObjectFolder.this.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            ManagedObjectFolder managedObjectFolder = ManagedObjectFolder.this;
            SwingUtilities.invokeLater(new 1(this, bl, (Subject)managedObjectFolder));
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ boolean v$success;
            private final /* synthetic */ Subject v$subject;
            final /* synthetic */ 3 this$0;

            public void run() {
                if (this.v$success) {
                    UpdateMessage.fireObjectOpened((Subject)this.v$subject);
                } else {
                    UpdateMessage.fireObjectClosed((Subject)this.v$subject);
                }
            }

            public 1(3 var1_1, boolean bl, Subject subject) {
                this.v$subject = subject;
                this.v$success = bl;
                this.this$0 = var1_1;
            }
        }
    }

    final class 2
    implements LoadFinishCallback {
        private final /* synthetic */ List v$oldChildren;
        final /* synthetic */ ManagedObjectFolder this$0;

        public void finishLoading(List list) {
            if (list != null) {
                for (Object e : list) {
                    this.v$oldChildren.remove(e);
                }
            }
            Iterator iterator = this.v$oldChildren.iterator();
            while (iterator.hasNext()) {
                ManagedObjectFolder.recursiveClose((ManagedObjectNode)iterator.next(), false);
            }
        }

        public 2(ManagedObjectFolder managedObjectFolder, List list) {
            this.v$oldChildren = list;
            this.this$0 = managedObjectFolder;
        }
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ ManagedObjectNode v$node;

        public void run() {
            UpdateMessage.fireObjectClosed((Subject)this.v$node);
        }

        public 1(ManagedObjectNode managedObjectNode) {
            this.v$node = managedObjectNode;
        }
    }

    private interface LoadFinishCallback {
        public void finishLoading(List var1);
    }

    private class ChildRunnable
    extends ProgressRunnable {
        private List _children;
        private LoadFinishCallback _cb;

        private ChildRunnable(List list, LoadFinishCallback loadFinishCallback) {
            this._children = list;
            this._cb = loadFinishCallback;
            this.setTitle(ConnectionArb.getString(455));
            this.setMessage(ManagedObjectFolder.this.getLoadingMessage());
            this.setCancelable(true);
        }

        protected Object doWork() throws Jsr77Exception {
            return ManagedObjectFolder.this.getChildList();
        }

        protected final void finish(Object object) {
            List list = null;
            if (object instanceof List) {
                list = (List)object;
                this._children.addAll(list);
            }
            if (this._cb != null) {
                this._cb.finishLoading(list);
            }
        }

        ChildRunnable(List list, LoadFinishCallback loadFinishCallback, 1 var4_4) {
            this(list, loadFinishCallback);
        }

        public final class 1 {
        }
    }
}

