/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.jdbc;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionFilter;
import oracle.jdeveloper.cm.dt.browser.CBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;

public abstract class OCBBaseFolder
extends CBBaseFolder {
    private Database _db;
    private String _dbObjectType;
    private ConnectionFilter _filter;

    protected OCBBaseFolder(URL uRL, Database database) {
        this._db = database;
        this._dbObjectType = CmUtil.getDbObjectType(uRL);
        this.setName(DBUtil.getDisplayName(this._dbObjectType));
        this.setURL(uRL);
        this.loadCachedFilter();
    }

    public Database getDatabase() {
        return this._db;
    }

    public String getObjectType() {
        return this._dbObjectType;
    }

    public Icon getIcon() {
        return DBUtil.getFolderIcon(this._dbObjectType);
    }

    public final void setFilter(ConnectionFilter connectionFilter) {
        if (ModelUtil.areDifferent((Object)this._filter, (Object)connectionFilter)) {
            this._filter = connectionFilter;
            this.updateCache();
            this.updateTracker();
        }
    }

    public final ConnectionFilter getFilter() {
        return this._filter;
    }

    public boolean canBeFiltered() {
        return true;
    }

    public boolean isFiltered() {
        return this._filter != null;
    }

    public Node createChild(String string) {
        URL uRL = this.getURL();
        URL uRL2 = CmUtil.getNodeURL(CmUtil.getConnName(uRL), CmUtil.getCatalog(uRL), CmUtil.getUserName(uRL), this._dbObjectType, string);
        return JdbcNodeFactory.getNode(this._db, uRL2);
    }

    protected ConnectionFilter getDefaultFilter() {
        return null;
    }

    private final void updateCache() {
        ConnectionOptions connectionOptions = (ConnectionOptions)((Object)Ide.getSettings().getData("ConnectionOptions"));
        if (connectionOptions != null) {
            URL uRL = this.getURL();
            ConnectionFilter connectionFilter = this.getFilter();
            if (connectionFilter == null) {
                connectionOptions.uncacheFilter(uRL);
            } else {
                connectionOptions.cacheFilter(uRL, connectionFilter);
            }
        }
    }

    private final void loadCachedFilter() {
        ConnectionOptions connectionOptions = (ConnectionOptions)((Object)Ide.getSettings().getData("ConnectionOptions"));
        if (connectionOptions != null) {
            URL uRL = this.getURL();
            ConnectionFilter connectionFilter = connectionOptions.getFilter(uRL);
            if (connectionFilter == null) {
                connectionFilter = this.getDefaultFilter();
            }
            this.setFilter(connectionFilter);
        }
    }
}

