/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.jdbc;

import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import oracle.ide.model.Node;
import oracle.ide.util.ModelUtil;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionFilter;
import oracle.jdeveloper.cm.dt.browser.jdbc.JdbcNodeFactory;
import oracle.jdeveloper.cm.dt.browser.jdbc.OCBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.jdbc.ObjectFilter;

public class ObjectFolder
extends OCBBaseFolder {
    public static final String NO_FILTER = "%";
    private boolean _showAll;
    private static Comparator<SchemaObject> COMP = new 1();

    public ObjectFolder(URL uRL, Database database) {
        super(uRL, database);
    }

    public String getShortLabel() {
        String string = this.getName();
        if (Product.isRaptor() && this.isFiltered()) {
            ObjectFilter objectFilter = (ObjectFilter)this.getFilter();
            string = ConnectionArb.format(701, string, objectFilter.getFilter());
        }
        return string;
    }

    public boolean isFiltered() {
        ConnectionFilter connectionFilter = this.getFilter();
        return connectionFilter instanceof ObjectFilter && ModelUtil.areDifferent((Object)NO_FILTER, (Object)((ObjectFilter)connectionFilter).getFilter());
    }

    public boolean isShowAll() {
        return this._showAll;
    }

    public void setShowAll(boolean bl) {
        this._showAll = bl;
    }

    protected final SchemaObject[] getObjects(String string) throws CMException {
        Database database = this.getDatabase();
        String string2 = this.getChildType();
        ConnectionFilter connectionFilter = this.getFilter();
        String string3 = connectionFilter instanceof ObjectFilter ? ((ObjectFilter)connectionFilter).getFilter() : null;
        SchemaObject[] schemaObjectArray = null;
        try {
            schemaObjectArray = database.listObjects(new String[]{string2}, database.getSchema(string), ModelUtil.hasLength((String)string3) ? string3 : NO_FILTER);
            if (string == null) {
                string = database.getUserName();
            }
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            if (throwable instanceof Exception) {
                throw new CMException((Exception)throwable);
            }
            throw new CMException((Exception)((Object)dBException));
        }
        if (schemaObjectArray == null) {
            return null;
        }
        return schemaObjectArray;
    }

    protected final void createNodes(String string, SchemaObject[] schemaObjectArray, List list) {
        Database database = this.getDatabase();
        String string2 = this.getChildType();
        String string3 = CmUtil.getConnName(this.getURL());
        int n = schemaObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL uRL = CmUtil.getNodeURL(string3, null, string, string2, schemaObjectArray[n2].getName());
            Node node = JdbcNodeFactory.getNode(database, uRL);
            if (node != null) {
                list.add(node);
            }
            ++n2;
        }
    }

    protected List getChildrenList() throws CMException {
        String string = CmUtil.getUserName(this.getURL());
        SchemaObject[] schemaObjectArray = this.getObjects(string);
        if (schemaObjectArray == null) {
            return null;
        }
        Arrays.sort(schemaObjectArray, COMP);
        ArrayList arrayList = new ArrayList(schemaObjectArray.length);
        this.createNodes(string, schemaObjectArray, arrayList);
        return arrayList;
    }

    protected String getChildType() {
        return this.getObjectType();
    }

    public static final class 1
    implements Comparator {
        Collator _collator;

        void $init$() {
            this._collator = Collator.getInstance();
        }

        public int compare(SchemaObject schemaObject, SchemaObject schemaObject2) {
            return schemaObject == schemaObject2 ? 0 : this._collator.compare(schemaObject.getName(), schemaObject2.getName());
        }

        public boolean equals(Object object) {
            return object instanceof Comparator;
        }

        public 1() {
            this.$init$();
        }
    }
}

