/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.browser.jndi;

import com.evermind.server.administration.ApplicationServerAdministrator;
import java.awt.Window;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.ds.jndi.JndiDatasource;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.browser.CBBaseFolder;
import oracle.jdeveloper.cm.dt.browser.jndi.JndiObjectFolder;

public class JndiApplicationsFolder
extends JndiObjectFolder {
    public JndiApplicationsFolder(String string, Context context) {
        super(new JndiDatasource(string, context), context, JndiDatasource.getDisplayName(), "/");
    }

    protected List getChildrenList() {
        ArrayList<CBBaseFolder> arrayList = null;
        Context context = this.getContext();
        try {
            ApplicationServerAdministrator applicationServerAdministrator = (ApplicationServerAdministrator)context.lookup("java:comp/ServerAdministrator");
            if (applicationServerAdministrator != null) {
                arrayList = new ArrayList<CBBaseFolder>();
                Hashtable<?, ?> hashtable = context.getEnvironment();
                String string = applicationServerAdministrator.getDefaultApplicationName();
                if (string != null) {
                    String string2 = ConnectionArb.format(583, string);
                    arrayList.add(this.createApplicationFolder(string, hashtable, string2));
                }
                Iterator iterator = applicationServerAdministrator.getApplicationNames().iterator();
                while (iterator.hasNext()) {
                    arrayList.add(this.createApplicationFolder((String)iterator.next(), hashtable));
                }
            } else {
                arrayList = super.getChildrenList();
            }
        }
        catch (NamingException namingException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)namingException);
        }
        catch (RemoteException remoteException) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)remoteException);
        }
        return arrayList;
    }

    public Icon getIcon() {
        return null;
    }

    private CBBaseFolder createApplicationFolder(String string, Hashtable hashtable) throws NamingException {
        return this.createApplicationFolder(string, hashtable, string);
    }

    private CBBaseFolder createApplicationFolder(String string, Hashtable hashtable, String string2) throws NamingException {
        Hashtable hashtable2 = new Hashtable(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = hashtable.get(k);
            if ("java.naming.provider.url".equals(k)) {
                String string3 = (String)object;
                if (!string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                string3 = string3 + string;
                object = string3;
            }
            hashtable2.put(k, object);
        }
        InitialContext initialContext = new InitialContext(hashtable2);
        JndiObjectFolder jndiObjectFolder = new JndiObjectFolder(new JndiDatasource(this.getDatasource().getConnectionName(), initialContext), initialContext, string2, "/");
        return jndiObjectFolder;
    }
}

