/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.controls;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.controls.ResultSetTableModel;
import oracle.jdeveloper.cm.dt.controls.ResultSetTableModelBuffer;

final class EditableResultSetTableModel
extends ResultSetTableModel {
    private String _tablename;
    private Statement _stmt;
    private ResultSetMetaData _rsmd;
    private ArrayList _log;
    private boolean _insertOnly;
    private Database _db;
    private boolean _changed;
    private boolean _valid;

    void $init$() {
        this._tablename = null;
        this._valid = true;
    }

    public EditableResultSetTableModel(Connection connection, ResultSet resultSet, String string, Database database) {
        super(connection, resultSet, string);
        this.$init$();
        this._db = database;
        this._tablename = string.substring(14, string.length());
        StringBuffer stringBuffer = new StringBuffer(this._tablename);
        while (stringBuffer.toString().indexOf(34) != -1) {
            stringBuffer.deleteCharAt(stringBuffer.toString().indexOf(34));
        }
        this._tablename = stringBuffer.toString();
        try {
            this._rsmd = this._rs.getMetaData();
        }
        catch (Exception exception) {
            this._valid = false;
            this._rsmd = null;
        }
        this._stmt = null;
        this._log = new ArrayList();
        this._insertOnly = false;
        this._changed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        if (this._rows != null) {
            Object e;
            if (n >= this._rows.size()) {
                Object object = this.LOCK;
                synchronized (object) {
                    if (this._worker == null) {
                        this._fetchNext(n - this._rows.size());
                    }
                }
            }
            if (n < this._rows.size() && (e = this._rows.get(n)) != null) {
                ArrayList arrayList = null;
                if (e instanceof ResultSetTableModelBuffer) {
                    ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
                    if (n2 == 0 && resultSetTableModelBuffer.getChanged()) {
                        return new String("*" + (n + 1));
                    }
                    arrayList = resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getNew() ? resultSetTableModelBuffer.getChangedRow() : resultSetTableModelBuffer.getOriginalRow();
                } else {
                    arrayList = (ArrayList)e;
                }
                if (n2 == 0) {
                    return new Integer(n + 1);
                }
                if (arrayList != null) {
                    return arrayList.get(n2 - 1);
                }
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            return false;
        }
        return !this._insertOnly || this.isRowNew(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object object, int n, int n2) {
        if (!this._valid) {
            return;
        }
        if (this._rows != null && n >= this._rows.size()) {
            Object object2 = this.LOCK;
            synchronized (object2) {
                if (this._worker == null) {
                    this._fetchNext(n - this._rows.size());
                }
            }
        }
        if (n2 == 0) {
            return;
        }
        if (n < this._rows.size()) {
            ArrayList arrayList = null;
            Object e = this._rows.get(n);
            ResultSetTableModelBuffer resultSetTableModelBuffer = null;
            if (e != null) {
                Object var7_8 = null;
                if (e instanceof ResultSetTableModelBuffer) {
                    resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
                    arrayList = resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getNew() ? resultSetTableModelBuffer.getChangedRow() : (ArrayList)resultSetTableModelBuffer.getOriginalRow().clone();
                } else {
                    ArrayList arrayList2 = (ArrayList)e;
                    arrayList = (ArrayList)arrayList2.clone();
                    resultSetTableModelBuffer = new ResultSetTableModelBuffer((ArrayList)e);
                }
            }
            if (!(arrayList == null || arrayList.get(n2 - 1) != null && arrayList.get(n2 - 1).equals(object))) {
                arrayList.set(n2 - 1, object);
                resultSetTableModelBuffer.setChangedRow(arrayList);
                resultSetTableModelBuffer.setChanged(true);
                resultSetTableModelBuffer.setError(false);
                this._rows.set(n, resultSetTableModelBuffer);
                this._changed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int save() {
        if (!this._valid) {
            return 1;
        }
        int n = 0;
        this._log.clear();
        Connection connection = this._conn;
        synchronized (connection) {
            int n2;
            boolean bl = true;
            try {
                bl = this._conn.getAutoCommit();
                this._conn.setAutoCommit(false);
                this._stmt = this._conn.createStatement();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this._insertOnly) {
                n2 = 0;
                while (n2 < this._rows.size()) {
                    ResultSetTableModelBuffer resultSetTableModelBuffer;
                    Object e = this._rows.get(n2);
                    if (e != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getDeleted() && !resultSetTableModelBuffer.getNew() && !this.deleteRow(resultSetTableModelBuffer)) {
                        ++n;
                    }
                    ++n2;
                }
                n2 = 0;
                while (n2 < this._rows.size()) {
                    ResultSetTableModelBuffer resultSetTableModelBuffer;
                    Object e = this._rows.get(n2);
                    if (e != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getChanged() && !resultSetTableModelBuffer.getNew() && !resultSetTableModelBuffer.getDeleted() && !this.updateRow(resultSetTableModelBuffer)) {
                        ++n;
                    }
                    ++n2;
                }
            }
            n2 = 0;
            while (n2 < this._rows.size()) {
                ResultSetTableModelBuffer resultSetTableModelBuffer;
                Object e = this._rows.get(n2);
                if (e != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getNew() && resultSetTableModelBuffer.getChanged() && !resultSetTableModelBuffer.getDeleted() && !this.insertRow(resultSetTableModelBuffer)) {
                    ++n;
                }
                ++n2;
            }
            boolean bl2 = true;
            if (n > 0) {
                bl2 = false;
                try {
                    this._conn.rollback();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            } else {
                try {
                    if (!this._conn.getAutoCommit()) {
                        this._conn.commit();
                    }
                }
                catch (SQLException sQLException) {
                    bl2 = false;
                    n = 1;
                }
            }
            if (bl2) {
                this.clearChanges();
                this._changed = false;
            }
            this.fireTableDataChanged();
            try {
                this._conn.setAutoCommit(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public int rollback() {
        if (!this._valid) {
            return 1;
        }
        int n = 0;
        this._log.clear();
        int n2 = this._rows.size() - 1;
        while (n2 >= 0) {
            Object e = this._rows.get(n2);
            if (e != null && e instanceof ResultSetTableModelBuffer) {
                ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
                if (resultSetTableModelBuffer.getNew()) {
                    this._rows.remove(n2);
                } else {
                    resultSetTableModelBuffer.setChangedRow(null);
                    resultSetTableModelBuffer.setChanged(false);
                    resultSetTableModelBuffer.setError(false);
                    resultSetTableModelBuffer.setDeleted(false);
                    resultSetTableModelBuffer.setNew(false);
                }
            }
            --n2;
        }
        this.fireTableDataChanged();
        this._changed = false;
        return n;
    }

    public boolean isRowDeleted(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getDeleted();
    }

    public boolean isRowChanged(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getChanged();
    }

    public boolean isRowNew(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getNew();
    }

    public boolean isRowError(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getError();
    }

    public String getErrorMessage(int n) {
        Object e;
        if (n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer) {
            ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
            return resultSetTableModelBuffer.getErrorMessage();
        }
        return null;
    }

    public boolean markRowDeleted(int n, boolean bl) {
        if (!this._valid) {
            return false;
        }
        if (this._insertOnly && !this.isRowNew(n)) {
            return false;
        }
        if (n < this._rows.size()) {
            Object e = this._rows.get(n);
            if (e != null) {
                if (e instanceof ResultSetTableModelBuffer) {
                    ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
                    resultSetTableModelBuffer.setDeleted(bl);
                    resultSetTableModelBuffer.setError(false);
                } else {
                    ResultSetTableModelBuffer resultSetTableModelBuffer = new ResultSetTableModelBuffer((ArrayList)e);
                    resultSetTableModelBuffer.setDeleted(bl);
                    this._rows.set(n, resultSetTableModelBuffer);
                }
            }
            this.fireTableDataChanged();
        }
        this._changed = true;
        return true;
    }

    public boolean addRow(int n) {
        if (!this._valid) {
            return false;
        }
        ArrayList<String> arrayList = null;
        ResultSetTableModelBuffer resultSetTableModelBuffer = null;
        arrayList = new ArrayList<String>();
        int n2 = 1;
        while (n2 < this.getColumnCount()) {
            arrayList.add("");
            ++n2;
        }
        resultSetTableModelBuffer = new ResultSetTableModelBuffer();
        resultSetTableModelBuffer.setChangedRow(arrayList);
        resultSetTableModelBuffer.setNew(true);
        resultSetTableModelBuffer.setChanged(false);
        this._rows.add(n, resultSetTableModelBuffer);
        this.fireTableDataChanged();
        return true;
    }

    public boolean isValid() {
        return this._valid;
    }

    public String getTableName() {
        return this._tablename;
    }

    public ArrayList getLog() {
        return this._log;
    }

    public void setInsertOnly() {
        this._insertOnly = true;
    }

    public boolean getChanged() {
        return this._changed;
    }

    public void setChanged(boolean bl) {
        this._changed = bl;
    }

    private boolean insertRow(ResultSetTableModelBuffer resultSetTableModelBuffer) {
        block29: {
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append(this._tablename + " (");
            boolean bl = true;
            int n = 1;
            while (n < this.getColumnCount()) {
                if (!bl) {
                    stringBuffer.append(", ");
                } else {
                    bl = false;
                }
                stringBuffer.append(this.getColumnName(n));
                ++n;
            }
            stringBuffer.append(") VALUES (");
            ArrayList arrayList = resultSetTableModelBuffer.getChangedRow();
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            bl = true;
            n = 0;
            while (n < arrayList.size()) {
                Object e = arrayList.get(n);
                if (!bl) {
                    stringBuffer.append(", ");
                    stringBuffer2.append(", ");
                } else {
                    bl = false;
                }
                if (e != null) {
                    String string = "unknown";
                    try {
                        string = this._rsmd.getColumnTypeName(n + 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this._db.getDatabaseType() == "Oracle Database" && (string.equals("DATE") || string.equals("TIMESTAMP"))) {
                        stringBuffer.append("TO_DATE(?, 'YYYY-MM-DD HH24:MI:SS')");
                        try {
                            stringBuffer2.append("TO_DATE(" + this._db.quoteIdentifier(e.toString().substring(0, Math.min(19, e.toString().length())), true) + ", 'YYYY-MM-DD HH24:MI:SS')");
                        }
                        catch (DBException dBException) {}
                    } else {
                        stringBuffer.append("?");
                        stringBuffer2.append(this.formatValue(e));
                    }
                } else {
                    stringBuffer.append("NULL");
                    stringBuffer2.append("NULL");
                }
                ++n;
            }
            stringBuffer.append(")");
            stringBuffer2.append(")");
            this._log.add(stringBuffer2.toString());
            try {
                int n2 = 0;
                PreparedStatement preparedStatement = this._conn.prepareStatement(stringBuffer.toString());
                int n3 = 1;
                n = 0;
                while (n < arrayList.size()) {
                    Object e = arrayList.get(n);
                    if (e != null) {
                        String string = "unknown";
                        try {
                            string = this._rsmd.getColumnTypeName(n + 1);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (string.equals("DATE") || string.equals("TIMESTAMP")) {
                            if (this._db.getDatabaseType() == "Oracle Database") {
                                preparedStatement.setString(n3, e.toString().substring(0, Math.min(19, e.toString().length())));
                            } else {
                                Date date = Date.valueOf(e.toString().substring(0, Math.min(10, e.toString().length())));
                                preparedStatement.setDate(n3, date);
                            }
                        } else {
                            preparedStatement.setString(n3, e.toString());
                        }
                        ++n3;
                    }
                    ++n;
                }
                n2 = preparedStatement.executeUpdate();
                if (n2 == 1) {
                    resultSetTableModelBuffer.setCommitted();
                    break block29;
                }
                if (n2 == 0) {
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl3 = true;
                return bl3;
            }
            catch (NumberFormatException numberFormatException) {
                resultSetTableModelBuffer.setError(MessageFormat.format(ConnectionArb.getString(667), this.getColumnName(n + 1)));
                boolean bl4 = false;
                return bl4;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                resultSetTableModelBuffer.setError(MessageFormat.format(ConnectionArb.getString(667), this.getColumnName(n + 1)));
                boolean bl5 = false;
                return bl5;
            }
            catch (SQLException sQLException) {
                resultSetTableModelBuffer.setError(sQLException.getLocalizedMessage());
                boolean bl6 = false;
                return bl6;
            }
            catch (Exception exception) {
                boolean bl7 = false;
                return bl7;
            }
        }
        return true;
    }

    private boolean updateRow(ResultSetTableModelBuffer resultSetTableModelBuffer) {
        block44: {
            StringBuffer stringBuffer = new StringBuffer("UPDATE ");
            ArrayList arrayList = resultSetTableModelBuffer.getChangedRow();
            stringBuffer.append(this._tablename + " SET ");
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            boolean bl = true;
            int n = 0;
            while (n < arrayList.size()) {
                Object e = arrayList.get(n);
                if (e != null) {
                    if (!bl) {
                        stringBuffer.append(", ");
                        stringBuffer2.append(", ");
                    } else {
                        bl = false;
                    }
                    String string = "unknown";
                    try {
                        string = this._rsmd.getColumnTypeName(n + 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this._db.getDatabaseType() == "Oracle Database" && (string.equals("DATE") || string.equals("TIMESTAMP"))) {
                        stringBuffer.append(this.getColumnName(n + 1) + " = TO_DATE(?, 'YYYY-MM-DD HH24:MI:SS')");
                        try {
                            stringBuffer2.append(this.getColumnName(n + 1) + " = TO_DATE(" + this._db.quoteIdentifier(e.toString().substring(0, Math.min(19, e.toString().length())), true) + ", 'YYYY-MM-DD HH24:MI:SS')");
                        }
                        catch (DBException dBException) {}
                    } else {
                        stringBuffer.append(this.getColumnName(n + 1) + " = ?");
                        stringBuffer2.append(this.getColumnName(n + 1) + " = " + this.formatValue(e));
                    }
                }
                ++n;
            }
            stringBuffer.append(" WHERE ");
            stringBuffer2.append(" WHERE ");
            ArrayList arrayList2 = resultSetTableModelBuffer.getOriginalRow();
            bl = true;
            n = 0;
            while (n < arrayList2.size()) {
                if (!bl) {
                    stringBuffer.append(" AND ");
                    stringBuffer2.append(" AND ");
                } else {
                    bl = false;
                }
                Object e = arrayList2.get(n);
                if (e != null && e.toString().length() > 0) {
                    String string = null;
                    try {
                        string = this._rsmd.getColumnTypeName(n + 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this._db.getDatabaseType() == "Oracle Database" && (string.equals("DATE") || string.equals("TIMESTAMP"))) {
                        stringBuffer.append(this.getColumnName(n + 1) + " = TO_DATE(?, 'YYYY-MM-DD HH24:MI:SS')");
                        try {
                            stringBuffer2.append(this.getColumnName(n + 1) + " = TO_DATE(" + this._db.quoteIdentifier(e.toString().substring(0, Math.min(19, e.toString().length())), true) + ", 'YYYY-MM-DD HH24:MI:SS')");
                        }
                        catch (DBException dBException) {}
                    } else {
                        stringBuffer.append(this.getColumnName(n + 1) + " = ?");
                        stringBuffer2.append(this.getColumnName(n + 1) + " = " + this.formatValue(e));
                    }
                } else {
                    stringBuffer.append(this.getColumnName(n + 1) + " IS NULL ");
                    stringBuffer2.append(this.getColumnName(n + 1) + " IS NULL ");
                }
                ++n;
            }
            this._log.add(stringBuffer2.toString());
            try {
                PreparedStatement preparedStatement = this._conn.prepareStatement(stringBuffer.toString());
                int n2 = 1;
                n = 0;
                while (n < arrayList.size()) {
                    Object e = arrayList.get(n);
                    if (e != null) {
                        String string = "unknown";
                        try {
                            string = this._rsmd.getColumnTypeName(n + 1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (string.equals("DATE") || string.equals("TIMESTAMP")) {
                            if (this._db.getDatabaseType() == "Oracle Database") {
                                preparedStatement.setString(n2, e.toString().substring(0, Math.min(19, e.toString().length())));
                            } else {
                                preparedStatement.setString(n2, e.toString());
                            }
                        } else {
                            preparedStatement.setString(n2, e.toString());
                        }
                        ++n2;
                    }
                    ++n;
                }
                n = 0;
                while (n < arrayList2.size()) {
                    Object e = arrayList2.get(n);
                    if (e != null && e.toString().length() > 0) {
                        String string = null;
                        try {
                            string = this._rsmd.getColumnTypeName(n + 1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (string.equals("DATE") || string.equals("TIMESTAMP")) {
                            if (this._db.getDatabaseType() == "Oracle Database") {
                                preparedStatement.setString(n2, e.toString().substring(0, Math.min(19, e.toString().length())));
                            } else {
                                preparedStatement.setString(n2, e.toString());
                            }
                        } else {
                            preparedStatement.setString(n2, e.toString());
                        }
                        ++n2;
                    }
                    ++n;
                }
                int n3 = preparedStatement.executeUpdate();
                if (n3 == 1) {
                    resultSetTableModelBuffer.setCommitted();
                    break block44;
                }
                if (n3 == 0) {
                    resultSetTableModelBuffer.setError(ConnectionArb.getString(665) + System.getProperty("line.separator"));
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl3 = true;
                return bl3;
            }
            catch (NumberFormatException numberFormatException) {
                resultSetTableModelBuffer.setError(MessageFormat.format(ConnectionArb.getString(667), this.getColumnName(n + 1)));
                boolean bl4 = false;
                return bl4;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                resultSetTableModelBuffer.setError(MessageFormat.format(ConnectionArb.getString(667), this.getColumnName(n + 1)));
                boolean bl5 = false;
                return bl5;
            }
            catch (SQLException sQLException) {
                resultSetTableModelBuffer.setError(sQLException.getLocalizedMessage());
                boolean bl6 = false;
                return bl6;
            }
            catch (Exception exception) {
                boolean bl7 = false;
                return bl7;
            }
        }
        return true;
    }

    private boolean deleteRow(ResultSetTableModelBuffer resultSetTableModelBuffer) {
        block23: {
            StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
            stringBuffer.append(this._tablename + " WHERE ");
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            ArrayList arrayList = resultSetTableModelBuffer.getOriginalRow();
            boolean bl = true;
            int n = 0;
            while (n < arrayList.size()) {
                if (!bl) {
                    stringBuffer.append(" AND ");
                    stringBuffer2.append(" AND ");
                } else {
                    bl = false;
                }
                Object e = arrayList.get(n);
                if (e != null && e.toString().length() > 0) {
                    String string = null;
                    try {
                        string = this._rsmd.getColumnTypeName(n + 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this._db.getDatabaseType() == "Oracle Database" && (string.equals("DATE") || string.equals("TIMESTAMP"))) {
                        stringBuffer.append(this.getColumnName(n + 1) + " = TO_DATE(?, 'YYYY-MM-DD HH24:MI:SS')");
                        try {
                            stringBuffer2.append(this.getColumnName(n + 1) + " = TO_DATE(" + this._db.quoteIdentifier(e.toString().substring(0, Math.min(19, e.toString().length())), true) + ", 'YYYY-MM-DD HH24:MI:SS')");
                        }
                        catch (DBException dBException) {}
                    } else {
                        stringBuffer.append(this.getColumnName(n + 1) + " = ?");
                        stringBuffer2.append(this.getColumnName(n + 1) + " = " + this.formatValue(e));
                    }
                } else {
                    stringBuffer.append(this.getColumnName(n + 1) + " IS NULL ");
                    stringBuffer2.append(this.getColumnName(n + 1) + " IS NULL ");
                }
                ++n;
            }
            this._log.add(stringBuffer2.toString());
            try {
                PreparedStatement preparedStatement = this._conn.prepareStatement(stringBuffer.toString());
                int n2 = 1;
                n = 0;
                while (n < arrayList.size()) {
                    Object e = arrayList.get(n);
                    if (e != null && e.toString().length() > 0) {
                        String string = null;
                        try {
                            string = this._rsmd.getColumnTypeName(n + 1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (string.equals("DATE") || string.equals("TIMESTAMP")) {
                            if (this._db.getDatabaseType() == "Oracle Database") {
                                preparedStatement.setString(n2, e.toString().substring(0, Math.min(19, e.toString().length())));
                            } else {
                                Date date = Date.valueOf(e.toString().substring(0, Math.min(10, e.toString().length())));
                                preparedStatement.setDate(n2, date);
                            }
                        } else {
                            preparedStatement.setString(n2, e.toString());
                        }
                        ++n2;
                    }
                    ++n;
                }
                int n3 = preparedStatement.executeUpdate();
                if (n3 == 1) {
                    resultSetTableModelBuffer.setCommitted();
                    break block23;
                }
                if (n3 == 0) {
                    resultSetTableModelBuffer.setError(ConnectionArb.getString(666) + System.getProperty("line.separator"));
                    boolean bl2 = false;
                    return bl2;
                }
                boolean bl3 = true;
                return bl3;
            }
            catch (Exception exception) {
                resultSetTableModelBuffer.setError(exception.getLocalizedMessage());
                boolean bl4 = false;
                return bl4;
            }
        }
        return true;
    }

    public void clearChanges() {
        int n = this._rows.size() - 1;
        while (n >= 0) {
            Object e = this._rows.get(n);
            if (e != null && e instanceof ResultSetTableModelBuffer) {
                ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
                if (resultSetTableModelBuffer.getDeleted() && (resultSetTableModelBuffer.getCommitted() || resultSetTableModelBuffer.getNew()) || resultSetTableModelBuffer.getNew() && !resultSetTableModelBuffer.getChanged()) {
                    this._rows.remove(n);
                } else if (resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getNew()) {
                    resultSetTableModelBuffer.clearChanges();
                }
            }
            --n;
        }
    }

    private String formatValue(Object object) {
        try {
            String string = this._db.quoteIdentifier(object.toString(), true);
            return string;
        }
        catch (Exception exception) {
            return this.quote(object.toString());
        }
    }

    private String quote(String string) {
        String string2 = string.replaceAll("'", "''");
        return "'" + string2 + "'";
    }
}

