/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.controls;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.util.SwingWorker;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;

class ResultSetTableModel
extends AbstractTableModel {
    protected Object LOCK;
    protected volatile SwingWorker _worker;
    protected Connection _conn;
    private String _sql;
    protected ResultSet _rs;
    private Statement _stmt;
    private List _colNames;
    protected List _rows;
    private boolean _allFetched;
    private static final int MAX_RS_FETCHSIZE = 1000;

    void $init$() {
        this.LOCK = new Object();
    }

    public ResultSetTableModel(Connection connection, ResultSet resultSet, String string) {
        this.$init$();
        this._conn = connection;
        this._sql = string;
        if (resultSet != null) {
            this._rs = resultSet;
            try {
                this._stmt = resultSet.getStatement();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        Connection connection = this._conn;
        synchronized (connection) {
            try {
                if (this._stmt == null) {
                    this._stmt = this._conn.createStatement();
                }
                if (this._rs == null) {
                    try {
                        this._stmt.setMaxRows(0);
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        // empty catch block
                    }
                    this._rs = this._stmt.executeQuery(ResultSetTableModel._sanitizeOracleSQL(this._sql));
                }
                this._createColumnNamesList();
                this._fetchNext(0);
                this.fireTableStructureChanged();
            }
            catch (SQLException sQLException) {
                SQLErrorDialog.showErrorDialog(null, ConnectionArb.getString(201), sQLException);
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private void _cleanup() {
        this._rows = null;
        this._allFetched = false;
        try {
            if (this._rs != null) {
                this._rs.close();
            }
            this._rs = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean close() {
        this._cleanup();
        try {
            if (this._stmt != null) {
                this._stmt.close();
            }
            this._stmt = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchAll() {
        if (this._allFetched) {
            return;
        }
        int n = this._getFetchSize();
        int n2 = this._colNames.size();
        ResultSet resultSet = this._rs;
        Object object = this.LOCK;
        synchronized (object) {
            if (this._rows == null) {
                this._rows = new ArrayList();
            }
            List list = this._rows;
            ArrayList arrayList = new ArrayList(n);
            try {
                try {
                    while (resultSet.next()) {
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        int n3 = 1;
                        while (n3 <= n2) {
                            arrayList2.add(resultSet.getString(n3));
                            ++n3;
                        }
                        arrayList.add(arrayList2);
                    }
                    this._allFetched = true;
                }
                catch (SQLException sQLException) {
                }
                catch (Exception exception) {}
            }
            finally {
                list.addAll(arrayList);
                this.fireTableDataChanged();
            }
        }
    }

    public int getRowCount() {
        int n = 0;
        if (this._rows != null) {
            n = this._rows.size();
            if (!this._allFetched) {
                n += 5;
            }
        }
        return n;
    }

    public int getColumnCount() {
        int n = this._colNames != null ? this._colNames.size() : 0;
        return n + 1;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return ConnectionArb.getString(185);
        }
        return this._colNames != null ? (String)this._colNames.get(n - 1) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        if (this._rows != null) {
            if (n >= this._rows.size()) {
                Object object = this.LOCK;
                synchronized (object) {
                    if (this._worker == null) {
                        this._fetchNext(n - this._rows.size());
                    }
                }
            }
            if (n < this._rows.size()) {
                if (n2 == 0) {
                    return new Integer(n + 1);
                }
                ArrayList arrayList = (ArrayList)this._rows.get(n);
                if (arrayList != null) {
                    return arrayList.get(n2 - 1);
                }
            }
        }
        return null;
    }

    private static String _sanitizeOracleSQL(String string) {
        String string2 = string.trim();
        String string3 = string2.toUpperCase();
        if (string2.endsWith(";") && !string3.endsWith("END;")) {
            string2 = string2.substring(0, string2.lastIndexOf(";"));
        }
        return string2;
    }

    private void _createColumnNamesList() throws SQLException {
        ResultSetMetaData resultSetMetaData = this._rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this._colNames = new ArrayList(n);
        int n2 = 1;
        while (n2 <= n) {
            this._colNames.add(resultSetMetaData.getColumnLabel(n2));
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _fetchNext(int n) {
        int n2 = this._getFetchSize();
        int n3 = this._colNames.size();
        ResultSet resultSet = this._rs;
        WaitCursor waitCursor = Ide.getWaitCursor();
        waitCursor.show(500L);
        Object object = this.LOCK;
        synchronized (object) {
            if (this._rows == null) {
                this._rows = new ArrayList();
            }
            List list = this._rows;
            this._worker = new 1(this, n2, n, resultSet, n3, list, waitCursor);
            this._worker.start();
        }
    }

    public void refresh() {
        this._cleanup();
        this.open();
    }

    private int _getFetchSize() {
        return 25;
    }

    private String _getDataAsTabDelimitedText() {
        StringBuffer stringBuffer = new StringBuffer(this.getRowCount() * this.getColumnCount() * 20);
        try {
            Iterator iterator = this._colNames.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (!bl) {
                    stringBuffer.append("\t");
                } else {
                    bl = false;
                }
                Object e = iterator.next();
                stringBuffer.append(e != null ? e.toString() : "");
            }
            stringBuffer.append("\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            for (ArrayList arrayList : this._rows) {
                Iterator iterator = arrayList.iterator();
                boolean bl = true;
                while (iterator.hasNext()) {
                    if (!bl) {
                        stringBuffer.append("\t");
                    } else {
                        bl = false;
                    }
                    Object e = iterator.next();
                    stringBuffer.append(e != null ? e.toString() : "");
                }
                stringBuffer.append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private static int getRSFetchSize(int n) {
        return Math.max(Math.min(n, 1000), 1);
    }

    static void wa$_allFetched(ResultSetTableModel resultSetTableModel, boolean bl) {
        resultSetTableModel._allFetched = bl;
    }

    final class 1
    extends SwingWorker {
        private final /* synthetic */ int v$fetchSize;
        private final /* synthetic */ int v$fetchAtLeast;
        private final /* synthetic */ ResultSet v$rs;
        private final /* synthetic */ int v$numCols;
        private final /* synthetic */ List v$rows;
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ ResultSetTableModel this$0;

        public Object construct() {
            int n = Math.max(this.v$fetchSize, this.v$fetchAtLeast);
            ArrayList arrayList = new ArrayList(this.v$fetchSize);
            try {
                while (n > 0) {
                    if (this.v$rs.next()) {
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        int n2 = 1;
                        while (n2 <= this.v$numCols) {
                            arrayList2.add(this.v$rs.getString(n2));
                            ++n2;
                        }
                        arrayList.add(arrayList2);
                        --n;
                        continue;
                    }
                    break;
                }
            }
            catch (SQLException sQLException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            try {
                Object object = this.get();
                if (object instanceof List) {
                    List list = (List)object;
                    int n = list.size();
                    if (n > 0) {
                        this.v$rows.addAll(list);
                    }
                    if (n < this.v$fetchSize) {
                        ResultSetTableModel.wa$_allFetched(this.this$0, true);
                    }
                    this.this$0.fireTableDataChanged();
                }
            }
            catch (Throwable throwable) {
                this.v$wc.hide();
                Object object = this.this$0.LOCK;
                synchronized (object) {
                    this.this$0._worker = null;
                }
                throw throwable;
            }
            this.v$wc.hide();
            Object object = this.this$0.LOCK;
            synchronized (object) {
                this.this$0._worker = null;
            }
        }

        public 1(ResultSetTableModel resultSetTableModel, int n, int n2, ResultSet resultSet, int n3, List list, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.v$rows = list;
            this.v$numCols = n3;
            this.v$rs = resultSet;
            this.v$fetchAtLeast = n2;
            this.v$fetchSize = n;
            this.this$0 = resultSetTableModel;
        }
    }
}

