/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.NavigationPointEvent;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;

public class DBNavigationPoint
extends DefaultNavigationPoint {
    private Node _node;
    private static Map CONNECTIONS = new HashMap();

    public final void setContext(Context context) {
        Node node = this.getRelevantNode(context);
        if (ModelUtil.areDifferent((Object)node, (Object)this._node)) {
            if (this._node != null) {
                this.unhookConnection(this._node);
            }
            if (node != null) {
                this.hookConnection(node);
            }
            this._node = node;
        }
        super.setContext(context);
    }

    protected Node getRelevantNode(Context context) {
        Node node = context != null ? context.getNode() : null;
        return node != null ? CmUtil.getConnectionNode(node.getURL()) : null;
    }

    public Object copyTo(Object object) {
        DBNavigationPoint dBNavigationPoint = object != null ? (DBNavigationPoint)((Object)object) : new DBNavigationPoint();
        this.copyToImpl(dBNavigationPoint);
        return dBNavigationPoint;
    }

    protected void copyToImpl(DBNavigationPoint dBNavigationPoint) {
        Node node = dBNavigationPoint._node;
        super.copyToImpl((DefaultNavigationPoint)dBNavigationPoint);
        dBNavigationPoint._node = this._node;
        if (ModelUtil.areDifferent((Object)node, (Object)dBNavigationPoint._node)) {
            if (node != null) {
                dBNavigationPoint.unhookConnection(node);
            }
            if (dBNavigationPoint._node != null) {
                dBNavigationPoint.hookConnection(dBNavigationPoint._node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hookConnection(Node node) {
        Map map = CONNECTIONS;
        synchronized (map) {
            ArrayList<DBNavigationPoint> arrayList = (ArrayList<DBNavigationPoint>)CONNECTIONS.get(node);
            if (arrayList == null) {
                node.attach((Observer)NodeObserver.ra$INSTANCE());
                arrayList = new ArrayList<DBNavigationPoint>();
                CONNECTIONS.put(node, arrayList);
            }
            arrayList.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unhookConnection(Node node) {
        Map map = CONNECTIONS;
        synchronized (map) {
            List list = (List)CONNECTIONS.get(node);
            if (list != null) {
                list.remove((Object)this);
                if (list.size() == 0) {
                    node.detach((Observer)NodeObserver.ra$INSTANCE());
                    CONNECTIONS.remove(node);
                }
            }
        }
    }

    private void expire() {
        this.fireExpired(new NavigationPointEvent((Object)this));
    }

    private static void closeNode(Node node) {
        List list = (List)CONNECTIONS.get(node);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((DBNavigationPoint)((Object)iterator.next())).expire();
            }
            list.clear();
            node.detach((Observer)NodeObserver.ra$INSTANCE());
            CONNECTIONS.remove(node);
        }
    }

    static void maS$closeNode(Node node) {
        DBNavigationPoint.closeNode(node);
    }

    private static class NodeObserver
    implements Observer {
        private static final NodeObserver INSTANCE = new NodeObserver();

        private NodeObserver() {
        }

        public synchronized void update(Object object, UpdateMessage updateMessage) {
            if (updateMessage.getMessageID() == UpdateMessage.OBJECT_CLOSED) {
                DBNavigationPoint.maS$closeNode((Node)object);
            }
        }

        private static ConnectionNode getNode(String string) {
            ConnectionsProvider connectionsProvider = ConnectionsProvider.getInstance();
            return connectionsProvider.getConnectionNode(string);
        }

        static NodeObserver ra$INSTANCE() {
            return INSTANCE;
        }
    }
}

