/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.ConnectionsProvider;
import oracle.jdeveloper.cm.dt.DatabaseEditorNode;
import oracle.jdeveloper.cm.dt.browser.ConnectionBrowser;
import oracle.jdeveloper.cm.dt.browser.DatabaseBrowser;
import oracle.jdeveloper.cm.dt.net.CmURLConnection;

public class JDevCmURLFileSystemHelper
extends URLFileSystemHelper {
    private static JDevCmURLFileSystemHelper _instance;

    public static JDevCmURLFileSystemHelper getInstance() {
        if (_instance == null) {
            _instance = new JDevCmURLFileSystemHelper();
        }
        return _instance;
    }

    protected JDevCmURLFileSystemHelper() {
    }

    public boolean canRead(URL uRL) {
        return true;
    }

    public boolean canWrite(URL uRL) {
        boolean bl;
        if (DatabaseEditorNode.isDatabaseEditorNodeURL(uRL)) {
            return false;
        }
        String string = CmUtil.getDbObjectType(uRL);
        if ("JAVA CLASS".equals(string) || "JAVA RESOURCE".equals(string) || "JAVA SOURCE".equals(string)) {
            bl = false;
        } else if ("PACKAGE".equals(string) || "TYPE".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string)) {
            bl = false;
            Database database = JDevCmURLFileSystemHelper._getDatabase(uRL);
            try {
                String string2 = CmUtil.getSchema(uRL);
                Schema schema = database.getSchema(string2);
                bl = database.hasPriviledge(string, schema, "MODIFY");
            }
            catch (DBException dBException) {}
        } else {
            bl = true;
        }
        return bl;
    }

    public void delete(URL uRL) throws IOException {
    }

    public boolean exists(URL uRL) {
        if (DatabaseEditorNode.isDatabaseEditorNodeURL(uRL)) {
            return false;
        }
        String string = CmUtil.getDbObjectType(uRL);
        if ("PACKAGE".equals(string) || "TYPE".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string) || "TRIGGER".equals(string)) {
            String string2 = CmUtil.getSchema(uRL);
            String string3 = CmUtil.getName(uRL);
            Database database = JDevCmURLFileSystemHelper._getDatabase(uRL);
            if (database != null) {
                return database.exists(string, string2, string3);
            }
        }
        return false;
    }

    public long getLength(URL uRL) {
        return -1;
    }

    public URL getParent(URL uRL) {
        return null;
    }

    public boolean isDirectory(URL uRL) {
        return false;
    }

    public boolean isHidden(URL uRL) {
        return false;
    }

    public boolean isRegularFile(URL uRL) {
        return false;
    }

    public long lastModified(URL uRL) {
        String string;
        Long l = null;
        if (!DatabaseEditorNode.isDatabaseEditorNodeURL(uRL) && (string = CmUtil.getDbObjectType(uRL)) != null) {
            String string2 = CmUtil.getSchema(uRL);
            String string3 = CmUtil.getName(uRL);
            Database database = JDevCmURLFileSystemHelper._getDatabase(uRL);
            if (database != null) {
                try {
                    l = database.getTimestamp(string, database.getSchema(string2), string3);
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        return l != null ? l : (long)-1;
    }

    public boolean isReadOnly(URL uRL) {
        return this.canWrite(uRL) ^ true;
    }

    public URL[] list(URL uRL) {
        return null;
    }

    public boolean mkdirs(URL uRL) {
        return false;
    }

    public OutputStream openOutputStream(URL uRL) throws IOException {
        CmURLConnection cmURLConnection = new CmURLConnection(uRL);
        return cmURLConnection.getOutputStream();
    }

    public InputStream openInputStream(URL uRL) throws IOException {
        CmURLConnection cmURLConnection = new CmURLConnection(uRL);
        return cmURLConnection.getInputStream();
    }

    public boolean setLastModified(URL uRL, long l) {
        return false;
    }

    public boolean setReadOnly(URL uRL, boolean bl) {
        return false;
    }

    public String getPlatformPathName(URL uRL) {
        if (!DatabaseEditorNode.isDatabaseEditorNodeURL(uRL) && !CmUtil.isFolder(uRL)) {
            if (JDevCmURLFileSystemHelper.isPlSql(uRL)) {
                return JDevCmURLFileSystemHelper._getPlatformPathNameForPlSql(uRL);
            }
            String string = CmUtil.getConnName(uRL);
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            String string2 = CmUtil.getName(uRL);
            if (ModelUtil.hasLength((String)string2)) {
                String string3 = CmUtil.getCatAndUser(CmUtil.getCatalog(uRL), CmUtil.getSchema(uRL));
                if (ModelUtil.hasLength((String)string3)) {
                    fastStringBuffer.append(string3).append('.');
                }
                fastStringBuffer.append(string2);
                fastStringBuffer.append('@');
            }
            fastStringBuffer.append(string);
            return fastStringBuffer.toString();
        }
        return super.getPlatformPathName(uRL);
    }

    private static boolean isPlSql(URL uRL) {
        String string = CmUtil.getDbObjectType(uRL);
        return "PACKAGE".equals(string) || "TYPE".equals(string) || "FUNCTION".equals(string) || "PROCEDURE".equals(string);
    }

    public String toRelativeSpec(URL uRL, URL uRL2, boolean bl) {
        if (!bl && !this.haveSameProtocol(uRL, uRL2)) {
            return JDevCmURLFileSystemHelper.isPlSql(uRL) ? JDevCmURLFileSystemHelper.getFileNameForPlSql(uRL) : this.getPlatformPathName(uRL);
        }
        return super.toRelativeSpec(uRL, uRL2, bl);
    }

    public Reader createReader(URL uRL, String string) throws IOException {
        Reader reader = null;
        String string2 = CmUtil.getDbObjectType(uRL);
        String string3 = CmUtil.getUserName(uRL);
        String string4 = JDevCmURLFileSystemHelper.getRealName(string2, CmUtil.getName(uRL));
        String string5 = CmUtil.getSubType(uRL);
        Database database = JDevCmURLFileSystemHelper._getDatabase(uRL);
        if (database == null) {
            throw new IOException("Connection to " + CmUtil.getConnName(uRL) + " not open.");
        }
        try {
            String string6 = database.getDatabaseSource(string2, database.getSchema(string3), string4, string5);
            reader = string6 != null ? new StringReader(string6) : super.createReader(uRL, string);
        }
        catch (DBException dBException) {
            throw new IOException(dBException.getLocalizedMessage());
        }
        return reader;
    }

    private static String _getPlatformPathNameForPlSql(URL uRL) {
        String string = CmUtil.getDbObjectType(uRL);
        String string2 = CmUtil.getSchema(uRL);
        if (string2 == null) {
            string2 = "";
        }
        String string3 = JDevCmURLFileSystemHelper.getFileNameForPlSql(uRL);
        return string + "." + string2 + "." + string3;
    }

    private static String getFileNameForPlSql(URL uRL) {
        String string = CmUtil.getName(uRL);
        if (string == null) {
            string = "";
        } else {
            String string2 = ".pls";
            String string3 = CmUtil.getDbObjectType(uRL);
            if ("PACKAGE".equals(string3)) {
                String string4 = CmUtil.getSubType(uRL);
                string2 = string4.equals("Body") ? ".pkb" : ".pks";
            }
            string = string + string2;
        }
        return string;
    }

    private static Database _getDatabase(URL uRL) {
        ConnectionBrowser connectionBrowser = JDevCmURLFileSystemHelper._getBrowser(uRL);
        return connectionBrowser instanceof DatabaseBrowser ? ((DatabaseBrowser)connectionBrowser).getDatabase() : null;
    }

    static ConnectionBrowser _getBrowser(URL uRL) {
        String string;
        ConnectionBrowser connectionBrowser = null;
        if (CmUtil.isCMUrl(uRL) && (string = CmUtil.getConnName(uRL)) != null) {
            ConnectionsProvider connectionsProvider = ConnectionsProvider.getInstance();
            ConnectionNode connectionNode = connectionsProvider.getConnectionNode(string);
            connectionBrowser = connectionNode != null ? connectionNode.getConnectionBrowser() : null;
        }
        return connectionBrowser;
    }

    public static String getRealName(String string, String string2) {
        String string3 = string2;
        if ("JAVA SOURCE".equals(string) || "JAVA CLASS".equals(string)) {
            int n = string2.startsWith("/") ? 1 : 0;
            int n2 = string2.lastIndexOf(46);
            string3 = string2.substring(n, n2 >= 0 ? n2 : string2.length());
        } else if ("JAVA RESOURCE".equals(string) && string2.startsWith("/")) {
            string3 = string2.substring(1);
        }
        return string3;
    }
}

