/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBObject;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.DBObjectTransferable;
import oracle.jdeveloper.cm.dt.ui.SchemaObjectDescriptor;

public class DBObjectListPicker
extends ListPicker {
    private Collection m_acceptTypes;
    private Map m_paths;
    private DefaultListModel m_model;
    private boolean m_removeOnShuttle;

    void $init$() {
        this.m_removeOnShuttle = true;
    }

    public DBObjectListPicker() {
        this(new JList(new DefaultListModel()));
    }

    public DBObjectListPicker(JList jList) {
        super(jList);
        this.$init$();
        this.m_model = (DefaultListModel)jList.getModel();
        jList.setCellRenderer(this.getRenderer());
    }

    public void setRemoveOnShuttle(boolean bl) {
        this.m_removeOnShuttle = bl;
    }

    public void setAcceptTypes(String[] stringArray) {
        this.m_acceptTypes = stringArray == null ? null : Arrays.asList(stringArray);
    }

    public void addDBObject(DBObject dBObject) {
        this.m_model.addElement(dBObject);
    }

    protected ListCellRenderer getRenderer() {
        DBObjectRenderer dBObjectRenderer = new DBObjectRenderer();
        dBObjectRenderer.setIncludeIcon(true);
        return dBObjectRenderer;
    }

    protected Transferable[] filterForAdd(Transferable[] transferableArray) {
        if (this.m_acceptTypes != null) {
            ArrayList<Transferable> arrayList = new ArrayList<Transferable>();
            int n = 0;
            while (n < transferableArray.length) {
                DBObject dBObject;
                if (transferableArray[n] instanceof DBObjectTransferable && this.m_acceptTypes.contains((dBObject = ((DBObjectTransferable)transferableArray[n]).getDBObject()).getType())) {
                    arrayList.add(transferableArray[n]);
                }
                ++n;
            }
            return arrayList.toArray(new Transferable[arrayList.size()]);
        }
        return transferableArray;
    }

    public DefaultListModel getListModel() {
        return this.m_model;
    }

    public boolean canAcceptFlavors(DataFlavor[] dataFlavorArray) {
        if (!this.m_removeOnShuttle) {
            return true;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            Class<?> clazz;
            if (dataFlavorArray[n] != null && ModelUtil.areEqual(clazz = dataFlavorArray[n].getRepresentationClass(), DBObjectTransferable.class)) {
                if (this.m_acceptTypes != null) {
                    String string = dataFlavorArray[n].getHumanPresentableName();
                    if (this.m_acceptTypes.contains(string)) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public DataFlavor[] getSelectionDataFlavors() {
        Object[] objectArray = this.getList().getSelectedValues();
        DataFlavor[] dataFlavorArray = new DataFlavor[objectArray.length];
        int n = 0;
        while (n < dataFlavorArray.length) {
            String string = null;
            if (objectArray[n] instanceof DBObject) {
                string = ((DBObject)objectArray[n]).getType();
            } else if (objectArray[n] instanceof SchemaObjectDescriptor) {
                string = ((SchemaObjectDescriptor)objectArray[n]).getType();
            }
            dataFlavorArray[n] = DBObjectTransferable.getDataFlavor(string);
            ++n;
        }
        return dataFlavorArray;
    }

    protected Transferable createTransferable(Object object) {
        if (object instanceof SchemaObjectDescriptor) {
            object = ((SchemaObjectDescriptor)object).getObject();
        }
        if (this.m_paths == null) {
            return new DBObjectTransferable((DBObject)object);
        }
        return new DBObjectTransferable((DBObject)object, (DBObject[])this.m_paths.get(object));
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        if (!this.m_removeOnShuttle) {
            return true;
        }
        Transferable[] transferableArray2 = this.filterForAdd(transferableArray);
        int n = 0;
        while (n < transferableArray2.length) {
            if (transferableArray[n] instanceof DBObjectTransferable) {
                this.cachePath((DBObjectTransferable)transferableArray[n]);
            }
            ++n;
        }
        return super.addSelectedItems(transferableArray2);
    }

    protected void cachePath(DBObjectTransferable dBObjectTransferable) {
        DBObject dBObject = dBObjectTransferable.getDBObject();
        DBObject[] dBObjectArray = dBObjectTransferable.getPath();
        if (this.m_paths == null) {
            this.m_paths = new HashMap();
        }
        this.m_paths.put(dBObject, dBObjectArray);
    }

    public void removeSelectedItems() {
        if (this.m_removeOnShuttle) {
            Object[] objectArray = this.getList().getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                if (this.m_paths != null) {
                    this.m_paths.remove(objectArray[n]);
                }
                ++n;
            }
            super.removeSelectedItems();
        }
    }

    public void removeAllSelectableItems() {
        if (this.m_removeOnShuttle) {
            if (this.m_paths != null) {
                this.m_paths.clear();
            }
            super.removeAllSelectableItems();
        }
    }
}

