/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;

public class DBObjectTransferable
implements Transferable {
    private DBObject m_obj;
    private DBObject[] m_path;
    private boolean m_incKids;
    private DataFlavor[] m_flavors;
    public static final DataFlavor TABLE = new DataFlavor(DBObjectTransferable.class, "TABLE");
    public static final DataFlavor CONSTRAINT = new DataFlavor(DBObjectTransferable.class, "CONSTRAINT");
    public static final DataFlavor INDEX = new DataFlavor(DBObjectTransferable.class, "INDEX");
    public static final DataFlavor COLUMN = new DataFlavor(DBObjectTransferable.class, "COLUMN");
    public static final DataFlavor VIEW = new DataFlavor(DBObjectTransferable.class, "VIEW");
    public static final DataFlavor TYPE = new DataFlavor(DBObjectTransferable.class, "TYPE");
    public static final DataFlavor PACKAGE = new DataFlavor(DBObjectTransferable.class, "PACKAGE");
    public static final DataFlavor PROCEDURE = new DataFlavor(DBObjectTransferable.class, "PROCEDURE");
    public static final DataFlavor FUNCTION = new DataFlavor(DBObjectTransferable.class, "FUNCTION");
    public static final DataFlavor SEQUENCE = new DataFlavor(DBObjectTransferable.class, "SEQUENCE");
    public static final DataFlavor SYNONYM = new DataFlavor(DBObjectTransferable.class, "SYNONYM");
    public static final DataFlavor[] FLAVORS = new DataFlavor[]{TABLE, CONSTRAINT, COLUMN, INDEX, VIEW, TYPE, PACKAGE, PROCEDURE, FUNCTION, SEQUENCE, SYNONYM};
    private static Map s_flavors = new HashMap();

    public DBObjectTransferable(DBObject dBObject) {
        this(dBObject, null, false);
    }

    public DBObjectTransferable(DBObject dBObject, boolean bl) {
        this(dBObject, null, bl);
    }

    public DBObjectTransferable(DBObject dBObject, DBObject[] dBObjectArray) {
        this(dBObject, dBObjectArray, false);
    }

    public DBObjectTransferable(DBObject dBObject, DBObject[] dBObjectArray, boolean bl) {
        this.m_obj = dBObject;
        this.m_path = dBObjectArray;
        this.m_incKids = bl;
    }

    public DBObject getDBObject() {
        return this.m_obj;
    }

    public DBObject[] getPath() {
        if (this.m_path == null) {
            this.m_path = new DBObject[]{this.m_obj};
        }
        return this.m_path;
    }

    public DataFlavor getPrimaryFlavor() {
        return DBObjectTransferable.getDataFlavor(this.m_obj.getType());
    }

    public DataFlavor[] getTransferDataFlavors() {
        if (this.m_flavors == null) {
            if (this.m_incKids && this.m_obj instanceof Relation) {
                if (this.m_obj instanceof Table) {
                    this.m_flavors = new DataFlavor[]{TABLE, COLUMN, CONSTRAINT, INDEX};
                } else if (this.m_obj instanceof View) {
                    this.m_flavors = new DataFlavor[]{VIEW, COLUMN, CONSTRAINT};
                }
            } else {
                this.m_flavors = new DataFlavor[]{DBObjectTransferable.getDataFlavor(this.m_obj.getType())};
            }
        }
        return this.m_flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return Arrays.asList(FLAVORS).contains(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        String string;
        if (!s_flavors.containsValue(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        String string2 = dataFlavor.getHumanPresentableName();
        if (ModelUtil.areEqual((Object)string2, (Object)(string = this.m_obj.getType()))) {
            return this.m_obj;
        }
        if (this.m_obj instanceof Relation && this.m_incKids) {
            if ("COLUMN".equals(string2)) {
                return ((Relation)this.m_obj).getColumns();
            }
            if ("CONSTRAINT".equals(string2)) {
                return ((Relation)this.m_obj).getConstraints();
            }
            if (this.m_obj instanceof Table && "INDEX".equals(string2)) {
                return ((Table)this.m_obj).getIndexes();
            }
        }
        return null;
    }

    static {
        s_flavors.put("TABLE", TABLE);
        s_flavors.put("COLUMN", COLUMN);
        s_flavors.put("INDEX", INDEX);
        s_flavors.put("CONSTRAINT", CONSTRAINT);
        s_flavors.put("VIEW", VIEW);
        s_flavors.put("TYPE", TYPE);
        s_flavors.put("PACKAGE", PACKAGE);
        s_flavors.put("PROCEDURE", PROCEDURE);
        s_flavors.put("FUNCTION", FUNCTION);
        s_flavors.put("SEQUENCE", SEQUENCE);
        s_flavors.put("SYNONYM", SYNONYM);
    }

    public static DataFlavor getDataFlavor(String string) {
        return (DataFlavor)s_flavors.get(string);
    }
}

