/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.resource.ComponentArb;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class ListButtons
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final int ADD = 0;
    public static final int REMOVE = 1;
    public static final int MOVE_UP = 2;
    public static final int MOVE_DOWN = 3;
    private DefaultListModel m_listModel;
    private JList m_list;
    private Helper m_helper;
    private ActionListener m_listener;
    private JButton m_addButton;
    private JButton m_removeButton;
    private JButton m_upButton;
    private JButton m_downButton;

    void $init$() {
        this.m_addButton = new JButton();
        this.m_removeButton = new JButton();
        this.m_upButton = new JButton();
        this.m_downButton = new JButton();
    }

    public ListButtons(JList jList) {
        this(jList, null);
    }

    public ListButtons(JList jList, Helper helper) {
        this.$init$();
        this.m_helper = helper;
        this.m_list = jList;
        jList.addListSelectionListener(this);
        this.m_listModel = (DefaultListModel)jList.getModel();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.m_listener = AWTEventMulticaster.add(this.m_listener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.m_listener = AWTEventMulticaster.remove(this.m_listener, actionListener);
    }

    private void layoutComponents() {
        Dimension dimension = new Dimension(28, 25);
        this.m_upButton.setPreferredSize(dimension);
        this.m_upButton.setIcon(ComponentArb.getIcon((int)0));
        this.m_upButton.setDisabledIcon(ComponentArb.getIcon((int)2));
        String string = this.m_helper == null ? CmWizardsArb.getString(542) : this.m_helper.getUpTooltipText();
        DBObjectRenderer.setToolTipText(this.m_upButton, string);
        this.m_upButton.addActionListener(this);
        this.m_downButton.setPreferredSize(dimension);
        this.m_downButton.setIcon(ComponentArb.getIcon((int)1));
        this.m_downButton.setDisabledIcon(ComponentArb.getIcon((int)3));
        String string2 = this.m_helper == null ? CmWizardsArb.getString(543) : this.m_helper.getDownTooltipText();
        DBObjectRenderer.setToolTipText(this.m_downButton, string2);
        this.m_downButton.addActionListener(this);
        this.m_addButton.setPreferredSize(dimension);
        this.m_addButton.setIcon(ConnectionArb.getIcon(493));
        String string3 = this.m_helper == null ? CmWizardsArb.getString(540) : this.m_helper.getAddTooltipText();
        DBObjectRenderer.setToolTipText(this.m_addButton, string3);
        this.m_addButton.addActionListener(this);
        this.m_removeButton.setPreferredSize(dimension);
        this.m_removeButton.setIcon(ConnectionArb.getIcon(494));
        String string4 = this.m_helper == null ? CmWizardsArb.getString(541) : this.m_helper.getRemoveTooltipText();
        DBObjectRenderer.setToolTipText(this.m_removeButton, string4);
        this.m_removeButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)this.m_addButton, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_removeButton, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_upButton, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.m_downButton, new GridBagConstraints(0, ++n, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    public void enableButtons() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this.m_list.getSelectedIndex();
        Object var5_5 = n != -1 ? this.m_listModel.get(n) : null;
        int[] nArray = this.m_list.getSelectedIndices();
        if (nArray.length == 1) {
            if (var5_5 != null) {
                bl = this.m_helper == null || this.m_helper.canRemove() && this.m_helper.canRemove(var5_5);
                Object var7_7 = n > 0 ? this.m_listModel.get(n - 1) : null;
                Object var8_8 = n < this.m_listModel.getSize() - 1 ? this.m_listModel.get(n + 1) : null;
                bl2 = var7_7 != null && (this.m_helper == null || this.m_helper.canReorder() && this.m_helper.canMoveUp(var5_5) && this.m_helper.canMoveDown(var7_7));
                bl3 = var8_8 != null && (this.m_helper == null || this.m_helper.canReorder() && this.m_helper.canMoveDown(var5_5) && this.m_helper.canMoveUp(var8_8));
            }
        } else if (nArray.length > 1) {
            bl = true;
            if (this.m_helper != null) {
                int n2 = 0;
                while (bl && n2 < nArray.length) {
                    Object e = this.m_listModel.get(nArray[n2]);
                    bl = this.m_helper.canRemove() && this.m_helper.canRemove(e);
                    ++n2;
                }
            }
        }
        this.m_removeButton.setEnabled(bl);
        this.m_upButton.setEnabled(bl2);
        this.m_downButton.setEnabled(bl3);
        this.m_addButton.setEnabled(this.m_helper == null || this.m_helper.canAdd() && this.m_helper.canAdd(var5_5));
    }

    private void swap(int n, int n2) {
        Object e = this.m_listModel.getElementAt(n);
        Object e2 = this.m_listModel.getElementAt(n2);
        this.m_listModel.setElementAt(e, n2);
        this.m_listModel.setElementAt(e2, n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.m_listener != null) {
            if (object == this.m_addButton) {
                this.m_listener.actionPerformed(new ActionEvent(this, 0, "ADD"));
            } else if (object == this.m_removeButton) {
                this.m_listener.actionPerformed(new ActionEvent(this, 1, "REMOVE"));
            } else if (object == this.m_upButton) {
                this.m_listener.actionPerformed(new ActionEvent(this, 2, "MOVE_UP"));
                int n = this.m_list.getSelectedIndex();
                if (n > 0) {
                    this.swap(n--, n);
                    this.m_list.setSelectedIndex(n);
                }
            } else if (object == this.m_downButton) {
                this.m_listener.actionPerformed(new ActionEvent(this, 3, "MOVE_DOWN"));
                int n = this.m_list.getSelectedIndex();
                if (n < this.m_listModel.getSize() - 1) {
                    this.swap(n++, n);
                    this.m_list.setSelectedIndex(n);
                }
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.enableButtons();
        } else {
            this.m_addButton.setEnabled(bl);
            this.m_removeButton.setEnabled(bl);
            this.m_upButton.setEnabled(bl);
            this.m_downButton.setEnabled(bl);
        }
    }

    public static interface Helper {
        public boolean canRemove();

        public boolean canRemove(Object var1);

        public boolean canAdd();

        public boolean canAdd(Object var1);

        public boolean canReorder();

        public boolean canMoveUp(Object var1);

        public boolean canMoveDown(Object var1);

        public String getUpTooltipText();

        public String getDownTooltipText();

        public String getAddTooltipText();

        public String getRemoveTooltipText();
    }
}

