/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.Component;
import java.sql.SQLException;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactory;
import oracle.jdeveloper.cm.dt.wizard.DBWizardFactoryRegistry;
import oracle.jdeveloper.cm.dt.wizard.DBWizardLauncher;
import oracle.jdevimpl.cm.dt.newobj.plsql.PlSqlWizardHelper;
import oracle.jdevimpl.cm.dt.wizards.OracleDBObjectEditor;
import oracle.jdevimpl.cm.dt.wizards.index.OracleIndexWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.sequence.OracleSequenceWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.synonym.OracleSynonymWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.table.OracleTableWizardLauncher;
import oracle.jdevimpl.cm.dt.wizards.trigger.OracleTriggerLauncher;
import oracle.jdevimpl.cm.dt.wizards.view.OracleViewWizardLauncher;

public class OracleDBWizardFactory
implements DBWizardFactory {
    public boolean isCreateSupported(String string) {
        return "SEQUENCE".equals(string) || "SYNONYM".equals(string) || "INDEX".equals(string) || "TABLE".equals(string) || "VIEW".equals(string) || "TRIGGER".equals(string) || "PROCEDURE".equals(string) || "FUNCTION".equals(string) || "PACKAGE".equals(string);
    }

    public String getCreateLabel(String string) {
        String string2 = null;
        if ("SEQUENCE".equals(string)) {
            string2 = ConnectionArb.getString(497);
        } else if ("SYNONYM".equals(string)) {
            string2 = ConnectionArb.getString(498);
        } else if ("INDEX".equals(string)) {
            string2 = ConnectionArb.getString(499);
        } else if ("TABLE".equals(string)) {
            string2 = ConnectionArb.getString(500);
        } else if ("VIEW".equals(string)) {
            string2 = ConnectionArb.getString(501);
        } else if ("TRIGGER".equals(string)) {
            string2 = ConnectionArb.getString(503);
        } else if ("PROCEDURE".equals(string)) {
            string2 = ConnectionArb.getString(15);
        } else if ("FUNCTION".equals(string)) {
            string2 = ConnectionArb.getString(17);
        } else if ("PACKAGE".equals(string)) {
            string2 = ConnectionArb.getString(16);
        }
        return string2;
    }

    public boolean canCreateDBObject(Context context, Database database, String string) {
        boolean bl = false;
        if ("SEQUENCE".equals(string) || "SYNONYM".equals(string) || "INDEX".equals(string) || "TABLE".equals(string) || "VIEW".equals(string) || "TRIGGER".equals(string) || "PROCEDURE".equals(string) || "FUNCTION".equals(string) || "PACKAGE".equals(string) || this.isCreateSupported(string)) {
            try {
                Schema schema = DBWizardLauncher.determineSchema(context, database);
                bl = this.isSupportedDB(database) && database.hasPriviledge(string, schema, "CREATE");
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return bl;
    }

    public boolean createDBObject(Context context, Database database, String string) {
        boolean bl = false;
        if (this.isSupportedDB(database)) {
            OracleDatabase oracleDatabase = (OracleDatabase)database;
            if ("SEQUENCE".equals(string)) {
                bl = this.createSequence(context, oracleDatabase);
            } else if ("SYNONYM".equals(string)) {
                bl = this.createSynonym(context, oracleDatabase);
            } else if ("DATABASE LINK".equals(string)) {
                bl = this.createDblink(context, oracleDatabase);
            } else if ("INDEX".equals(string)) {
                bl = this.createIndex(context, oracleDatabase);
            } else if ("TABLE".equals(string)) {
                bl = this.createTable(context, oracleDatabase);
            } else if ("VIEW".equals(string)) {
                bl = this.createView(context, oracleDatabase);
            } else if ("TRIGGER".equals(string)) {
                bl = this.createTrigger(context, oracleDatabase);
            } else if ("PROCEDURE".equals(string) || "FUNCTION".equals(string) || "PACKAGE".equals(string)) {
                bl = this.createPlSql(context, oracleDatabase);
            } else if ("MATERIALIZED VIEW".equals(string)) {
                bl = this.createMView(context, oracleDatabase);
            }
        } else {
            ConnectionNode connectionNode = CmUtil.getConnectionNode(context);
            DBWizardFactoryRegistry.showUnsupportedDBError(DBUtil.getDisplayName(string), connectionNode.getShortLabel());
        }
        return bl;
    }

    protected boolean createPlSql(Context context, OracleDatabase oracleDatabase) {
        return PlSqlWizardHelper.createPlSql(context, (Database)oracleDatabase);
    }

    protected boolean createTrigger(Context context, OracleDatabase oracleDatabase) {
        return OracleTriggerLauncher.createTrigger(context, oracleDatabase);
    }

    protected boolean createView(Context context, OracleDatabase oracleDatabase) {
        OracleViewWizardLauncher oracleViewWizardLauncher = new OracleViewWizardLauncher(context, (Database)oracleDatabase);
        return oracleViewWizardLauncher.runWizard();
    }

    protected boolean createMView(Context context, OracleDatabase oracleDatabase) {
        return false;
    }

    protected boolean createTable(Context context, OracleDatabase oracleDatabase) {
        OracleTableWizardLauncher oracleTableWizardLauncher = new OracleTableWizardLauncher(context, oracleDatabase);
        return oracleTableWizardLauncher.runWizard();
    }

    protected boolean createIndex(Context context, OracleDatabase oracleDatabase) {
        OracleIndexWizardLauncher oracleIndexWizardLauncher = new OracleIndexWizardLauncher(context, (Database)oracleDatabase);
        return oracleIndexWizardLauncher.runWizard();
    }

    protected boolean createSynonym(Context context, OracleDatabase oracleDatabase) {
        OracleSynonymWizardLauncher oracleSynonymWizardLauncher = new OracleSynonymWizardLauncher(context, (Database)oracleDatabase);
        return oracleSynonymWizardLauncher.runWizard();
    }

    protected boolean createDblink(Context context, OracleDatabase oracleDatabase) {
        return false;
    }

    protected boolean createSequence(Context context, OracleDatabase oracleDatabase) {
        OracleSequenceWizardLauncher oracleSequenceWizardLauncher = new OracleSequenceWizardLauncher(context, (Database)oracleDatabase);
        return oracleSequenceWizardLauncher.runWizard();
    }

    protected boolean isSupportedDB(Database database) {
        return "Oracle Database".equals(database.getDatabaseType());
    }

    public boolean canEditDBObject(Context context, Database database, DBObject dBObject) {
        String string;
        boolean bl = false;
        if (this.isSupportedDB(database) && ("SEQUENCE".equals(string = dBObject.getType()) || "INDEX".equals(string) || "TABLE".equals(string) || "VIEW".equals(string))) {
            bl = true;
        }
        return bl;
    }

    public boolean editDBObject(Context context, Database database, DBObject dBObject) {
        boolean bl = false;
        if (this.isSupportedDB(database)) {
            String string = dBObject.getType();
            if ("SEQUENCE".equals(string)) {
                bl = this.editSequence(database, dBObject);
            } else if ("SYNONYM".equals(string)) {
                bl = this.editSynonym(database, dBObject);
            } else if ("INDEX".equals(string)) {
                bl = this.editIndex(database, dBObject);
            } else if ("TABLE".equals(string)) {
                bl = this.editTable(database, dBObject);
            } else if ("VIEW".equals(string)) {
                bl = this.editView(database, dBObject);
            } else if ("DATABASE LINK".equals(string)) {
                bl = this.editDblink(database, dBObject);
            } else if ("MATERIALIZED VIEW".equals(string)) {
                bl = this.editMView(database, dBObject);
            }
        }
        return bl;
    }

    protected boolean editView(Database database, DBObject dBObject) {
        return OracleDBObjectEditor.editView((OracleDatabase)database, (View)dBObject);
    }

    protected boolean editTable(Database database, DBObject dBObject) {
        return OracleDBObjectEditor.editTable((OracleDatabase)database, (Table)dBObject);
    }

    protected boolean editIndex(Database database, DBObject dBObject) {
        return OracleDBObjectEditor.editIndex((OracleDatabase)database, (Index)dBObject);
    }

    protected boolean editSynonym(Database database, DBObject dBObject) {
        return OracleDBObjectEditor.editSynonym((OracleDatabase)database, (Synonym)dBObject);
    }

    protected boolean editSequence(Database database, DBObject dBObject) {
        return OracleDBObjectEditor.editSequence((OracleDatabase)database, (Sequence)dBObject);
    }

    protected boolean editDblink(Database database, DBObject dBObject) {
        return false;
    }

    protected boolean editMView(Database database, DBObject dBObject) {
        return false;
    }

    public static void createOracleObject(TraversableContext traversableContext, String string, String string2, String string3) throws TraversalException {
        SchemaObject schemaObject = (SchemaObject)traversableContext.find(string);
        OracleDatabase oracleDatabase = (OracleDatabase)traversableContext.find("DBObjectProvider");
        try {
            oracleDatabase.createObject(schemaObject, false);
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            if (throwable instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, string2, (SQLException)throwable);
                switch (((SQLException)throwable).getErrorCode()) {
                    case 955: 
                    case 4095: 
                    case 12000: 
                    case 12006: {
                        break;
                    }
                    default: {
                        try {
                            oracleDatabase.deleteObject(schemaObject, true);
                        }
                        catch (DBException dBException2) {}
                        break;
                    }
                }
            } else {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(throwable != null ? throwable : dBException), (String)string2, (String)string3, null);
            }
            throw new TraversalException(null);
        }
    }
}

