/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Sequence;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.DBObjectOnePagePanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.SchemaPicker;
import oracle.jdeveloper.cm.dt.verifier.SequenceInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class SequencePanel
extends DBObjectOnePagePanel
implements ItemListener {
    public static final String TABLESPACES_KEY = "Tablespaces";
    private GridBagLayout m_layCenter;
    private JLabel m_lblSchemaName;
    private JLabel m_lblSequenceName;
    private JLabel m_lblStartWith;
    private JLabel m_lblIncrement;
    private JLabel m_lblMinValue;
    private JLabel m_lblMaxValue;
    private JLabel m_lblCacheSize;
    private JLabel m_lblCache;
    private SchemaPicker m_cmbSchema;
    private JTextField m_txtSequenceName;
    private SequenceNumberField m_fldStartWith;
    private SequenceNumberField m_fldIncrement;
    private SequenceNumberField m_fldMinValue;
    private SequenceNumberField m_fldMaxValue;
    private SequenceNumberField m_fldCacheSize;
    private static String CACHE = "CACHE";
    private static String NOCACHE = "NOCACHE";
    private static String[] cacheValues = new String[]{null, CACHE, NOCACHE};
    private JComboBox m_fldCache;
    private DefaultComboBoxModel m_cacheModel;
    private JCheckBox m_cbxCycle;
    private JCheckBox m_cbxOrder;
    private static final String[] EXTENTS_SIZES = new String[]{"", "K", "M"};
    private static final int K = 1024;
    private static final int M = 0x100000;
    private DBObjectRenderer m_renderer;
    private DefaultComboBoxModel m_mdlSchema;
    private Map m_schemaMap;

    void $init$() {
        this.m_layCenter = new GridBagLayout();
        this.m_lblSchemaName = new JLabel();
        this.m_lblSequenceName = new JLabel();
        this.m_lblStartWith = new JLabel();
        this.m_lblIncrement = new JLabel();
        this.m_lblMinValue = new JLabel();
        this.m_lblMaxValue = new JLabel();
        this.m_lblCacheSize = new JLabel();
        this.m_lblCache = new JLabel();
        this.m_cmbSchema = new SchemaPicker();
        this.m_txtSequenceName = new JTextField();
        this.m_fldStartWith = new SequenceNumberField();
        this.m_fldIncrement = new SequenceNumberField();
        this.m_fldMinValue = new SequenceNumberField();
        this.m_fldMaxValue = new SequenceNumberField();
        this.m_fldCacheSize = new SequenceNumberField();
        this.m_fldCache = new JComboBox();
        this.m_cacheModel = new DefaultComboBoxModel<String>(cacheValues);
        this.m_cbxCycle = new JCheckBox();
        this.m_cbxOrder = new JCheckBox();
        this.m_renderer = new DBObjectRenderer();
        this.m_mdlSchema = new NonNullableComboBoxModel();
        this.m_schemaMap = new HashMap();
    }

    public SequencePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layCenter);
        this.m_cmbSchema.setModel(this.m_mdlSchema);
        this.m_cmbSchema.setRenderer(this.m_renderer);
        ResourceUtils.resLabel((JLabel)this.m_lblSchemaName, (Component)((Object)this.m_cmbSchema), (String)CmWizardsArb.getString(17));
        ResourceUtils.resLabel((JLabel)this.m_lblSequenceName, (Component)this.m_txtSequenceName, (String)CmWizardsArb.getString(18));
        ResourceUtils.resLabel((JLabel)this.m_lblStartWith, (Component)((Object)this.m_fldStartWith), (String)CmWizardsArb.getString(364));
        ResourceUtils.resLabel((JLabel)this.m_lblIncrement, (Component)((Object)this.m_fldIncrement), (String)CmWizardsArb.getString(365));
        ResourceUtils.resLabel((JLabel)this.m_lblMinValue, (Component)((Object)this.m_fldMinValue), (String)CmWizardsArb.getString(366));
        ResourceUtils.resLabel((JLabel)this.m_lblMaxValue, (Component)((Object)this.m_fldMaxValue), (String)CmWizardsArb.getString(367));
        ResourceUtils.resButton((AbstractButton)this.m_cbxCycle, (String)CmWizardsArb.getString(368));
        this.m_cbxCycle.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_cbxOrder, (String)CmWizardsArb.getString(370));
        this.m_cbxOrder.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblCache, (Component)this.m_fldCache, (String)(CmWizardsArb.getString(369) + ":"));
        this.m_fldCache.setModel(this.m_cacheModel);
        this.m_fldCache.addItemListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblCacheSize, (Component)((Object)this.m_fldCacheSize), (String)CmWizardsArb.getString(371));
        this.add(this.m_lblSchemaName, new GridBagConstraints(10, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_cmbSchema), new GridBagConstraints(20, 10, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblSequenceName, new GridBagConstraints(10, 20, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_txtSequenceName, new GridBagConstraints(20, 20, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblIncrement, new GridBagConstraints(10, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldIncrement), new GridBagConstraints(20, 30, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 12, 0, 0), 0, 0));
        this.add(this.m_lblMinValue, new GridBagConstraints(30, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 24, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldMinValue), new GridBagConstraints(40, 30, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 12, 0, 0), 0, 0));
        this.add(this.m_lblStartWith, new GridBagConstraints(10, 40, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldStartWith), new GridBagConstraints(20, 40, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblMaxValue, new GridBagConstraints(30, 40, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldMaxValue), new GridBagConstraints(40, 40, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblCache, new GridBagConstraints(10, 50, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_fldCache, new GridBagConstraints(20, 50, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_lblCacheSize, new GridBagConstraints(30, 50, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 24, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_fldCacheSize), new GridBagConstraints(40, 50, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(this.m_cbxCycle, new GridBagConstraints(20, 60, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 12, 0, 0), 0, 0));
        this.add(this.m_cbxOrder, new GridBagConstraints(20, 70, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return CmWizardsArb.getString(362);
    }

    public Image getHeaderImage() {
        return ConnectionArb.getImage(448);
    }

    public String getHeaderDescription() {
        return CmWizardsArb.getString(363);
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        Sequence sequence = (Sequence)traversableContext.find("NewObject");
        SequenceInfoVerifier sequenceInfoVerifier = (SequenceInfoVerifier)traversableContext.find(SequenceInfoVerifier.KEY);
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        this.init(dBObjectProvider, sequence, sequenceInfoVerifier, schemaArray);
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            wizardCallbacks.wizardSetInitialFocus((Component)this.m_txtSequenceName);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Sequence sequence = (Sequence)traversableContext.find("NewObject");
        if (sequence == null) {
            sequence = new Sequence();
        }
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        this.commit(sequence, schemaArray, traversableContext.getDirection() != 2);
    }

    private void init(DBObjectProvider dBObjectProvider, Sequence sequence, SequenceInfoVerifier sequenceInfoVerifier, Schema[] schemaArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        super.init(dBObjectProvider, sequenceInfoVerifier);
        this.m_cmbSchema.setProvider(dBObjectProvider);
        this.m_renderer.setProvider(dBObjectProvider);
        this.m_mdlSchema.removeAllElements();
        int n = 0;
        while (n < schemaArray.length) {
            this.m_mdlSchema.addElement(schemaArray[n]);
            ++n;
        }
        Schema schema = sequence.getSchema();
        if (schema != null) {
            if (this.m_mdlSchema.getIndexOf(schema) < 0) {
                this.m_mdlSchema.addElement(schema);
            }
            this.m_mdlSchema.setSelectedItem(schema);
        }
        this.m_cmbSchema.setEnabled(sequenceInfoVerifier == null || sequenceInfoVerifier.canChangeSchema());
        this.m_cmbSchema.setEditable(sequenceInfoVerifier == null || sequenceInfoVerifier.canCreateSchema());
        this.m_txtSequenceName.setText(this.getExternalName(sequence.getName()));
        this.m_txtSequenceName.setEnabled(sequenceInfoVerifier == null || sequenceInfoVerifier.canChangeName());
        BigInteger bigInteger4 = sequence.getStartWith();
        if (bigInteger4 != null) {
            this.m_fldStartWith.setNumber(bigInteger4);
        }
        if ((bigInteger3 = sequence.getIncrementBy()) != null) {
            this.m_fldIncrement.setNumber(bigInteger3);
        }
        if ((bigInteger2 = sequence.getMinValue()) != null) {
            this.m_fldMinValue.setNumber(bigInteger2);
        }
        if ((bigInteger = sequence.getMaxValue()) != null) {
            this.m_fldMaxValue.setNumber(bigInteger);
        }
        this.m_cbxCycle.setSelected(sequence.getCycleFlag() == Boolean.TRUE);
        Boolean bl = sequence.getCacheFlag();
        if (bl != null) {
            this.m_cacheModel.setSelectedItem(bl != false ? CACHE : NOCACHE);
            this.m_cacheModel.removeElement(null);
            this.m_fldCacheSize.setEditable(bl);
            this.m_fldCacheSize.setEnabled(bl);
            if (bl.booleanValue()) {
                BigInteger bigInteger5 = sequence.getCacheSize();
                if (bigInteger5 != null && bigInteger5.intValue() > 1) {
                    this.m_fldCacheSize.setNumber(bigInteger5);
                } else {
                    this.m_fldCacheSize.setNumber(this.getCacheSizeDefault());
                }
            }
        } else {
            this.m_cacheModel.setSelectedItem(null);
            this.m_fldCacheSize.setEditable(false);
            this.m_fldCacheSize.setEnabled(false);
        }
        this.m_fldCacheSize.setSigned(false);
        this.m_cbxOrder.setSelected(sequence.getOrderFlag() == Boolean.TRUE);
        if (sequenceInfoVerifier != null) {
            this.m_lblSchemaName.setEnabled(sequenceInfoVerifier.canChangeSchema());
            this.m_lblSequenceName.setEnabled(sequenceInfoVerifier.canChangeName());
            this.m_txtSequenceName.setEditable(sequenceInfoVerifier.canChangeName());
            this.m_txtSequenceName.setEnabled(sequenceInfoVerifier.canChangeName());
            this.m_lblStartWith.setEnabled(sequenceInfoVerifier.canEditStartWith());
            this.m_fldStartWith.setEditable(sequenceInfoVerifier.canEditStartWith());
            this.m_fldStartWith.setEnabled(sequenceInfoVerifier.canEditStartWith());
            this.m_lblIncrement.setEnabled(sequenceInfoVerifier.canChangeIncrement());
            this.m_fldIncrement.setEditable(sequenceInfoVerifier.canChangeIncrement());
            this.m_fldIncrement.setEnabled(sequenceInfoVerifier.canChangeIncrement());
            this.m_lblMaxValue.setEnabled(sequenceInfoVerifier.canChangeMaxValue());
            this.m_fldMaxValue.setEditable(sequenceInfoVerifier.canChangeMaxValue());
            this.m_fldMaxValue.setEnabled(sequenceInfoVerifier.canChangeMaxValue());
            this.m_lblMinValue.setEnabled(sequenceInfoVerifier.canChangeMinValue());
            this.m_fldMinValue.setEditable(sequenceInfoVerifier.canChangeMinValue());
            this.m_fldMinValue.setEnabled(sequenceInfoVerifier.canChangeMinValue());
            this.m_cbxCycle.setEnabled(sequenceInfoVerifier.canChangeCycle());
            this.m_cbxOrder.setEnabled(sequenceInfoVerifier.canChangeOrder());
            this.m_lblCache.setEnabled(sequenceInfoVerifier.canChangeCache());
            this.m_fldCache.setEnabled(sequenceInfoVerifier.canChangeCache());
            this.m_lblCacheSize.setEnabled(sequenceInfoVerifier.canChangeCacheSize() && this.m_fldCacheSize.isEnabled());
            this.m_fldCacheSize.setEditable(sequenceInfoVerifier.canChangeCacheSize() && this.m_fldCacheSize.isEditable());
            this.m_fldCacheSize.setEnabled(sequenceInfoVerifier.canChangeCacheSize() && this.m_fldCacheSize.isEnabled());
        }
    }

    private void commit(Sequence sequence, Schema[] schemaArray, boolean bl) throws TraversalException {
        SequenceInfoVerifier sequenceInfoVerifier = (SequenceInfoVerifier)this.getVerifier();
        DBObjectProvider dBObjectProvider = this.getProvider();
        Schema schema = this.m_cmbSchema.getSchema(schemaArray);
        BigInteger bigInteger = (BigInteger)this.m_fldStartWith.getNumber();
        BigInteger bigInteger2 = (BigInteger)this.m_fldIncrement.getNumber();
        BigInteger bigInteger3 = (BigInteger)this.m_fldMinValue.getNumber();
        BigInteger bigInteger4 = (BigInteger)this.m_fldMaxValue.getNumber();
        Boolean bl2 = this.m_cbxCycle.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = this.m_cbxOrder.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        BigInteger bigInteger5 = null;
        Boolean bl4 = null;
        String string = (String)this.m_fldCache.getSelectedItem();
        if (string != null && (bl4 = Boolean.valueOf(string == CACHE)).booleanValue()) {
            bigInteger5 = (BigInteger)this.m_fldCacheSize.getNumber();
        }
        sequence.setStartWith(bigInteger);
        sequence.setIncrementBy(bigInteger2);
        sequence.setMinValue(bigInteger3);
        sequence.setMaxValue(bigInteger4);
        sequence.setCycleFlag(bl2);
        sequence.setCacheFlag(bl4);
        sequence.setCacheSize(bigInteger5);
        sequence.setOrderFlag(bl3);
        sequence.setSchema(schema);
        sequence.setName(this.getInternalName(this.m_txtSequenceName.getText()));
        if (sequenceInfoVerifier != null) {
            sequenceInfoVerifier.verifyMinValue();
            sequenceInfoVerifier.verifyMaxValue();
            if (bl) {
                sequenceInfoVerifier.verifySequence();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.m_fldCache) {
            String string = (String)this.m_cacheModel.getSelectedItem();
            boolean bl = (string == null || string == NOCACHE) ^ true;
            this.m_lblCacheSize.setEnabled(bl);
            this.m_fldCacheSize.setEditable(bl);
            this.m_fldCacheSize.setEnabled(bl);
            this.m_fldCacheSize.setNumber(bl ? this.getCacheSizeDefault() : null);
        }
    }

    private BigInteger getCacheSizeDefault() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = (BigInteger)this.m_fldMaxValue.getNumber();
        BigInteger bigInteger3 = (BigInteger)this.m_fldMinValue.getNumber();
        BigInteger bigInteger4 = (BigInteger)this.m_fldIncrement.getNumber();
        if (bigInteger4 == null) {
            bigInteger4 = BigInteger.ONE;
        }
        if (bigInteger2 == null) {
            bigInteger2 = bigInteger4.signum() > 0 ? BigInteger.valueOf(10).pow(27) : BigInteger.ONE.negate();
        }
        if (bigInteger3 == null) {
            bigInteger3 = bigInteger4.signum() > 0 ? BigInteger.ONE : BigInteger.valueOf(10).pow(26).negate();
        }
        BigInteger[] bigIntegerArray = bigInteger2.subtract(bigInteger3).abs().divideAndRemainder(bigInteger4.abs());
        BigInteger bigInteger5 = bigIntegerArray[0];
        if (bigIntegerArray[1].signum() > 0) {
            bigInteger5 = bigInteger5.add(BigInteger.ONE);
        }
        if (bigInteger5.subtract(bigInteger = new BigInteger("20")).signum() > 0) {
            bigInteger5 = bigInteger;
        }
        return bigInteger5;
    }

    private static class SequenceNumberField
    extends NumberTextField {
        private BigInteger m_maxValue;

        void $init$() {
            this.m_maxValue = BigInteger.valueOf(10).pow(28).subtract(BigInteger.ONE);
        }

        public SequenceNumberField() {
            this.$init$();
            this.setDataType(BigInteger.class);
            this.setSigned(true);
        }

        protected String convertNumberToString(Number number) {
            return number.toString();
        }

        protected boolean validateNumber(Number number) {
            return number == null || ((BigInteger)number).abs().compareTo(this.m_maxValue) <= 0;
        }

        public BigInteger getMaximumValue() {
            return this.m_maxValue;
        }

        public void setMaximumValue(BigInteger bigInteger) {
            this.m_maxValue = bigInteger;
        }
    }
}

