/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.Ide;
import oracle.ide.component.NewFilePanel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Database;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;
import oracle.jdeveloper.cm.dt.ui.TabbedDBPanel;
import oracle.jdeveloper.cm.dt.ui.UIConstants;
import oracle.jdeveloper.cm.dt.verifier.Verifier;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public abstract class TabbedDialogLauncher
extends Namespace
implements UIConstants {
    private Map _verifiers;
    protected List _tabs;
    private String _title;
    protected String _topLabel;
    protected String _errTitle;

    void $init$() {
        this._verifiers = new HashMap();
        this._tabs = new ArrayList();
        this._errTitle = null;
    }

    protected TabbedDialogLauncher(Database database, Schema schema) {
        this.$init$();
        this.setProvider((DBObjectProvider)database);
        this.setSchema(schema);
        try {
            Schema[] schemaArray = database.listSchemas();
            this.put("SchemaList", schemaArray);
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause();
            if (throwable instanceof SQLException) {
                SQLErrorDialog.showErrorDialog(null, "Error Getting Schema List", (SQLException)throwable);
            }
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)(throwable != null ? throwable : dBException), (String)"Error Getting Schema List", (String)"An error was encountered trying to get the list of schemas.", null);
        }
    }

    protected void setTitle(String string) {
        this._title = string;
    }

    protected void setProvider(DBObjectProvider dBObjectProvider) {
        this.put("DBObjectProvider", dBObjectProvider);
    }

    protected DBObjectProvider getProvider() {
        return (DBObjectProvider)this.get("DBObjectProvider");
    }

    protected void setSchema(Schema schema) {
        this.put("Schema", schema);
    }

    protected Schema getSchema() {
        return (Schema)this.get("Schema");
    }

    protected void setTopLabel(String string) {
        this._topLabel = string;
    }

    public void addTab(Class clazz, String string, String string2) {
        Navigable navigable = new Navigable(string2, clazz);
        if (ModelUtil.hasLength((String)string)) {
            navigable.setHelpID(string);
        }
        this.addTab(navigable);
    }

    public void addTab(Navigable navigable) {
        this._tabs.add(navigable);
    }

    public void registerVerifier(String string, Class clazz) {
        this._verifiers.put(string, clazz);
    }

    public void unregisterVerifier(String string) {
        this._verifiers.remove(string);
    }

    public abstract boolean createObject();

    public abstract boolean editObject(SchemaObject var1);

    public final boolean createObjectImpl() {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)this.get("DBObjectProvider");
        SchemaObject schemaObject = (SchemaObject)this.get("OriginalObject");
        SchemaObject schemaObject2 = (SchemaObject)this.get("NewObject");
        for (String string : this._verifiers.keySet()) {
            Class clazz = (Class)this._verifiers.get(string);
            try {
                Verifier verifier = (Verifier)clazz.newInstance();
                verifier.initializeVerifier(dBObjectProvider, schemaObject, schemaObject2);
                this.put(string, verifier);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.runDialog(this._title);
    }

    public void setErrorTitle(String string) {
        this._errTitle = string;
    }

    protected boolean runDialog(String string) {
        TabbedDBPanel tabbedDBPanel = new TabbedDBPanel(this._tabs.toArray(new Navigable[this._tabs.size()]));
        if (ModelUtil.hasLength((String)this._topLabel)) {
            tabbedDBPanel.setTopLabel(this._topLabel);
        }
        if (ModelUtil.hasLength((String)this._errTitle)) {
            tabbedDBPanel.setErrorTitle(this._errTitle);
        }
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), string, (Traversable)tabbedDBPanel, (Namespace)this);
        tDialogLauncher.setInitialSize(600, 500);
        return tDialogLauncher.showDialog();
    }

    protected static class CreateSQLTab
    extends SQLTab {
        protected String getSQL(TraversableContext traversableContext) {
            SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
            DDLGenerator dDLGenerator = (DDLGenerator)traversableContext.get("DDlGenerator");
            Ddl ddl = dDLGenerator.getCreateDDL(schemaObject, false, false);
            return ddl.getDdl();
        }

        protected CreateSQLTab() {
        }
    }

    protected static class EditSQLTab
    extends SQLTab {
        protected String getSQL(TraversableContext traversableContext) {
            SchemaObject schemaObject = (SchemaObject)traversableContext.get("NewObject");
            SchemaObject schemaObject2 = (SchemaObject)traversableContext.get("OriginalObject");
            DDLGenerator dDLGenerator = (DDLGenerator)traversableContext.get("DDlGenerator");
            Ddl[] ddlArray = dDLGenerator.getUpdateDDL(schemaObject2, schemaObject);
            String string = "";
            if (ddlArray != null) {
                int n = 0;
                while (n < ddlArray.length) {
                    string = string + ddlArray[n].getDdl();
                    ++n;
                }
            }
            return string;
        }

        protected EditSQLTab() {
        }
    }

    private static abstract class SQLTab
    extends DefaultTraversablePanel {
        private JButton _btnSave;
        private final JTextArea _txtSQL;

        void $init$() {
            this._txtSQL = new JTextArea();
        }

        public SQLTab() {
            this.$init$();
        }

        public void onEntry(TraversableContext traversableContext) {
            String string = this.getSQL(traversableContext);
            this._txtSQL.setText(string);
        }

        protected abstract String getSQL(TraversableContext var1);

        public Component getComponent() {
            if (this.getComponentCount() == 0) {
                this.setLayout(new GridBagLayout());
                JLabel jLabel = new JLabel();
                ResourceUtils.resLabel((JLabel)jLabel, (Component)this._txtSQL, (String)CmWizardsArb.getString(178));
                this._btnSave = new JButton();
                this._btnSave.addActionListener(new 1());
                ResourceUtils.resButton((AbstractButton)this._btnSave, (String)CmWizardsArb.getString(179));
                this._txtSQL.setEditable(false);
                JScrollPane jScrollPane = new JScrollPane(this._txtSQL);
                this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
                this.add(jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
                this.add(this._btnSave, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            }
            return this;
        }

        static JTextArea ra$_txtSQL(SQLTab sQLTab) {
            return sQLTab._txtSQL;
        }

        public final class 1
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                URLChooser uRLChooser = DialogUtil.newURLChooser();
                uRLChooser.clearChooseableURLFilters();
                uRLChooser.setURLFilter(SqlNode.SQL_FILTER);
                URL uRL = null;
                while (uRLChooser.showSaveDialog((Component)((Object)SQLTab.this)) == 0) {
                    uRL = uRLChooser.getSelectedURL();
                    if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)uRL))) {
                        String string = URLFileSystem.getPath((URL)uRL);
                        uRL = URLFactory.replacePathPart((URL)uRL, (String)(string + ".sql"));
                    }
                    try {
                        uRL = NewFilePanel.validateURL((Component)((Object)SQLTab.this), (URL)uRL, (String)ConnectionArb.getString(303), (boolean)true);
                    }
                    catch (TraversalException traversalException) {
                        traversalException.showMessageDialog((Component)((Object)SQLTab.this));
                        break;
                    }
                    if (uRL == null) continue;
                }
                if (uRL != null) {
                    try {
                        OutputStream outputStream = URLFileSystem.openOutputStream((URL)uRL);
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, IdeUtil.getIdeEncoding()));
                        bufferedWriter.write(SQLTab.ra$_txtSQL(SQLTab.this).getText());
                        ((Writer)bufferedWriter).flush();
                        ((Writer)bufferedWriter).close();
                    }
                    catch (IOException iOException) {
                        ExceptionDialog.showExceptionDialog((Component)((Object)SQLTab.this), (Throwable)iOException, (String)CmWizardsArb.getString(180), (String)CmWizardsArb.getString(181), null);
                    }
                }
            }
        }
    }
}

