/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.plsql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.controls.DefaultListComboBoxModel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.DBObjectOnePagePanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.SchemaPicker;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public abstract class NewPlsqlPanel
extends DBObjectOnePagePanel {
    private JLabel lblSchema;
    private JLabel lblName;
    private JLabel lblType;
    private SchemaPicker cmbSchema;
    private JTextField fldName;
    private JComboBox cmbType;
    private GridBagLayout gridBagLayout1;
    private DefaultComboBoxModel mdlSchema;
    private DBObjectRenderer renderer;
    public static final String PLSQL_DEFAULT_NAME = "Plsql Default Name";
    public static final String PLSQL_DEFAULT_TYPE = "Plsql Default Type";
    public static final int RECOMMENDED_PARENT_WIDTH = 350;
    public static final int RECOMMENDED_PARENT_HEIGHT = 245;

    void $init$() {
        this.lblSchema = new JLabel();
        this.lblName = new JLabel();
        this.lblType = new JLabel();
        this.cmbSchema = new SchemaPicker();
        this.fldName = new JTextField();
        this.cmbType = new JComboBox();
        this.gridBagLayout1 = new GridBagLayout();
        this.mdlSchema = new NonNullableComboBoxModel();
        this.renderer = new DBObjectRenderer();
    }

    public NewPlsqlPanel() {
        this.$init$();
        try {
            this.initialize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public abstract String getNameLabel();

    public abstract String getDefaultName(TraversableContext var1);

    public abstract String getTypeLabel();

    public abstract List getTypeList(TraversableContext var1);

    public abstract PlSqlComboItem getDefaultComboItem();

    public Image getHeaderImage() {
        return ConnectionArb.getImage(449);
    }

    protected abstract void performProcess(TraversableContext var1) throws TraversalException;

    protected String getSchemaLabel() {
        return CmWizardsArb.getString(17);
    }

    protected final String getSelectedName() {
        return this.fldName.getText();
    }

    protected final PlSqlComboItem getSelectedType() {
        return (PlSqlComboItem)this.cmbType.getSelectedItem();
    }

    protected final Schema getSelectedSchema(Schema[] schemaArray) {
        try {
            Schema schema = this.cmbSchema.getSchema(schemaArray);
            return schema;
        }
        catch (TraversalException traversalException) {
            return null;
        }
    }

    private void initialize() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.cmbSchema.setModel(this.mdlSchema);
        this.cmbSchema.setRenderer(this.renderer);
        this.cmbSchema.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.lblSchema, (Component)((Object)this.cmbSchema), (String)this.getSchemaLabel());
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)this.getNameLabel());
        ResourceUtils.resLabel((JLabel)this.lblType, (Component)this.cmbType, (String)this.getTypeLabel());
        this.fldName.setText("");
        this.add(this.lblSchema, new GridBagConstraints(10, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)((Object)this.cmbSchema), new GridBagConstraints(20, 10, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.lblName, new GridBagConstraints(10, 20, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.fldName, new GridBagConstraints(20, 20, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.lblType, new GridBagConstraints(10, 30, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.cmbType, new GridBagConstraints(20, 30, 0, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        PlSqlComboItem plSqlComboItem;
        List list;
        super.onEntry(traversableContext);
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        this.renderer.setProvider(dBObjectProvider);
        this.fldName.setText(this.getDefaultName(traversableContext));
        this.cmbSchema.setProvider(dBObjectProvider);
        this.mdlSchema.removeAllElements();
        int n = 0;
        while (n < schemaArray.length) {
            this.mdlSchema.addElement(schemaArray[n]);
            ++n;
        }
        Schema schema = (Schema)traversableContext.find("Schema");
        if (schema != null) {
            if (this.mdlSchema.getIndexOf(schema) < 0) {
                this.mdlSchema.addElement(schema);
            }
            this.mdlSchema.setSelectedItem(schema);
        }
        if ((list = this.getTypeList(traversableContext)) != null && list.size() > 0) {
            this.cmbType.setModel(new DefaultListComboBoxModel(list));
        }
        if ((plSqlComboItem = this.getDefaultComboItem()) != null) {
            this.cmbType.setSelectedItem(plSqlComboItem);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        this.performProcess(traversableContext);
    }

    protected final class PlSqlComboItem {
        private int m_display;
        private int m_plsql;
        private int m_extraPlsql;
        private boolean m_collection;
        private String m_type;

        public PlSqlComboItem(String string, int n, int n2) {
            this(string, n, n2, -1, false);
        }

        public PlSqlComboItem(String string, int n, int n2, boolean bl) {
            this(string, n, n2, -1, bl);
        }

        public PlSqlComboItem(String string, int n, int n2, int n3) {
            this(string, n, n2, n3, false);
        }

        public PlSqlComboItem(String string, int n, int n2, int n3, boolean bl) {
            this.m_type = string;
            this.m_display = n;
            this.m_plsql = n2;
            this.m_extraPlsql = n3;
            this.m_collection = bl;
        }

        public String getType() {
            return this.m_type;
        }

        public int getDisplayString() {
            return this.m_display;
        }

        public int getPlsql() {
            return this.m_plsql;
        }

        public int getExtraPlsql() {
            return this.m_extraPlsql;
        }

        public boolean isCollectionType() {
            return this.m_collection;
        }

        public String toString() {
            return ConnectionArb.getString(this.getDisplayString());
        }
    }
}

