/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.plsql;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Function;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Package;
import oracle.javatools.db.Procedure;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.ValidationException;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.plsql.NewPlsqlPanel;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public final class NewPlsqlSubprogramPanel
extends NewPlsqlPanel {
    NewPlsqlPanel.PlSqlComboItem m_default;

    public NewPlsqlSubprogramPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_sqlplsqlsubprogram_html");
    }

    public String getHeaderTitle() {
        return CmWizardsArb.getString(417);
    }

    public String getHeaderDescription() {
        return CmWizardsArb.getString(418);
    }

    public String getNameLabel() {
        return CmWizardsArb.getString(18);
    }

    public String getTypeLabel() {
        return CmWizardsArb.getString(419);
    }

    public String getDefaultName(TraversableContext traversableContext) {
        return (String)traversableContext.find("Plsql Default Name");
    }

    public List getTypeList(TraversableContext traversableContext) {
        String string = (String)traversableContext.find("Plsql Default Type");
        ArrayList<NewPlsqlPanel.PlSqlComboItem> arrayList = new ArrayList<NewPlsqlPanel.PlSqlComboItem>();
        NewPlsqlPanel.PlSqlComboItem plSqlComboItem = new NewPlsqlPanel.PlSqlComboItem("PACKAGE", 291, 295);
        arrayList.add(plSqlComboItem);
        if (plSqlComboItem.getType().equals(string)) {
            this.m_default = plSqlComboItem;
        }
        plSqlComboItem = (NewPlsqlPanel)this.new NewPlsqlPanel.PlSqlComboItem("PACKAGE", 292, 295, 296);
        arrayList.add(plSqlComboItem);
        plSqlComboItem = new NewPlsqlPanel.PlSqlComboItem("FUNCTION", 294, 298);
        arrayList.add(plSqlComboItem);
        if (plSqlComboItem.getType().equals(string)) {
            this.m_default = plSqlComboItem;
        }
        plSqlComboItem = new NewPlsqlPanel.PlSqlComboItem("PROCEDURE", 293, 297);
        arrayList.add(plSqlComboItem);
        if (plSqlComboItem.getType().equals(string)) {
            this.m_default = plSqlComboItem;
        }
        return arrayList;
    }

    public NewPlsqlPanel.PlSqlComboItem getDefaultComboItem() {
        return this.m_default;
    }

    protected void performProcess(TraversableContext traversableContext) throws TraversalException {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        Schema[] schemaArray = (Schema[])traversableContext.find("SchemaList");
        Schema schema = this.getSelectedSchema(schemaArray);
        String string = this.getSelectedName();
        NewPlsqlPanel.PlSqlComboItem plSqlComboItem = this.getSelectedType();
        String string2 = plSqlComboItem.getType();
        try {
            dBObjectProvider.validateName(string2, string);
        }
        catch (InvalidNameException invalidNameException) {
            throw new TraversalException(invalidNameException.getMessage(), CmWizardsArb.format(246, string));
        }
        Package package_ = null;
        if ("PACKAGE".equals(string2)) {
            package_ = new Package();
        } else if ("PROCEDURE".equals(string2)) {
            package_ = new Procedure();
        } else if ("FUNCTION".equals(string2)) {
            package_ = new Function();
        }
        package_.setName(dBObjectProvider.getInternalName(string));
        package_.setSchema(schema);
        String string3 = dBObjectProvider.getExternalName(package_.getName());
        package_.setSource(ConnectionArb.format(plSqlComboItem.getPlsql(), string3));
        if (package_ instanceof SpecPlSql) {
            SpecPlSql specPlSql = (SpecPlSql)package_;
            specPlSql.setBodySource(plSqlComboItem.getExtraPlsql() > 0 ? ConnectionArb.format(plSqlComboItem.getExtraPlsql(), string3) : null);
        }
        try {
            dBObjectProvider.validateObject((DBObject)package_);
        }
        catch (ValidationException validationException) {
            throw new TraversalException(validationException.getMessage(), CmWizardsArb.format(243, string));
        }
        traversableContext.put("NewObject", (Object)package_);
    }
}

