/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.reconcile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.diff.ResultSet;
import oracle.jdeveloper.cm.dt.ui.reconcile.DependancyManager;
import oracle.jdeveloper.cm.dt.ui.reconcile.ReconcilePicker;
import oracle.jdeveloper.cm.dt.ui.reconcile.ReconcileTreeNode;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class ReconcilePanel
extends DefaultTraversablePanel
implements ShuttleListener,
TreeExpansionListener,
TreeSelectionListener,
ActionListener {
    public static final String HELP_ID = "f1_offdbgeneratereconcile_html";
    private JMultiLineLabel m_lblTop;
    private JLabel m_lblFrom;
    private JLabel m_lblTo;
    private Shuttle m_shuttle;
    private ReconcilePicker m_from;
    private ReconcilePicker m_chosen;
    private WizardCallbacks m_wcallbacks;
    private DialogCallbacks m_dcallbacks;
    private GridBagLayout layCenter;

    void $init$() {
        this.m_lblTop = new JMultiLineLabel();
        this.m_lblFrom = new JLabel();
        this.m_lblTo = new JLabel();
        this.m_shuttle = new Shuttle();
        this.layCenter = new GridBagLayout();
    }

    public ReconcilePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setHelpID(HELP_ID);
        this.m_lblTop.setText(CmWizardsArb.getString(430));
        this.m_lblTop.setPreferredAspectRatio(0.0f);
        this.m_lblTop.setPreferredRows(1);
        this.m_lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add((Component)this.m_lblTop, "North");
        this.setLayout(this.layCenter);
        this.add((Component)this.m_shuttle, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public String getHeaderTitle() {
        return CmWizardsArb.getString(427);
    }

    public String getHeaderDescription() {
        return CmWizardsArb.getString(428);
    }

    protected ReconcilePicker getFromPicker() {
        if (this.m_from == null) {
            this.m_from = new ReconcilePicker();
        }
        return this.m_from;
    }

    protected ReconcilePicker getToPicker() {
        if (this.m_chosen == null) {
            this.m_chosen = new ReconcilePicker();
        }
        return this.m_chosen;
    }

    public void onEntry(TraversableContext traversableContext) {
        DependancyManager dependancyManager = (DependancyManager)traversableContext.find("OriginalObject");
        this.init(dependancyManager);
        this.m_wcallbacks = traversableContext.getWizardCallbacks();
        if (this.m_wcallbacks == null) {
            this.m_dcallbacks = traversableContext.getDialogCallbacks();
            if (this.m_dcallbacks != null) {
                this.m_dcallbacks.enableOKButton(false);
            }
        } else {
            this.m_dcallbacks = null;
            this.m_wcallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DependancyManager dependancyManager = (DependancyManager)traversableContext.find("OriginalObject");
        this.commit(dependancyManager, traversableContext.getDirection() != 2);
    }

    private void init(DependancyManager dependancyManager) {
        this.m_shuttle.setFromPicker((ItemPicker)this.getFromPicker());
        this.m_shuttle.setToPicker((ItemPicker)this.getToPicker());
        this.m_shuttle.setMode(1);
        ResourceUtils.resLabel((JLabel)this.m_lblFrom, (Component)this.getFromPicker().getJTree(), (String)CmWizardsArb.getString(435));
        ResourceUtils.resLabel((JLabel)this.m_lblTo, (Component)this.getToPicker().getJTree(), (String)CmWizardsArb.getString(436));
        this.m_shuttle.add((Component)this.m_lblFrom, (Object)"FromHeader");
        this.m_shuttle.add((Component)this.m_lblTo, (Object)"ToHeader");
        this.m_shuttle.setButtonLabels(new String[]{"", CmWizardsArb.getString(433), "", CmWizardsArb.getString(434), CmWizardsArb.getString(431), CmWizardsArb.getString(432)});
        this.getFromPicker().buildTree(true, dependancyManager);
        this.getToPicker().buildTree(false, dependancyManager);
        this.buildDependancies(this.getFromPicker(), this.getToPicker(), dependancyManager);
        this.m_shuttle.addShuttleListener((ShuttleListener)this);
        this.getFromPicker().addTreeExpansionListener(this);
        this.getFromPicker().addTreeSelectionListener(this);
        this.getToPicker().addTreeExpansionListener(this);
        this.getToPicker().addTreeSelectionListener(this);
    }

    private void buildDependancies(ReconcilePicker reconcilePicker, ReconcilePicker reconcilePicker2, DependancyManager dependancyManager) {
        ResultSet resultSet = dependancyManager.getResultSet();
        this.buildDependancies(reconcilePicker, reconcilePicker2, resultSet);
        for (ResultSet resultSet2 : dependancyManager.getResultSetsWithDependancies()) {
            ReconcileTreeNode reconcileTreeNode = reconcilePicker.getReconcileTreeNode(resultSet2);
            ReconcileTreeNode reconcileTreeNode2 = reconcilePicker2.getReconcileTreeNode(resultSet2);
            Set set = dependancyManager.getRevertDependancies(resultSet2);
            Set set2 = dependancyManager.getAddDependancies(resultSet2);
            for (ResultSet resultSet3 : set2) {
                ReconcileTreeNode reconcileTreeNode3 = reconcilePicker.getReconcileTreeNode(resultSet3);
                reconcileTreeNode.addDependantChange(reconcileTreeNode3);
            }
            for (ResultSet resultSet4 : set) {
                ReconcileTreeNode reconcileTreeNode4 = reconcilePicker2.getReconcileTreeNode(resultSet4);
                reconcileTreeNode2.addDependantChange(reconcileTreeNode4);
            }
        }
    }

    private void buildDependancies(ReconcilePicker reconcilePicker, ReconcilePicker reconcilePicker2, ResultSet resultSet) {
        block4: {
            block3: {
                ReconcileTreeNode reconcileTreeNode = reconcilePicker.getReconcileTreeNode(resultSet);
                ReconcileTreeNode reconcileTreeNode2 = reconcilePicker2.getReconcileTreeNode(resultSet);
                if (reconcileTreeNode != null && reconcileTreeNode2 != null) {
                    reconcileTreeNode.setPartner(reconcileTreeNode2);
                    reconcileTreeNode2.setPartner(reconcileTreeNode);
                }
                if (!"LIST".equals(resultSet.getType())) break block3;
                for (ResultSet resultSet2 : resultSet.getAllObjectsList()) {
                    this.buildDependancies(reconcilePicker, reconcilePicker2, resultSet2);
                }
                break block4;
            }
            if (!"MAP".equals(resultSet.getType())) break block4;
            for (ResultSet resultSet3 : resultSet.getAllObjectsMap().values()) {
                this.buildDependancies(reconcilePicker, reconcilePicker2, resultSet3);
            }
        }
    }

    private void commit(DependancyManager dependancyManager, boolean bl) throws TraversalException {
        this.updateChildren(dependancyManager.getResultSet());
    }

    private boolean updateChildren(ResultSet resultSet) {
        boolean bl = resultSet.isSame();
        if (!bl) {
            ReconcileTreeNode reconcileTreeNode = this.getToPicker().getReconcileTreeNode(resultSet);
            bl = reconcileTreeNode != null ? reconcileTreeNode.isShuttled() ^ true : true;
            if ("LIST".equals(resultSet.getType())) {
                for (ResultSet resultSet2 : resultSet.getNotSameObjectList()) {
                    bl &= this.updateChildren(resultSet2);
                }
            } else if ("MAP".equals(resultSet.getType())) {
                for (ResultSet resultSet3 : resultSet.getNotSameObjectMap().values()) {
                    bl &= this.updateChildren(resultSet3);
                }
            }
            resultSet.setSame(bl);
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        int n = 0;
        while (n < treePathArray.length) {
            ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)treePathArray[n].getLastPathComponent();
            JTree jTree = reconcileTreeNode.isFrom() ? this.getFromPicker().getJTree() : this.getToPicker().getJTree();
            TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
            TreePath[] treePathArray2 = jTree.getSelectionPaths();
            ResultSet resultSet = reconcileTreeNode.getResultSet();
            if (resultSet.getName() != null) {
                boolean bl = treeSelectionEvent.isAddedPath(n);
                boolean bl2 = false;
                if (!bl && treePathArray2 != null) {
                    int n2 = 0;
                    while (n2 < treePathArray2.length) {
                        TreePath treePath = treePathArray2[n2];
                        ReconcileTreeNode reconcileTreeNode2 = (ReconcileTreeNode)treePath.getLastPathComponent();
                        bl2 |= reconcileTreeNode2.getDependantChanges().contains(reconcileTreeNode);
                        ++n2;
                    }
                }
                if (!this.isLeafDependantOnParent(resultSet) && !bl2) {
                    this.setHighLighted(reconcileTreeNode, bl);
                }
            }
            ++n;
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        block0: {
            TreePath treePath = treeExpansionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof ReconcileTreeNode)) break block0;
            ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)defaultMutableTreeNode;
            ReconcileTreeNode reconcileTreeNode2 = reconcileTreeNode.getPartner();
            TreePath treePath2 = new TreePath(reconcileTreeNode2.getPath());
            JTree jTree = reconcileTreeNode2.isFrom() ? this.getFromPicker().getJTree() : this.getToPicker().getJTree();
            jTree.collapsePath(treePath2);
            JTree jTree2 = reconcileTreeNode.isFrom() ? this.getFromPicker().getJTree() : this.getToPicker().getJTree();
            jTree2.getSelectionModel().resetRowSelection();
            jTree.getSelectionModel().resetRowSelection();
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        block1: {
            TreePath treePath = treeExpansionEvent.getPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (!(defaultMutableTreeNode instanceof ReconcileTreeNode)) break block1;
            ReconcileTreeNode reconcileTreeNode = (ReconcileTreeNode)defaultMutableTreeNode;
            ReconcileTreeNode reconcileTreeNode2 = reconcileTreeNode.getPartner();
            if (reconcileTreeNode2 == null) {
                // empty if block
            }
            TreePath treePath2 = new TreePath(reconcileTreeNode2.getPath());
            JTree jTree = reconcileTreeNode2.isFrom() ? this.getFromPicker().getJTree() : this.getToPicker().getJTree();
            jTree.expandPath(treePath2);
            JTree jTree2 = reconcileTreeNode.isFrom() ? this.getFromPicker().getJTree() : this.getToPicker().getJTree();
            jTree2.getSelectionModel().resetRowSelection();
            jTree.getSelectionModel().resetRowSelection();
        }
    }

    public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
    }

    public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
        this.setShuttled(shuttleEvent.getItems(), true);
        this.setOKButton();
    }

    public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
        this.setShuttled(shuttleEvent.getItems(), false);
        this.setOKButton();
    }

    private void setOKButton() {
        ReconcileTreeNode[] reconcileTreeNodeArray = this.getToPicker().getTopTreeNodes();
        boolean bl = false;
        if (reconcileTreeNodeArray != null) {
            int n = 0;
            while (n < reconcileTreeNodeArray.length) {
                bl = reconcileTreeNodeArray[n].isChildShuttled();
                if (bl) break;
                ++n;
            }
        }
        if (this.m_dcallbacks != null) {
            this.m_dcallbacks.enableOKButton(bl);
        }
    }

    private boolean isLeafDependantOnParent(ResultSet resultSet) {
        return "LEAF".equals(resultSet.getType()) && (resultSet.inAbutNotB() || resultSet.inBbutNotA());
    }

    private void setShuttled(Transferable[] transferableArray, boolean bl) {
        try {
            ReconcileTreeNode[] reconcileTreeNodeArray;
            int n = 0;
            while (n < transferableArray.length) {
                Transferable transferable = transferableArray[n];
                ResultSet resultSet = (ResultSet)transferable.getTransferData(ReconcilePicker.TRANSFERABLE_FLAVOR);
                if (!this.isLeafDependantOnParent(resultSet)) {
                    ReconcileTreeNode reconcileTreeNode = this.getToPicker().getReconcileTreeNode(resultSet);
                    this.setShuttled(reconcileTreeNode, bl);
                    this.setHighLighted(reconcileTreeNode, false);
                    this.getToPicker().getJTree().repaint();
                    ReconcileTreeNode reconcileTreeNode2 = this.getFromPicker().getReconcileTreeNode(resultSet);
                    this.setHighLighted(reconcileTreeNode2, false);
                    this.getFromPicker().getJTree().repaint();
                }
                ++n;
            }
            ReconcilePicker reconcilePicker = this.getToPicker();
            if (reconcilePicker != null && (reconcileTreeNodeArray = this.getToPicker().getTopTreeNodes()) != null) {
                int n2 = 0;
                while (n2 < reconcileTreeNodeArray.length) {
                    reconcileTreeNodeArray[n2].updateChildShuttled();
                    ++n2;
                }
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setShuttled(ReconcileTreeNode reconcileTreeNode, boolean bl) {
        reconcileTreeNode.setShuttled(this.getFromPicker().getTreeModel(), this.getToPicker().getTreeModel(), bl);
    }

    private void setHighLighted(ReconcileTreeNode reconcileTreeNode, boolean bl) {
        reconcileTreeNode.setDependantsHighLighted(this.getFromPicker().getTreeModel(), this.getToPicker().getTreeModel(), bl);
    }
}

