/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.reconcile;

import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.util.Namespace;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.DiffEngineCancelledException;
import oracle.javatools.db.diff.ReconcileHelper;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.ds.db.DBUtil;
import oracle.jdeveloper.cm.dt.ui.DBObjectOnePageDialog;
import oracle.jdeveloper.cm.dt.ui.reconcile.ColumnConstraitDependancySeeker;
import oracle.jdeveloper.cm.dt.ui.reconcile.DataTypeAttributeDependancySeeker;
import oracle.jdeveloper.cm.dt.ui.reconcile.DependancyManager;
import oracle.jdeveloper.cm.dt.ui.reconcile.FKConstraintDependancySeeker;
import oracle.jdeveloper.cm.dt.ui.reconcile.IndexDependancySeeker;
import oracle.jdeveloper.cm.dt.ui.reconcile.ReconcilePanel;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class ReconcileUI
implements Runnable {
    private boolean m_diagnosticPrint;
    private List m_aList;
    private List m_bList;
    private DiffContext m_diffContext;
    private DependancyManager m_dependancyManager;
    private String m_title;
    private String m_progressText;
    protected ProgressBar m_progressBar;
    private boolean m_progressBarCompletedOK;
    private boolean m_busyBar;

    void $init$() {
        this.m_diagnosticPrint = false;
        this.m_title = CmWizardsArb.getString(424);
        this.m_progressText = CmWizardsArb.getString(425);
        this.m_busyBar = true;
    }

    public ReconcileUI() {
        this.$init$();
    }

    public ResultSet manualReconcile(SchemaObject[] schemaObjectArray, SchemaObject[] schemaObjectArray2) {
        DiffEngine diffEngine = ReconcileHelper.getDiffEngine();
        DiffContext diffContext = null;
        diffContext = new DiffContext();
        diffContext.setEngine(diffEngine);
        this.m_dependancyManager = new DependancyManager(diffContext);
        this.m_dependancyManager.registerDependancySeeker(ColumnConstraint.class, new ColumnConstraitDependancySeeker());
        this.m_dependancyManager.registerDependancySeeker(FKConstraint.class, new FKConstraintDependancySeeker());
        this.m_dependancyManager.registerDependancySeeker(Index.class, new IndexDependancySeeker());
        this.m_dependancyManager.registerDependancySeeker(DataTypeUsage.class, new DataTypeAttributeDependancySeeker());
        this.runDiffReconcile(schemaObjectArray, schemaObjectArray2, diffContext);
        return diffContext.getResult();
    }

    private boolean runProgressBar() {
        boolean bl = true;
        this.m_progressBarCompletedOK = false;
        this.m_progressBar = new ProgressBar((Component)Ide.getMainWindow(), this.getTitle(), (Runnable)this, this.m_busyBar);
        this.m_progressBar.start(this.getProgressText(), null);
        if (this.m_progressBar.hasUserCancelled()) {
            bl = false;
        } else {
            bl = this.m_progressBarCompletedOK;
            this.m_progressBar = null;
        }
        return bl;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setProgressText(String string) {
        this.m_progressText = string;
    }

    public String getProgressText() {
        return this.m_progressText;
    }

    protected void setUseBusyBar(boolean bl) {
        this.m_busyBar = bl;
    }

    public void checkProgress() {
        if (this.m_progressBar != null && this.m_progressBar.hasUserCancelled()) {
            throw new DiffEngineCancelledException();
        }
    }

    public DiffContext runDiff(Object[] objectArray, Object[] objectArray2) {
        this.m_aList = Arrays.asList(objectArray);
        this.m_bList = Arrays.asList(objectArray2);
        ResultSet resultSet = new ResultSet(null, (Object)objectArray, (Object)objectArray2, null, "LIST");
        this.m_diffContext = new DiffContext(new DiffEngine(), resultSet);
        boolean bl = this.runProgressBar();
        if (!bl) {
            resultSet.setSame(true);
        }
        return this.m_diffContext;
    }

    public DiffContext runDiffReconcile(Object[] objectArray, Object[] objectArray2, DiffContext diffContext) {
        this.m_aList = Arrays.asList(objectArray);
        this.m_bList = Arrays.asList(objectArray2);
        this.m_diffContext = diffContext;
        boolean bl = this.runProgressBar();
        if (bl) {
            DBObjectOnePageDialog dBObjectOnePageDialog = new DBObjectOnePageDialog(700, 500);
            dBObjectOnePageDialog.setOKButtonInit(false);
            dBObjectOnePageDialog.setCancelButtonText(CmWizardsArb.getString(429));
            Namespace namespace = new Namespace();
            namespace.put("OriginalObject", (Object)this.m_dependancyManager);
            ReconcilePanel reconcilePanel = new ReconcilePanel();
            bl = dBObjectOnePageDialog.doOnePageReconcileDialog(CmWizardsArb.getString(426), reconcilePanel, namespace);
        }
        ResultSet resultSet = diffContext.getResult();
        if (!bl) {
            resultSet.setSame(true);
        }
        if (this.m_diagnosticPrint) {
            resultSet.print();
        }
        return diffContext;
    }

    public final void run() {
        try {
            try {
                DBUtil.getLog().trace("Starting " + this.getTitle());
                if (this.m_diffContext.getResult() == null) {
                    this.m_diffContext.setResult(new ResultSet(null, (Object)this.m_aList, (Object)this.m_bList, null, "LIST"));
                }
                ResultSet resultSet = this.m_diffContext.getResult();
                this.m_diffContext.getEngine().diff(this.m_aList, this.m_bList, resultSet, this.m_diffContext);
                if (this.m_diagnosticPrint) {
                    this.m_diffContext.getResult().print();
                }
                if (this.m_dependancyManager != null) {
                    this.m_dependancyManager.setResultSet(resultSet);
                    this.m_dependancyManager.analyseDependencies();
                    if (this.m_diagnosticPrint) {
                        this.m_dependancyManager.print();
                    }
                }
                this.m_progressBarCompletedOK = true;
            }
            catch (DiffEngineCancelledException diffEngineCancelledException) {
                this.m_progressBar = null;
            }
            catch (Exception exception) {
                if (this.m_progressBar != null) {
                    this.m_progressBar.setDoneStatus();
                }
                DBUtil.logStackTrace((Throwable)exception);
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)exception.getMessage());
            }
        }
        finally {
            if (this.m_progressBar != null) {
                if (this.m_progressBar.hasUserCancelled()) {
                    this.m_diffContext.getEngine().cancelDiff();
                    this.m_progressBar = null;
                } else {
                    this.m_progressBar.setDoneStatus();
                }
            }
        }
    }
}

