/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.SchemaPicker;
import oracle.jdeveloper.cm.dt.verifier.relation.RelationInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class RelationInfoPanel
extends BaseInfoPanel {
    private BorderLayout layMain;
    private JMultiLineLabel lblTop;
    private JPanel pnlCenter;
    private GridBagLayout layCenter;
    private JLabel lblOwner;
    private SchemaPicker cmbOwner;
    private JLabel lblName;
    private JTextField fldName;
    private JLabel lblComment;
    private JScrollPane scrComment;
    private JTextArea txtComment;
    private GridBagLayout gridBagLayout1;
    private DBObjectRenderer renderer;
    private DefaultComboBoxModel mdlOwner;
    private Map _schemaMap;

    void $init$() {
        this.layMain = new BorderLayout();
        this.lblTop = new JMultiLineLabel();
        this.pnlCenter = new JPanel();
        this.layCenter = new GridBagLayout();
        this.lblOwner = new JLabel();
        this.cmbOwner = new SchemaPicker();
        this.lblName = new JLabel();
        this.fldName = new JTextField();
        this.lblComment = new JLabel();
        this.scrComment = new JScrollPane();
        this.txtComment = new JTextArea();
        this.gridBagLayout1 = new GridBagLayout();
        this.renderer = new DBObjectRenderer();
        this.mdlOwner = new NonNullableComboBoxModel();
        this._schemaMap = new HashMap();
    }

    public RelationInfoPanel() {
        this(true);
    }

    public RelationInfoPanel(boolean bl) {
        this.$init$();
        try {
            this.jbInit(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit(boolean bl) throws Exception {
        this.setLayout(this.layMain);
        this.setTopLabel(CmWizardsArb.getString(20));
        this.lblTop.setPreferredAspectRatio(0.0f);
        this.lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add((Component)this.lblTop, "North");
        this.pnlCenter.setLayout(this.layCenter);
        this.setOwnerLabel(CmWizardsArb.getString(17));
        this.cmbOwner.setModel(this.mdlOwner);
        this.cmbOwner.setRenderer(this.renderer);
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.fldName, (String)CmWizardsArb.getString(18));
        this.fldName.setColumns(30);
        this.pnlCenter.add((Component)this.lblOwner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        this.pnlCenter.add((Component)((Object)this.cmbOwner), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlCenter.add((Component)this.lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.pnlCenter.add((Component)this.fldName, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        if (bl) {
            ResourceUtils.resLabel((JLabel)this.lblComment, (Component)this.txtComment, (String)CmWizardsArb.getString(21));
            this.scrComment.setVerticalScrollBarPolicy(22);
            this.scrComment.setHorizontalScrollBarPolicy(31);
            this.txtComment.setLineWrap(true);
            this.txtComment.setWrapStyleWord(true);
            this.pnlCenter.add((Component)this.lblComment, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 15), 0, 0));
            this.scrComment.getViewport().add((Component)this.txtComment, null);
            this.pnlCenter.add((Component)this.scrComment, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        }
        this.add(this.pnlCenter, "Center");
    }

    public void init(DBObjectProvider dBObjectProvider, Relation relation, RelationInfoVerifier relationInfoVerifier, Schema[] schemaArray) {
        super.init(dBObjectProvider, relationInfoVerifier);
        this.cmbOwner.setProvider(dBObjectProvider);
        this.renderer.setProvider(dBObjectProvider);
        this.mdlOwner.removeAllElements();
        int n = 0;
        while (n < schemaArray.length) {
            this.mdlOwner.addElement(schemaArray[n]);
            ++n;
        }
        Schema schema = relation.getSchema();
        if (schema != null) {
            if (this.mdlOwner.getIndexOf(schema) < 0) {
                this.mdlOwner.addElement(schema);
            }
            this.mdlOwner.setSelectedItem(schema);
        }
        this.lblOwner.setEnabled(relationInfoVerifier == null || relationInfoVerifier.canChangeSchema());
        this.cmbOwner.setEnabled(relationInfoVerifier == null || relationInfoVerifier.canChangeSchema());
        this.cmbOwner.setEditable(relationInfoVerifier == null || relationInfoVerifier.canCreateSchema());
        String string = this.getExternalName(relation.getName());
        this.fldName.setText(string);
        this.lblName.setEnabled(relationInfoVerifier == null || relationInfoVerifier.canChangeName());
        this.fldName.setEnabled(relationInfoVerifier == null || relationInfoVerifier.canChangeName());
        String string2 = (String)relation.getProperty("Comment");
        if (string2 != null) {
            this.txtComment.setText(string2);
        }
        boolean bl = relationInfoVerifier == null || relationInfoVerifier.canChangeComment();
        this.lblComment.setEnabled(bl);
        this.txtComment.setEnabled(bl);
        this.txtComment.setOpaque(bl);
    }

    public void commit(Relation relation, Schema[] schemaArray, boolean bl) throws TraversalException {
        RelationInfoVerifier relationInfoVerifier = (RelationInfoVerifier)this.getVerifier();
        Schema schema = this.cmbOwner.getSchema(schemaArray);
        String string = this.getInternalName(this.fldName.getText());
        relation.setSchema(schema);
        relation.setName(string);
        String string2 = this.txtComment.getText();
        relation.setProperty("Comment", (Object)(ModelUtil.hasLength((String)string2) ? string2 : null));
        if (bl && relationInfoVerifier != null) {
            relationInfoVerifier.verifyRelation();
        }
    }

    public void setOwnerLabel(String string) {
        ResourceUtils.resLabel((JLabel)this.lblOwner, (Component)((Object)this.cmbOwner), (String)string);
    }

    public void setTopLabel(String string) {
        this.lblTop.setText(string);
    }

    public void checkCallbacks(WizardCallbacks wizardCallbacks) {
        if (this.fldName.isEnabled()) {
            wizardCallbacks.wizardSetInitialFocus((Component)this.fldName);
        } else if (this.cmbOwner.isEnabled()) {
            wizardCallbacks.wizardSetInitialFocus((Component)((Object)this.cmbOwner));
        } else {
            wizardCallbacks.wizardSetInitialFocus((Component)this.txtComment);
        }
    }

    private static class SchemaRenderer
    extends BasicComboBoxRenderer {
        private DBObjectProvider _prov;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof String && this._prov != null) {
                object = this._prov.getInternalName((String)object, "SCHEMA");
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }

        public void setProvider(DBObjectProvider dBObjectProvider) {
            this._prov = dBObjectProvider;
        }

        private SchemaRenderer() {
        }
    }
}

