/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.sql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cm.dt.ui.AbstractTreePicker;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.DBObjectTransferable;
import oracle.jdeveloper.cm.dt.ui.TreeNodeMaker;
import oracle.jdeveloper.cm.dt.ui.sql.JoinObjectEditDialog;
import oracle.jdeveloper.cm.dt.ui.sql.SQLQueryEditDialog;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class FromJoinToPicker
extends AbstractTreePicker
implements DocumentListener {
    public static final String REMOVE_FROM_HELP_ID = "f1_offdbremovefromfromlist_html";
    private JPanel m_panel;
    private DefaultMutableTreeNode m_treeRoot;
    private DefaultTreeModel m_treeModel;
    private JTree m_tree;
    private DBObjectRenderer m_rend;
    private TreeNodeMaker m_nodeMaker;
    private JLabel m_aliasLabel;
    private JTextField m_alias;
    private JButton m_joinButton;
    private JButton m_editButton;
    private boolean m_commitPending;
    private boolean m_ignoreTree;
    private DefaultMutableTreeNode m_current;
    private SQLQueryBuilder m_builder;
    private DBObjectProvider m_pro;
    private Schema m_schema;

    void $init$() {
        this.m_treeRoot = new DefaultMutableTreeNode("ROOT");
        this.m_treeModel = new DefaultTreeModel(this.m_treeRoot);
        this.m_tree = new JTree(this.m_treeModel);
        this.m_rend = new DBObjectRenderer();
        this.m_nodeMaker = new TreeNodeMaker(true);
        this.m_aliasLabel = new JLabel();
        this.m_alias = new JTextField();
        this.m_joinButton = new JButton();
        this.m_editButton = new JButton();
    }

    public FromJoinToPicker() {
        this.$init$();
        this.m_rend.setIncludeIcon(true);
        this.setTree(this.m_tree);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setRootVisible(false);
        this.m_tree.setCellRenderer(this.m_rend);
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new GridBagLayout());
        int n = 0;
        this.m_panel.add((Component)new JScrollPane(this.m_tree), new GridBagConstraints(1, n, 4, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_aliasLabel, (Component)this.m_alias, (String)CmWizardsArb.getString(251));
        this.m_panel.add((Component)this.m_aliasLabel, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.m_alias.getDocument().addDocumentListener(this);
        this.m_panel.add((Component)this.m_alias, new GridBagConstraints(2, n, 3, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_panel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, ++n, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_joinButton, (String)CmWizardsArb.getString(488));
        this.m_joinButton.addActionListener(this);
        this.m_panel.add((Component)this.m_joinButton, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_editButton, (String)CmWizardsArb.getString(487));
        this.m_editButton.addActionListener(this);
        this.m_panel.add((Component)this.m_editButton, new GridBagConstraints(4, n, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void init(SQLQueryBuilder sQLQueryBuilder, DBObjectProvider dBObjectProvider, Schema schema) {
        this.m_builder = sQLQueryBuilder;
        this.m_pro = dBObjectProvider;
        this.m_schema = schema;
        this.m_aliasLabel.setEnabled(false);
        this.m_alias.setEnabled(false);
        this.m_joinButton.setEnabled(false);
        this.m_editButton.setEnabled(false);
        this.loadTree();
    }

    private void loadTree() {
        this.m_treeRoot.removeAllChildren();
        FromObject[] fromObjectArray = this.m_builder.getSQLQuery().getFromObjects();
        int n = 0;
        while (n < fromObjectArray.length) {
            this.m_treeRoot.add(this.m_nodeMaker.createTreeNode((SQLFragment)fromObjectArray[n]));
            ++n;
        }
        this.reloadTreeUI();
    }

    private void reloadTreeUI() {
        this.m_treeModel.reload();
        IdeUtil.expandAllTreeRows((JTree)this.m_tree);
    }

    protected void setSelectedObject(FromObject fromObject) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (fromObject != null && (defaultMutableTreeNode = this.findNode(fromObject, this.m_treeRoot)) != null) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.m_tree.setSelectionPath(treePath);
        }
    }

    private DefaultMutableTreeNode findNode(FromObject fromObject, DefaultMutableTreeNode defaultMutableTreeNode) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!fromObject.equals(defaultMutableTreeNode2.getUserObject())) continue;
            return defaultMutableTreeNode2;
        }
        enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            this.findNode(fromObject, (DefaultMutableTreeNode)enumeration.nextElement());
        }
        return null;
    }

    protected void commit() throws SQLQueryException {
        if (this.m_commitPending) {
            FromObject fromObject = (FromObject)this.m_current.getUserObject();
            String string = this.m_alias.getText();
            if (ModelUtil.areDifferent((Object)string, (Object)fromObject.getAlias())) {
                FromObject fromObject2 = (FromObject)fromObject.copyTo(null);
                fromObject2.setAlias(string);
                this.m_builder.replaceFromObject(fromObject, fromObject2);
                this.m_treeModel.nodeChanged(this.m_current);
            }
            this.m_commitPending = false;
        }
    }

    protected void exit() throws TraversalException {
        try {
            this.commit();
            if (this.m_builder != null) {
                this.m_builder.syncViewColumns();
            }
        }
        catch (SQLQueryException sQLQueryException) {
            this.m_alias.requestFocus();
            throw new TraversalException(sQLQueryException.getMessage());
        }
    }

    private boolean isJoinNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FromObject) {
            return ((FromObject)object).getExpression() instanceof JoinObject;
        }
        return false;
    }

    private boolean isSubQueryNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FromObject) {
            return ((FromObject)object).getExpression() instanceof SQLQuery;
        }
        return false;
    }

    private void join(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        JoinObject joinObject = new JoinObject();
        FromObject fromObject = new FromObject();
        fromObject.setExpression((SQLFragment)joinObject);
        FromObject fromObject2 = (FromObject)defaultMutableTreeNode.getUserObject();
        FromObject fromObject3 = (FromObject)defaultMutableTreeNode2.getUserObject();
        joinObject.setLeftExpression(fromObject2);
        joinObject.setRightExpression(fromObject3);
        if (JoinObjectEditDialog.editJoin(fromObject, this.m_editButton, this.m_builder)) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.m_nodeMaker.createTreeNode((SQLFragment)fromObject);
            DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            defaultMutableTreeNode4.insert(defaultMutableTreeNode3, defaultMutableTreeNode4.getIndex(defaultMutableTreeNode));
            defaultMutableTreeNode4.remove(defaultMutableTreeNode);
            defaultMutableTreeNode4.remove(defaultMutableTreeNode2);
            this.reloadTreeUI();
            this.m_tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode3.getPath()));
            DeclarativeSQLQuery declarativeSQLQuery = this.m_builder.getSQLQuery();
            declarativeSQLQuery.removeFromObject(fromObject2);
            declarativeSQLQuery.removeFromObject(fromObject3);
            try {
                this.m_builder.addFromObject(fromObject);
            }
            catch (SQLQueryException sQLQueryException) {
                declarativeSQLQuery.addFromObject(fromObject2);
                declarativeSQLQuery.addFromObject(fromObject3);
            }
        }
    }

    private boolean edit(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof FromObject) {
            SQLFragment sQLFragment = ((FromObject)object).getExpression();
            if (sQLFragment instanceof SQLQuery) {
                try {
                    SQLQueryEditDialog sQLQueryEditDialog = new SQLQueryEditDialog();
                    SQLQuery sQLQuery = sQLQueryEditDialog.editQuery((SQLQuery)sQLFragment, this.m_pro, this.m_schema);
                    if (ModelUtil.areDifferent((Object)sQLQuery, (Object)object)) {
                        FromObject fromObject = new FromObject();
                        fromObject.setAlias(((FromObject)object).getAlias());
                        fromObject.setExpression((SQLFragment)sQLQuery);
                        this.m_builder.replaceFromObject((FromObject)object, fromObject);
                    }
                }
                catch (SQLQueryException sQLQueryException) {
                    ExceptionDialog.showExceptionDialog((Component)this.m_tree, (Throwable)sQLQueryException, (String)"Error editing sub-query");
                }
                return true;
            }
            if (sQLFragment instanceof JoinObject) {
                if (JoinObjectEditDialog.editJoin((FromObject)object, this.m_editButton, this.m_builder)) {
                    sQLFragment = ((FromObject)object).getExpression();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
                    FromObject fromObject = ((JoinObject)sQLFragment).getLeftExpression();
                    if (fromObject == defaultMutableTreeNode3.getUserObject()) {
                        defaultMutableTreeNode2.removeFromParent();
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        this.m_treeModel.reload(defaultMutableTreeNode);
                    } else {
                        this.m_treeModel.nodeStructureChanged(defaultMutableTreeNode);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void addJoinToSelection(DefaultMutableTreeNode defaultMutableTreeNode, List list) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0);
        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1);
        list.add(new TreePath(defaultMutableTreeNode.getPath()));
        if (this.isJoinNode(defaultMutableTreeNode2)) {
            this.addJoinToSelection(defaultMutableTreeNode2, list);
        } else {
            list.add(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        if (this.isJoinNode(defaultMutableTreeNode3)) {
            this.addJoinToSelection(defaultMutableTreeNode3, list);
        } else {
            list.add(new TreePath(defaultMutableTreeNode3.getPath()));
        }
    }

    private void addRelation(Relation relation, List list, DefaultMutableTreeNode defaultMutableTreeNode) throws SQLQueryException {
        SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet = this.m_builder.constructFromObject(relation, false, false, null);
        FromObject fromObject = (FromObject)sQLQueryObjectSet.getObject();
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.m_nodeMaker.createTreeNode((SQLFragment)fromObject);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        list.add(new TreePath(defaultMutableTreeNode2.getPath()));
    }

    private void addFKs(DBObject[] dBObjectArray, List list) throws SQLQueryException {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        int n = 0;
        while (n < dBObjectArray.length) {
            if (dBObjectArray[n] instanceof FKConstraint) {
                arrayList.add(dBObjectArray[n]);
            }
            ++n;
        }
        FKConstraint[] fKConstraintArray = arrayList.toArray(new FKConstraint[arrayList.size()]);
        SQLQueryBuilder.SQLQueryObjectSet sQLQueryObjectSet = this.m_builder.constructFKJoins(fKConstraintArray, null);
        FromObject[] fromObjectArray = sQLQueryObjectSet.getFromObjects();
        if (fromObjectArray != null && fromObjectArray.length > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.m_nodeMaker.createTreeNode((SQLFragment)fromObjectArray[0], false);
            this.m_treeRoot.add(defaultMutableTreeNode);
            this.addJoinToSelection(defaultMutableTreeNode, list);
        }
    }

    public boolean addSelectedItems(Transferable[] transferableArray) {
        try {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < transferableArray.length) {
                DBObject dBObject = ((DBObjectTransferable)transferableArray[n]).getDBObject();
                DBObject[] dBObjectArray = ((DBObjectTransferable)transferableArray[n]).getPath();
                if (dBObjectArray == null || dBObjectArray.length == 1) {
                    if (dBObject instanceof Relation) {
                        this.addRelation((Relation)dBObject, arrayList, this.m_treeRoot);
                    }
                } else {
                    this.addFKs(dBObjectArray, arrayList);
                }
                ++n;
            }
            this.reloadTreeUI();
            this.m_tree.setSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
            boolean bl = true;
            return bl;
        }
        catch (SQLQueryException sQLQueryException) {
            ExceptionDialog.showExceptionDialog((Component)this.getComponent(), (Throwable)sQLQueryException, (String)sQLQueryException.getMessage());
            return false;
        }
    }

    public Transferable createTransferable(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() instanceof SQLFragment) {
            return new DBObjectTransferable(null);
        }
        return null;
    }

    public Transferable[] getAllSelectableItems() {
        return new DBObjectTransferable[]{new DBObjectTransferable(null)};
    }

    public void removeAllSelectableItems() {
        ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
        FromObject[] fromObjectArray = this.m_builder.getSQLQuery().getFromObjects();
        int n = 0;
        while (fromObjectArray != null && n < fromObjectArray.length) {
            arrayList.addAll(Arrays.asList(this.m_builder.getDependentObjects(fromObjectArray[n])));
            ++n;
        }
        String string = CmWizardsArb.getString(267);
        if (arrayList.size() < 1 || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)CmWizardsArb.getString(268), (String)REMOVE_FROM_HELP_ID, (boolean)true)) {
            int n2 = 0;
            while (fromObjectArray != null && n2 < fromObjectArray.length) {
                this.m_builder.removeFromObject(fromObjectArray[n2]);
                ++n2;
            }
            this.m_treeRoot.removeAllChildren();
            this.m_treeModel.reload();
        }
    }

    public void removeSelectedItems() {
        boolean bl = true;
        ArrayList<SQLFragment> arrayList = new ArrayList<SQLFragment>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        HashSet<DBObject> hashSet = new HashSet<DBObject>();
        TreePath[] treePathArray = this.m_tree.getSelectionPaths();
        int n = 0;
        while (n < treePathArray.length) {
            Object object;
            Object object2 = treePathArray[n].getLastPathComponent();
            if (object2 instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)object2).getUserObject()) instanceof FromObject) {
                FromObject fromObject = (FromObject)object;
                SQLFragment sQLFragment = fromObject.getExpression();
                if (sQLFragment instanceof JoinObject) {
                    arrayList3.add(object);
                } else {
                    DBObject dBObject;
                    SQLFragment[] sQLFragmentArray = this.m_builder.getDependentObjects(fromObject);
                    if (sQLFragmentArray != null) {
                        arrayList.addAll(Arrays.asList(sQLFragmentArray));
                    }
                    if ((dBObject = fromObject.getParent()) instanceof JoinObject) {
                        hashSet.add(dBObject);
                    }
                    arrayList2.add(object);
                }
            }
            ++n;
        }
        for (JoinObject joinObject : hashSet) {
            FromObject fromObject;
            FromObject fromObject2;
            if (!(joinObject.getParent() instanceof FromObject) || !arrayList2.contains(fromObject2 = joinObject.getLeftExpression()) || !arrayList2.contains(fromObject = joinObject.getRightExpression())) continue;
            arrayList2.remove(fromObject2);
            arrayList2.remove(fromObject);
            arrayList2.add(joinObject.getParent());
            if (!arrayList3.contains(joinObject)) continue;
            arrayList3.remove(joinObject);
        }
        boolean bl2 = true;
        if (arrayList.size() > 0) {
            String string = CmWizardsArb.getString(267);
            bl2 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)CmWizardsArb.getString(268), (String)REMOVE_FROM_HELP_ID, (boolean)true);
        }
        if (bl2) {
            int n2 = 0;
            while (n2 < arrayList2.size()) {
                Object e = arrayList2.get(n2);
                if (e instanceof FromObject) {
                    this.m_builder.removeFromObject((FromObject)e);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < arrayList3.size()) {
                Object e = arrayList3.get(n3);
                if (e instanceof FromObject) {
                    this.m_builder.removeJoinObject((FromObject)e);
                }
                ++n3;
            }
            this.m_commitPending = false;
            this.loadTree();
        }
    }

    public Component getComponent() {
        return this.m_panel;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.m_commitPending = true;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.m_ignoreTree) {
            if (this.m_alias.isEnabled()) {
                try {
                    this.commit();
                }
                catch (SQLQueryException sQLQueryException) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLQueryException.getMessage(), (String)"", null);
                    this.m_ignoreTree = true;
                    this.m_tree.setSelectionPath(treeSelectionEvent.getOldLeadSelectionPath());
                    this.m_ignoreTree = false;
                    this.m_alias.requestFocus();
                    return;
                }
            }
            super.valueChanged(treeSelectionEvent);
            this.m_joinButton.setEnabled(false);
            this.m_editButton.setEnabled(false);
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            FromObject fromObject = null;
            TreePath[] treePathArray = this.m_tree.getSelectionPaths();
            if (treePathArray != null) {
                if (treePathArray.length == 1) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
                    if (this.isJoinNode(defaultMutableTreeNode2) || this.isSubQueryNode(defaultMutableTreeNode2)) {
                        this.m_editButton.setEnabled(true);
                    } else if (defaultMutableTreeNode2.getUserObject() instanceof FromObject) {
                        fromObject = (FromObject)defaultMutableTreeNode2.getUserObject();
                        defaultMutableTreeNode = defaultMutableTreeNode2;
                    }
                } else if (treePathArray.length == 2) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)treePathArray[1].getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode5 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent();
                    if (defaultMutableTreeNode5 == defaultMutableTreeNode4.getParent() && !this.isJoinNode(defaultMutableTreeNode5)) {
                        this.m_joinButton.setEnabled(true);
                    }
                }
            }
            if (fromObject != null) {
                if (defaultMutableTreeNode != this.m_current) {
                    this.m_current = defaultMutableTreeNode;
                    this.m_alias.setEnabled(true);
                    this.m_aliasLabel.setEnabled(true);
                    this.m_alias.setText(fromObject.getAlias());
                    this.m_alias.requestFocus();
                    this.m_commitPending = false;
                }
            } else {
                this.m_current = null;
                this.m_alias.setText(null);
                this.m_alias.setEnabled(false);
                this.m_aliasLabel.setEnabled(false);
                this.m_commitPending = false;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_joinButton) {
            TreePath[] treePathArray = this.m_tree.getSelectionPaths();
            if (treePathArray.length == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[0].getLastPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treePathArray[1].getLastPathComponent();
                this.join(defaultMutableTreeNode, defaultMutableTreeNode2);
            }
        } else if (object == this.m_editButton) {
            TreePath[] treePathArray = this.m_tree.getSelectionPaths();
            if (treePathArray.length == 1) {
                this.edit((DefaultMutableTreeNode)treePathArray[0].getLastPathComponent());
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected boolean handleDefaultAction(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (this.isJoinNode((DefaultMutableTreeNode)object) || this.isSubQueryNode((DefaultMutableTreeNode)object)) {
                return this.edit((DefaultMutableTreeNode)object);
            }
        }
        return super.handleDefaultAction(treePath);
    }
}

