/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.sql;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.completionfield.CompletionTextArea;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.jdeveloper.cm.dt.dialog.DBExceptionDialog;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.ExpressionEditSupport;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class JoinObjectEditDialog
extends JPanel
implements DocumentListener,
Comparator,
VetoableChangeListener,
CheckBoxListItemStateListener,
ActionListener,
ItemListener {
    public static final String JOIN_HELP_ID = "f1_dbsqljoindialog_html";
    private JoinObject m_join;
    private SQLQueryBuilder m_builder;
    private final DBObjectRenderer m_rend;
    private final JWrappedLabel m_desc;
    private final JLabel m_typeListLabel;
    private final JComboBox m_typeList;
    private final JCheckBox m_natural;
    private final JRadioButton m_using;
    private final JRadioButton m_on;
    private final ButtonGroup m_condition;
    private final JPanel m_conditionPanel;
    private final JButton m_swapExpressions;
    private CompletionTextArea m_onCondition;
    private CheckBoxListPanel m_usingList;
    private JEWTDialog m_dialog;
    private JButton m_fkButton;

    void $init$() {
        this.m_rend = new DBObjectRenderer();
        this.m_desc = new JWrappedLabel();
        this.m_typeListLabel = new JLabel();
        this.m_typeList = new JComboBox();
        this.m_natural = new JCheckBox();
        this.m_using = new JRadioButton();
        this.m_on = new JRadioButton();
        this.m_condition = new ButtonGroup();
        this.m_conditionPanel = new JPanel();
        this.m_swapExpressions = new JButton();
    }

    public JoinObjectEditDialog() {
        this.$init$();
        try {
            this.layoutComponents();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, JOIN_HELP_ID);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add((Component)this.m_desc, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_swapExpressions, (String)CmWizardsArb.getString(278));
        this.m_swapExpressions.addActionListener(this);
        this.add((Component)this.m_swapExpressions, new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_typeListLabel, (Component)this.m_typeList, (String)CmWizardsArb.getString(273));
        this.add((Component)this.m_typeListLabel, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_typeList.addItem("CROSS");
        this.m_typeList.addItem("FULL");
        this.m_typeList.addItem("INNER");
        this.m_typeList.addItem("LEFT");
        this.m_typeList.addItem("RIGHT");
        this.m_typeList.addItemListener(this);
        this.add((Component)this.m_typeList, new GridBagConstraints(2, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_natural, (String)"&NATURAL");
        this.m_natural.addActionListener(this);
        this.add((Component)this.m_natural, new GridBagConstraints(1, ++n, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_on, (String)"&ON");
        this.m_condition.add(this.m_on);
        this.m_on.addActionListener(this);
        this.add((Component)this.m_on, new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        ResourceUtils.resButton((AbstractButton)this.m_using, (String)"&USING");
        this.m_condition.add(this.m_using);
        this.m_using.addActionListener(this);
        this.add((Component)this.m_using, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_conditionPanel.setLayout(new GridBagLayout());
        this.add((Component)this.m_conditionPanel, new GridBagConstraints(1, ++n, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setupOnPanel() {
        this.m_conditionPanel.removeAll();
        if (this.m_onCondition == null) {
            JoinCondition joinCondition;
            this.m_onCondition = new CompletionTextArea();
            this.m_onCondition.setLineWrap(true);
            this.m_onCondition.setWrapStyleWord(true);
            this.m_onCondition.getDocument().addDocumentListener(this);
            ExpressionEditSupport expressionEditSupport = new ExpressionEditSupport((JTextComponent)this.m_onCondition);
            expressionEditSupport.setInsightMap(ExpressionEditSupport.createInsightMap(new FromObject[]{this.m_join.getLeftExpression(), this.m_join.getRightExpression()}));
            HashSet<FromObject> hashSet = new HashSet<FromObject>();
            hashSet.add(this.m_join.getLeftExpression());
            hashSet.add(this.m_join.getRightExpression());
            expressionEditSupport.setInsightObjects(hashSet);
            if (this.m_join != null && (joinCondition = this.m_join.getCondition()) != null && joinCondition instanceof OnJoinCondition) {
                this.m_onCondition.setText(((OnJoinCondition)joinCondition).getConditionText());
            }
        }
        this.m_conditionPanel.add((Component)new JScrollPane((Component)this.m_onCondition, 22, 31), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.validate();
        this.m_conditionPanel.repaint();
    }

    private void setupUsingPanel() {
        this.m_conditionPanel.removeAll();
        if (this.m_usingList == null) {
            JoinCondition joinCondition;
            TreeSet<FromObjectUsage> treeSet = null;
            Collection collection = this.getCommonFromObjectUsages(this.m_join.getLeftExpression(), this.m_join.getRightExpression(), false);
            if (this.m_join != null && (joinCondition = this.m_join.getCondition()) != null && joinCondition instanceof UsingJoinCondition) {
                FromObjectUsage[] fromObjectUsageArray = ((UsingJoinCondition)joinCondition).getColumns();
                treeSet = new TreeSet<FromObjectUsage>(this);
                int n = 0;
                while (n < fromObjectUsageArray.length) {
                    treeSet.add(fromObjectUsageArray[n]);
                    ++n;
                }
            }
            Iterator iterator = collection.iterator();
            CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                boolean bl = treeSet == null || treeSet.contains(e);
                checkBoxListModel.addElement(e, null, true, bl);
            }
            this.m_usingList = new CheckBoxListPanel(checkBoxListModel);
            if (collection.size() < 1) {
                MessageDialog.error((Component)this, (Object)"Cannot use USING - no common columns", (String)"USING", null);
            }
        }
        this.m_conditionPanel.add((Component)this.m_usingList, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.validate();
        this.m_conditionPanel.repaint();
    }

    private void setDialog(JEWTDialog jEWTDialog) {
        this.m_dialog = jEWTDialog;
        this.m_dialog.addVetoableChangeListener((VetoableChangeListener)this);
    }

    private void enableCondition(boolean bl) {
        this.m_using.setEnabled(bl);
        this.m_on.setEnabled(bl);
        this.enable(this.m_conditionPanel, bl);
    }

    private void enable(Container container, boolean bl) {
        if (container != null) {
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component instanceof Container) {
                    this.enable((Container)component, bl);
                }
                ++n2;
            }
            container.setEnabled(bl);
        }
    }

    public void setBuilder(SQLQueryBuilder sQLQueryBuilder) {
        this.m_builder = sQLQueryBuilder;
    }

    public JoinObject getJoin() {
        return this.m_join;
    }

    public void setJoin(JoinObject joinObject) {
        this.m_join = joinObject;
        this.setDescription();
        JoinCondition joinCondition = this.m_join.getCondition();
        this.enableCondition(true);
        if (joinCondition == null && !joinObject.isNatural()) {
            Collection collection = this.getCommonFromObjectUsages(this.m_join.getLeftExpression(), this.m_join.getRightExpression(), false);
            if (collection == null || collection.size() < 1) {
                this.m_on.setSelected(true);
                this.setupOnPanel();
            } else {
                this.m_using.setSelected(true);
                this.setupUsingPanel();
            }
        } else if (joinCondition instanceof UsingJoinCondition) {
            this.m_using.setSelected(true);
            this.setupUsingPanel();
        } else {
            this.m_on.setSelected(true);
            this.setupOnPanel();
        }
        this.m_natural.setSelected(this.m_join.isNatural());
        this.m_typeList.setSelectedItem(this.m_join.getJoinType());
        this.joinTypeChanged();
    }

    public void commit() throws SQLQueryException {
        String string = (String)this.m_typeList.getSelectedItem();
        JoinCondition joinCondition = this.m_join.getCondition();
        UsingJoinCondition usingJoinCondition = null;
        if (this.m_using.isEnabled()) {
            if (this.m_using.isSelected()) {
                usingJoinCondition = joinCondition != null && joinCondition instanceof UsingJoinCondition ? (UsingJoinCondition)joinCondition : new UsingJoinCondition();
                List list = this.m_usingList.getList().getCheckBoxListModel().getSelectionList();
                if (list == null || list.size() < 1) {
                    throw new SQLQueryException(CmWizardsArb.getString(274));
                }
                FromObjectUsage[] fromObjectUsageArray = list.toArray(new FromObjectUsage[list.size()]);
                usingJoinCondition.setColumns(fromObjectUsageArray);
            } else {
                String string2;
                usingJoinCondition = joinCondition != null && joinCondition instanceof OnJoinCondition ? (OnJoinCondition)joinCondition : new OnJoinCondition();
                String string3 = string2 = this.m_condition == null ? null : this.m_onCondition.getText().trim();
                if (!ModelUtil.hasLength((String)string2)) {
                    throw new SQLQueryException(CmWizardsArb.getString(275));
                }
                if (joinCondition == null || ModelUtil.areDifferent((Object)string2, (Object)joinCondition.getConditionText())) {
                    try {
                        OnJoinCondition onJoinCondition = this.m_builder.parseOnExpression(string2, this.m_join);
                        onJoinCondition.copyTo((Object)usingJoinCondition);
                    }
                    catch (SQLParseException sQLParseException) {
                        throw new SQLQueryException(CmWizardsArb.format(276, sQLParseException.getMessage()));
                    }
                }
            }
        }
        this.m_join.setJoinType(string);
        this.m_join.setNatural(this.m_natural.isSelected());
        this.m_join.setCondition((JoinCondition)usingJoinCondition);
    }

    private Collection getCommonFromObjectUsages(FromObject fromObject, FromObject fromObject2, boolean bl) {
        Collection collection = ExpressionEditSupport.getColumns(fromObject);
        Collection collection2 = ExpressionEditSupport.getColumns(fromObject2);
        TreeSet<Object> treeSet = new TreeSet<Object>(this);
        for (Object e : collection) {
            if (!collection2.contains(e)) continue;
            if (e instanceof Column) {
                treeSet.add(new ColumnUsage(((Column)e).getID(), (FromObject)(bl ? fromObject : null)));
                continue;
            }
            if (!(e instanceof SelectObject)) continue;
            treeSet.add(new SelectObjectUsage((SelectObject)e, (FromObject)(bl ? fromObject : null)));
        }
        return treeSet;
    }

    private void setDescription() {
        FromObject fromObject = this.m_join.getLeftExpression();
        FromObject fromObject2 = this.m_join.getRightExpression();
        this.m_desc.setText(CmWizardsArb.format(272, fromObject.getName(), fromObject2.getName()));
    }

    private void checkOKButton() {
        if (this.m_dialog != null) {
            boolean bl = true;
            if (this.m_usingList != null && this.m_using.isSelected()) {
                List list = this.m_usingList.getList().getCheckBoxListModel().getSelectionList();
                if (list == null || list.size() < 1) {
                    bl = false;
                }
            } else if (this.m_onCondition != null && this.m_on.isSelected() && this.m_onCondition.getText().length() < 1) {
                bl = false;
            }
            this.m_dialog.setOKButtonEnabled(bl);
        }
    }

    private void joinTypeChanged() {
        if (this.m_typeList.getSelectedItem().equals("CROSS")) {
            this.m_natural.setSelected(false);
            this.m_natural.setEnabled(false);
            this.enableCondition(false);
        } else {
            this.m_natural.setEnabled(true);
            this.enableCondition(this.m_join.isNatural() ^ true);
        }
    }

    public int compare(Object object, Object object2) {
        if (object instanceof FromObjectUsage && object2 instanceof FromObjectUsage) {
            String string = ((FromObjectUsage)object).getColumnName();
            String string2 = ((FromObjectUsage)object2).getColumnName();
            return string.compareTo(string2);
        }
        return object.toString().compareTo(object2.toString());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.m_typeList) {
            this.joinTypeChanged();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = actionEvent.getModifiers();
        if (object == this.m_natural) {
            this.enableCondition(this.m_natural.isSelected() ^ true);
        } else if (object == this.m_using || object == this.m_on) {
            if (this.m_using.isSelected()) {
                this.setupUsingPanel();
                this.m_usingList.getList().requestFocus();
                this.checkOKButton();
            } else {
                this.setupOnPanel();
                this.m_onCondition.requestFocus();
                this.checkOKButton();
            }
        } else if (object == this.m_swapExpressions) {
            FromObject fromObject = this.m_join.getLeftExpression();
            FromObject fromObject2 = this.m_join.getRightExpression();
            this.m_join.setLeftExpression(fromObject2);
            this.m_join.setRightExpression(fromObject);
            this.setDescription();
        }
    }

    public void stateChanged(Object object) {
        this.checkOKButton();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkOKButton();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkOKButton();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkOKButton();
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
            try {
                this.commit();
            }
            catch (SQLQueryException sQLQueryException) {
                MessageDialog.error((Component)this, (Object)sQLQueryException.getMessage(), (String)CmWizardsArb.getString(277), null);
                throw new PropertyVetoException("invalid join condition", propertyChangeEvent);
            }
        }
    }

    public static boolean editJoin(FromObject fromObject, Component component, SQLQueryBuilder sQLQueryBuilder) {
        String string = CmWizardsArb.getString(271);
        JoinObject joinObject = (JoinObject)fromObject.getExpression();
        FromObject fromObject2 = joinObject.getLeftExpression();
        FromObject fromObject3 = joinObject.getRightExpression();
        if (fromObject2 == null || fromObject3 == null) {
            throw new IllegalArgumentException("Join must have a left and right expression setup");
        }
        int n = 7;
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)string, (int)n);
        JoinObjectEditDialog joinObjectEditDialog = new JoinObjectEditDialog();
        joinObjectEditDialog.setBuilder(sQLQueryBuilder);
        JoinObject joinObject2 = (JoinObject)joinObject.copyTo(null);
        joinObject2.setLeftExpression(joinObject.getLeftExpression());
        joinObject2.setRightExpression(joinObject.getRightExpression());
        joinObjectEditDialog.setJoin(joinObject2);
        jEWTDialog.setContent((Component)joinObjectEditDialog);
        jEWTDialog.setResizable(true);
        jEWTDialog.setPreferredSize(300, 400);
        joinObjectEditDialog.setDialog(jEWTDialog);
        if (jEWTDialog.runDialog()) {
            try {
                sQLQueryBuilder.replaceFromObject(fromObject, new FromObject((SQLFragment)joinObjectEditDialog.getJoin(), null));
            }
            catch (SQLQueryException sQLQueryException) {
                DBExceptionDialog.showErrorDialog(component, string, (DBException)((Object)sQLQueryException));
            }
            return true;
        }
        jEWTDialog.dispose();
        return false;
    }
}

