/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.DataTypePanel;
import oracle.jdeveloper.cm.dt.ui.SchemaPicker;
import oracle.jdeveloper.cm.dt.verifier.table.ColumnInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class ColumnEditorPanel
extends JPanel
implements ActionListener {
    private boolean m_listening;
    private JLabel lblColName;
    private JTextField fldName;
    private JLabel lblDataType;
    private JRadioButton rdbSimpleType;
    private JRadioButton rdbComplexType;
    private JPanel m_typePanel;
    private JLabel lblType;
    private JComboBox cmbType;
    private DataTypePanel pnlDataType;
    private JLabel lblSchemas;
    private SchemaPicker cmbSchemas;
    private JLabel lblComplexType;
    private JComboBox cmbComplexType;
    private JLabel lblDefault;
    private JTextField fldDefault;
    private JCheckBox chkNotNull;
    private JLabel lblComment;
    private JTextArea fldComment;
    private JScrollPane scrComment;
    private DefaultComboBoxModel mdlTypes;
    private DefaultComboBoxModel mdlSchemas;
    private DefaultComboBoxModel mdlComplexTypes;
    private ColumnInfoVerifier m_verifier;
    private DBObjectProvider m_prov;
    private Schema m_defaultSchema;
    private Schema[] m_existingSchemas;
    private Column m_col;

    void $init$() {
        this.lblColName = new JLabel();
        this.fldName = new JTextField();
        this.lblDataType = new JLabel();
        this.rdbSimpleType = new JRadioButton();
        this.rdbComplexType = new JRadioButton();
        this.m_typePanel = new JPanel();
        this.lblType = new JLabel();
        this.cmbType = new JComboBox();
        this.pnlDataType = new DataTypePanel();
        this.lblSchemas = new JLabel();
        this.cmbSchemas = new SchemaPicker();
        this.lblComplexType = new JLabel();
        this.cmbComplexType = new JComboBox();
        this.lblDefault = new JLabel();
        this.fldDefault = new JTextField();
        this.chkNotNull = new JCheckBox();
        this.lblComment = new JLabel();
        this.fldComment = new JTextArea();
        this.scrComment = new JScrollPane();
        this.mdlTypes = new NonNullableComboBoxModel();
        this.mdlSchemas = new NonNullableComboBoxModel();
        this.mdlComplexTypes = new NonNullableComboBoxModel();
    }

    public ColumnEditorPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.lblColName, (Component)this.fldName, (String)CmWizardsArb.getString(18));
        this.fldName.setColumns(30);
        this.cmbType.setModel(this.mdlTypes);
        this.cmbType.addActionListener(this);
        this.cmbSchemas.setModel(this.mdlSchemas);
        this.cmbSchemas.setRenderer(new DBObjectRenderer());
        this.cmbSchemas.addActionListener(this);
        this.cmbSchemas.setEditable(false);
        this.cmbComplexType.addActionListener(this);
        this.cmbComplexType.setModel(this.mdlComplexTypes);
        ResourceUtils.resButton((AbstractButton)this.rdbSimpleType, (String)CmWizardsArb.getString(50));
        ResourceUtils.resButton((AbstractButton)this.rdbComplexType, (String)CmWizardsArb.getString(51));
        AccessibleContext accessibleContext = this.rdbSimpleType.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleName(DataTypeHelper.getNameFromLabel((String)CmWizardsArb.getString(49)) + DataTypeHelper.getNameFromLabel((String)CmWizardsArb.getString(50)));
        }
        if ((accessibleContext = this.rdbComplexType.getAccessibleContext()) != null) {
            accessibleContext.setAccessibleName(DataTypeHelper.getNameFromLabel((String)CmWizardsArb.getString(49)) + DataTypeHelper.getNameFromLabel((String)CmWizardsArb.getString(51)));
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rdbSimpleType);
        buttonGroup.add(this.rdbComplexType);
        this.rdbSimpleType.setSelected(true);
        this.rdbSimpleType.addActionListener(this);
        this.rdbComplexType.addActionListener(this);
        this.lblDataType.setText(CmWizardsArb.getString(49));
        ResourceUtils.resLabel((JLabel)this.lblType, (Component)this.cmbType, (String)CmWizardsArb.getString(52));
        ResourceUtils.resLabel((JLabel)this.lblComplexType, (Component)this.cmbComplexType, (String)CmWizardsArb.getString(52));
        ResourceUtils.resLabel((JLabel)this.lblSchemas, (Component)((Object)this.cmbSchemas), (String)CmWizardsArb.getString(17));
        ResourceUtils.resLabel((JLabel)this.lblDefault, (Component)this.fldDefault, (String)CmWizardsArb.getString(53));
        ResourceUtils.resButton((AbstractButton)this.chkNotNull, (String)CmWizardsArb.getString(54));
        ResourceUtils.resLabel((JLabel)this.lblComment, (Component)this.fldComment, (String)CmWizardsArb.getString(55));
        this.scrComment.setVerticalScrollBarPolicy(22);
        this.fldComment.setWrapStyleWord(true);
        this.fldComment.setLineWrap(true);
        this.scrComment.getViewport().add((Component)this.fldComment, null);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(CmWizardsArb.getString(48)));
        this.add((Component)this.lblColName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.lblDataType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 12), 0, 0));
        this.add((Component)this.rdbSimpleType, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.rdbComplexType, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.createSimpleTypePanel(this.m_typePanel);
        this.add((Component)this.m_typePanel, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 24, 0, 5), 0, 0));
        this.add(Box.createVerticalStrut(100), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.chkNotNull, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.lblComment, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.scrComment, new GridBagConstraints(0, 12, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_listening = true;
    }

    private void createSimpleTypePanel(JPanel jPanel) {
        jPanel.removeAll();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.lblType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.cmbType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.pnlDataType, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.lblDefault, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.fldDefault, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 13, 2, new Insets(10, 0, 0, 5), 0, 0));
    }

    private void createComplexTypePanel(JPanel jPanel) {
        jPanel.removeAll();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.lblSchemas, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)((Object)this.cmbSchemas), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.lblComplexType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        jPanel.add((Component)this.cmbComplexType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.pnlDataType, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private ComplexType getSelectedComplexType() {
        Schema schema = (Schema)this.mdlSchemas.getSelectedItem();
        String string = (String)this.mdlComplexTypes.getSelectedItem();
        return this.getComplexType(schema, string);
    }

    private DataType getSelectedSimpleType() {
        Object object = this.mdlTypes.getSelectedItem();
        if (object instanceof DataType) {
            return (DataType)object;
        }
        return null;
    }

    private ComplexType getComplexType(Schema schema, String string) {
        if (ModelUtil.hasLength((String)string) && schema != null) {
            try {
                SchemaObject schemaObject = this.m_prov.getObject("TYPE", schema, string);
                if (schemaObject != null) {
                    ComplexType complexType = (ComplexType)schemaObject;
                    return complexType;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
            try {
                DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)this.m_col.getDataTypeUsage());
                if (dataType instanceof ComplexType && ModelUtil.areEqual((Object)dataType.getName(), (Object)string) && ModelUtil.areEqual((Object)((ComplexType)dataType).getSchema().getName(), (Object)schema.getName())) {
                    ComplexType complexType = (ComplexType)dataType;
                    return complexType;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return null;
    }

    private SchemaObject[] getComplexTypes(Schema schema) {
        try {
            SchemaObject[] schemaObjectArray = this.m_prov.listObjects(new String[]{"TYPE"}, schema);
            return schemaObjectArray;
        }
        catch (DBException dBException) {
            return null;
        }
    }

    public void init(DBObjectProvider dBObjectProvider, Schema schema, ColumnInfoVerifier columnInfoVerifier) {
        this.m_prov = dBObjectProvider;
        this.m_defaultSchema = schema;
        this.m_verifier = columnInfoVerifier;
        if (this.mdlTypes.getSize() < 1) {
            DataType[] dataTypeArray;
            DataType[] dataTypeArray2 = dBObjectProvider.listSupportedDataTypes();
            TreeSet<DataType> treeSet = new TreeSet<DataType>(new 2());
            int n = 0;
            while (n < dataTypeArray2.length) {
                treeSet.add(dataTypeArray2[n]);
                ++n;
            }
            if (columnInfoVerifier != null && (dataTypeArray = columnInfoVerifier.getPreferredTypes()) != null) {
                int n2 = 0;
                while (n2 < dataTypeArray.length) {
                    this.mdlTypes.addElement(dataTypeArray[n2]);
                    ++n2;
                }
                this.mdlTypes.addElement("--------");
            }
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                this.mdlTypes.addElement(iterator.next());
            }
        }
    }

    private void initSchemas() {
        try {
            this.cmbSchemas.setProvider(this.m_prov);
            try {
                this.m_listening = false;
                this.mdlSchemas.removeAllElements();
                if (this.m_existingSchemas == null) {
                    this.m_existingSchemas = this.m_prov.listSchemas();
                }
                int n = 0;
                while (n < this.m_existingSchemas.length) {
                    this.mdlSchemas.addElement(this.m_existingSchemas[n]);
                    ++n;
                }
            }
            finally {
                this.m_listening = true;
            }
            this.cmbSchemas.setSelectedItem(this.m_defaultSchema);
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public void setColumn(Column column) {
        if (column == null) {
            this.m_col = null;
        } else {
            this.m_col = (Column)column.copyTo(null);
            this.m_col.setRelation(column.getRelation());
        }
        this.updateColumnData();
    }

    public void commit(Column column) throws TraversalException {
        Column column2 = (Column)column.copyTo(null);
        column2.setRelation(column.getRelation());
        String string = this.m_prov.getInternalName(this.fldName.getText());
        column2.setName(string);
        ComplexType complexType = null;
        if (this.rdbSimpleType.isSelected()) {
            String string2 = this.fldDefault.getText();
            column2.setDefault((Object)(ModelUtil.hasLength((String)string2) ? string2 : null));
            complexType = this.getSelectedSimpleType();
        } else {
            complexType = this.getSelectedComplexType();
            column2.setDefault(null);
        }
        if (complexType == null) {
            throw new TraversalException(DBArb.format((int)147, (Object)column2.getName()));
        }
        try {
            DataTypeUsage dataTypeUsage = this.pnlDataType.commit();
            complexType.validateUsage(dataTypeUsage, (DBObject)column2);
            column2.setDataTypeUsage(dataTypeUsage);
        }
        catch (ValidationException validationException) {
            throw new TraversalException(validationException.getMessage());
        }
        column2.setNotNull(this.chkNotNull.isSelected());
        String string3 = this.fldComment.getText();
        column2.setProperty("Comment", (Object)(ModelUtil.hasLength((String)string3) ? string3 : null));
        if (this.m_verifier != null) {
            this.m_verifier.verifyColumn(this.m_col, column2);
        }
        column2.copyTo((Object)column);
    }

    public JTextField getNameField() {
        return this.fldName;
    }

    private void updateColumnData() {
        if (this.m_col == null) {
            this.fldName.setText("");
            this.fldDefault.setText("");
            this.chkNotNull.setSelected(false);
            this.fldComment.setText("");
            this.lblColName.setEnabled(false);
            this.fldName.setEnabled(false);
            this.lblDataType.setEnabled(false);
            this.rdbSimpleType.setEnabled(false);
            this.rdbComplexType.setEnabled(false);
            this.lblType.setEnabled(false);
            this.cmbType.setEnabled(false);
            this.pnlDataType.setEnabled(false);
            this.lblSchemas.setEnabled(false);
            this.cmbSchemas.setEnabled(false);
            this.cmbComplexType.setEnabled(false);
            this.lblDefault.setEnabled(false);
            this.fldDefault.setEnabled(false);
            this.chkNotNull.setEnabled(false);
            this.lblComment.setEnabled(false);
            this.scrComment.setEnabled(false);
            this.fldComment.setEnabled(false);
            this.fldComment.setOpaque(false);
        } else {
            boolean bl;
            this.fldName.setText(this.m_prov.getExternalName(this.m_col.getName()));
            this.fldName.setEnabled(this.m_verifier == null || this.m_verifier.canRenameColumn(this.m_col));
            this.lblColName.setEnabled(this.m_verifier == null || this.m_verifier.canRenameColumn(this.m_col));
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)this.m_col.getDataTypeUsage());
            }
            catch (DBException dBException) {
                // empty catch block
            }
            boolean bl2 = bl = this.m_verifier == null || this.m_verifier.canChangeColumnType(this.m_col);
            if (dataType instanceof ComplexType) {
                this.rdbComplexType.getModel().setSelected(true);
                Schema schema = ((ComplexType)dataType).getSchema();
                boolean bl3 = false;
                int n = 0;
                while (n < this.mdlSchemas.getSize()) {
                    if (this.mdlSchemas.getElementAt(n).toString().equals(schema.getName())) {
                        bl3 = true;
                        break;
                    }
                    ++n;
                }
                if (!bl3) {
                    this.mdlSchemas.addElement(schema);
                }
                this.cmbSchemas.setSelectedItem(schema);
                String string = dataType.getName();
                if (this.mdlComplexTypes.getIndexOf(string) < 0) {
                    this.mdlComplexTypes.addElement(string);
                }
                this.cmbComplexType.setSelectedItem(string);
                this.createComplexTypePanel(this.m_typePanel);
            } else {
                this.mdlTypes.setSelectedItem(dataType);
                this.rdbSimpleType.getModel().setSelected(true);
                this.createSimpleTypePanel(this.m_typePanel);
            }
            this.pnlDataType.initialise(this.m_col.getDataTypeUsage());
            this.lblDataType.setEnabled(bl);
            this.rdbSimpleType.setEnabled(bl);
            this.rdbComplexType.setEnabled(bl);
            this.lblSchemas.setEnabled(bl);
            this.cmbSchemas.setEnabled(bl);
            this.cmbComplexType.setEnabled(bl);
            this.cmbType.setEnabled(bl);
            this.lblType.setEnabled(bl);
            this.pnlDataType.setEnabled(bl);
            boolean bl4 = this.m_verifier == null || this.m_verifier.canChangeColumnDefaultValue(this.m_col);
            Object object = this.m_col.getDefault();
            this.fldDefault.setText(object != null ? object.toString() : "");
            this.fldDefault.setEnabled(bl4);
            this.lblDefault.setEnabled(bl4);
            this.chkNotNull.setSelected(this.m_col.isNotNull());
            this.chkNotNull.setEnabled(this.m_verifier == null || this.m_verifier.canChangeColumnNotNullState(this.m_col));
            String string = (String)this.m_col.getProperty("Comment");
            this.fldComment.setText(string != null ? string : "");
            boolean bl5 = this.m_verifier == null || this.m_verifier.canChangeColumnComment(this.m_col);
            this.fldComment.setEnabled(bl5);
            this.fldComment.setOpaque(bl5);
            this.lblComment.setEnabled(bl5);
            this.scrComment.setEnabled(bl5);
        }
        this.validate();
        this.repaint();
    }

    private void updateDefault(DataType dataType) {
        boolean bl = true;
        boolean bl2 = true;
        if (this.m_verifier != null) {
            bl = this.m_verifier.canTakeDefaultValue(dataType);
            bl2 = this.m_verifier.canChangeColumnDefaultValue(this.m_col);
        }
        if (bl) {
            Object object = this.m_col == null ? null : this.m_col.getDefault();
            this.fldDefault.setText(object != null ? object.toString() : "");
            this.fldDefault.setEnabled(bl2);
            this.lblDefault.setEnabled(bl2);
        } else {
            this.fldDefault.setText("");
            this.fldDefault.setEnabled(false);
            this.lblDefault.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_listening) {
            Object object = actionEvent.getSource();
            if (object == this.cmbType || object == this.cmbComplexType) {
                Object object2 = object == this.cmbType ? this.getSelectedSimpleType() : this.getSelectedComplexType();
                if (object2 != null) {
                    this.pnlDataType.initialise(object2.createDefaultUsage());
                }
                this.updateDefault((DataType)object2);
            } else if (object == this.cmbSchemas) {
                Schema schema = (Schema)this.cmbSchemas.getSelectedItem();
                if (schema != null) {
                    this.mdlComplexTypes.removeAllElements();
                    SchemaObject[] schemaObjectArray = this.getComplexTypes(schema);
                    Arrays.sort(schemaObjectArray, new 1());
                    int n = 0;
                    while (schemaObjectArray != null && n < schemaObjectArray.length) {
                        this.mdlComplexTypes.addElement(schemaObjectArray[n].getName());
                        ++n;
                    }
                }
            } else if (object == this.rdbSimpleType || object == this.rdbComplexType) {
                DataType dataType;
                if (this.rdbSimpleType.isSelected()) {
                    this.createSimpleTypePanel(this.m_typePanel);
                    dataType = this.getSelectedSimpleType();
                } else {
                    this.createComplexTypePanel(this.m_typePanel);
                    this.initSchemas();
                    dataType = this.getSelectedComplexType();
                }
                this.pnlDataType.initialise(dataType == null ? null : dataType.createDefaultUsage());
                this.validate();
                this.repaint();
            }
        }
    }

    public final class 2
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof PredefinedDataType && object2 instanceof ComplexType) {
                return -1;
            }
            if (object instanceof ComplexType && object2 instanceof PredefinedDataType) {
                return 1;
            }
            return object.toString().compareTo(object2.toString());
        }
    }

    public final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            return object == null && object2 == null ? 0 : (object == null ? 1 : (object2 == null ? -1 : object.toString().compareTo(object2.toString())));
        }

        public boolean equals(Object object) {
            return object != null && this.toString().equals(object.toString());
        }
    }
}

