/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class HashPartitionQuantityPanel
extends JPanel {
    private JLabel m_hashCountLabel;
    private SpinnerNumberModel m_hashCountModel;
    private JSpinner m_hashCountSpinner;
    private JLabel m_tblsLabel;
    private DefaultListModel m_tblsFromModel;
    private ListPicker m_tblsFromPick;
    private DefaultListModel m_tblsToModel;
    private ReorderableListPicker m_tblsToPick;
    private Shuttle m_tblsShuttle;

    void $init$() {
        this.m_hashCountLabel = new JLabel();
        this.m_hashCountModel = new SpinnerNumberModel(new Integer(2), new Integer(2), null, new Integer(1));
        this.m_hashCountSpinner = new JSpinner(this.m_hashCountModel);
        this.m_tblsLabel = new JLabel();
        this.m_tblsFromModel = new DefaultListModel();
        this.m_tblsFromPick = new ListPicker(new JList(this.m_tblsFromModel));
        this.m_tblsToModel = new DefaultListModel();
        this.m_tblsToPick = new ReorderableListPicker(new JList(this.m_tblsToModel));
        this.m_tblsShuttle = new Shuttle();
    }

    public HashPartitionQuantityPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_hashCountLabel, (Component)this.m_hashCountSpinner, (String)CmWizardsArb.getString(532));
        this.m_tblsLabel.setText(CmWizardsArb.getString(533));
        this.m_tblsShuttle.setFromPicker((ItemPicker)this.m_tblsFromPick);
        this.m_tblsShuttle.setToPicker((ItemPicker)this.m_tblsToPick);
        int n = 0;
        this.add((Component)this.m_hashCountLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_hashCountSpinner, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 20), 0, 0));
        this.add((Component)this.m_tblsLabel, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_tblsShuttle, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    public void init(Table table, OracleTablePartitions oracleTablePartitions, String[] stringArray) {
        this.m_tblsFromModel.removeAllElements();
        this.m_tblsToModel.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            this.m_tblsFromModel.addElement(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = oracleTablePartitions.getHashQuantityTablespaces();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.m_tblsFromModel.removeElement(stringArray2[n2]);
            this.m_tblsToModel.addElement(stringArray2[n2]);
            ++n2;
        }
        Integer n3 = oracleTablePartitions.getHashQuantity();
        if (n3 != null) {
            this.m_hashCountModel.setValue(n3);
        }
    }

    public void commit(Table table, OracleTablePartitions oracleTablePartitions) throws ValidationException {
        Number number = this.m_hashCountModel.getNumber();
        oracleTablePartitions.setHashQuantity(number == null ? null : new Integer(number.intValue()));
        Enumeration enumeration = this.m_tblsToModel.elements();
        String[] stringArray = new String[this.m_tblsToModel.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        oracleTablePartitions.setHashQuantityTablespaces(stringArray);
        oracleTablePartitions.validateHashQuantity(table);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_hashCountLabel.setEnabled(bl);
        this.m_hashCountSpinner.setEnabled(bl);
        this.m_tblsShuttle.setEnabled(bl);
        this.m_tblsFromPick.getList().setEnabled(bl);
        this.m_tblsToPick.getList().setEnabled(bl);
    }
}

