/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideri.util.Product;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleIndexProperties;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.verifier.table.IndexInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class IndexEditorPanel
extends JPanel
implements ItemListener,
DocumentListener,
ListDataListener,
ActionListener {
    private ArrayList m_whatsHappening;
    private JList m_lstColExprs;
    private JButton m_btnAddColExpr;
    private JButton m_btnRemoveColExpr;
    private JButton m_btnUpColExpr;
    private JButton m_btnDownColExpr;
    private DefaultListModel m_mdlColExprs;
    private ListSelectionListener m_mdlColExprsListSelectionListener;
    private DefaultComboBoxModel m_mdlCmbColExpr;
    private JTextField m_fldName;
    private JComboBox m_cmbColExpr;
    private JComboBox m_cmbCol;
    private JComboBox m_cmbAsc;
    private DBObjectProvider m_prov;
    private Table m_table;
    private Index m_oldIndex;
    private Index m_index;
    private boolean m_isNewIndex;
    private IndexInfoVerifier m_verifier;
    private JRadioButton m_rdbNormal;
    private JRadioButton m_rdbText;
    private JRadioButton m_rdbNonUnique;
    private JRadioButton m_rdbUnique;
    private JRadioButton m_rdbBitmap;
    private JPanel m_pnlNormal;
    private JPanel m_pnlText;
    private GridBagConstraints m_gbcNormalText;
    WizardCallbacks m_callbacks;
    private static String WH_ADD_A_COLUMN_EXPRESSION = "Add a column expression";
    private static String WH_REMOVE_A_COLUMN_EXPRESSION = "Remove a column expression";
    private static String WH_MOVE_A_COLUMN_EXPRESSION_UP = "Move a column expression up";
    private static String WH_MOVE_A_COLUMN_EXPRESSION_DOWN = "Move a column expression down";
    private static String WH_EDIT_COLUMN_EXPRESSION = "Edit column Expression";
    private static String WH_CHANGE_COLEXPR_SELECTION = "Change column expression selection";
    private static String WH_SET_ASC_DESC = "Set the column expression order";

    void $init$() {
        this.m_whatsHappening = new ArrayList();
        this.m_lstColExprs = new JList();
        this.m_btnAddColExpr = new JButton();
        this.m_btnRemoveColExpr = new JButton();
        this.m_btnUpColExpr = new JButton();
        this.m_btnDownColExpr = new JButton();
        this.m_mdlColExprs = new DefaultListModel();
        this.m_mdlCmbColExpr = new DefaultComboBoxModel();
        this.m_fldName = new JTextField();
        this.m_cmbColExpr = new JComboBox();
        this.m_cmbCol = new JComboBox();
        this.m_cmbAsc = new JComboBox();
        this.m_rdbNormal = new JRadioButton();
        this.m_rdbText = new JRadioButton();
        this.m_rdbNonUnique = new JRadioButton();
        this.m_rdbUnique = new JRadioButton();
        this.m_rdbBitmap = new JRadioButton();
    }

    public IndexEditorPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.m_rdbNormal, (String)CmWizardsArb.getString(392));
        ResourceUtils.resButton((AbstractButton)this.m_rdbText, (String)CmWizardsArb.getString(393));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_rdbNormal);
        buttonGroup.add(this.m_rdbText);
        this.m_rdbNormal.addActionListener(this);
        this.m_rdbText.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_rdbNonUnique, (String)CmWizardsArb.getString(396));
        ResourceUtils.resButton((AbstractButton)this.m_rdbUnique, (String)CmWizardsArb.getString(397));
        ResourceUtils.resButton((AbstractButton)this.m_rdbBitmap, (String)CmWizardsArb.getString(398));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_rdbNonUnique);
        buttonGroup2.add(this.m_rdbUnique);
        buttonGroup2.add(this.m_rdbBitmap);
        this.m_rdbNonUnique.setSelected(true);
        this.m_rdbNonUnique.addActionListener(this);
        this.m_rdbUnique.addActionListener(this);
        this.m_rdbBitmap.addActionListener(this);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_lstColExprs, (String)(Product.isRaptor() ? CmWizardsArb.getString(410) : CmWizardsArb.getString(406)));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.m_lstColExprs.setModel(this.m_mdlColExprs);
        this.m_lstColExprs.setSelectionMode(0);
        Insets insets = new Insets(2, 2, 2, 2);
        this.m_btnUpColExpr.setMargin(insets);
        this.m_btnUpColExpr.setIcon(ComponentArb.getIcon((int)0));
        this.m_btnUpColExpr.setDisabledIcon(ComponentArb.getIcon((int)2));
        DBObjectRenderer.setToolTipText(this.m_btnUpColExpr, CmWizardsArb.getString(46));
        this.m_btnUpColExpr.addActionListener(this);
        this.m_btnDownColExpr.setMargin(insets);
        this.m_btnDownColExpr.setIcon(ComponentArb.getIcon((int)1));
        this.m_btnDownColExpr.setDisabledIcon(ComponentArb.getIcon((int)3));
        DBObjectRenderer.setToolTipText(this.m_btnDownColExpr, CmWizardsArb.getString(47));
        this.m_btnDownColExpr.addActionListener(this);
        this.m_btnAddColExpr.setMargin(insets);
        this.m_btnAddColExpr.setIcon(ConnectionArb.getIcon(493));
        DBObjectRenderer.setToolTipText(this.m_btnAddColExpr, CmWizardsArb.getString(401));
        this.m_btnAddColExpr.addActionListener(this);
        this.m_btnRemoveColExpr.setMargin(insets);
        this.m_btnRemoveColExpr.setIcon(ConnectionArb.getIcon(494));
        DBObjectRenderer.setToolTipText(this.m_btnRemoveColExpr, CmWizardsArb.getString(402));
        this.m_btnRemoveColExpr.addActionListener(this);
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_fldName, (String)CmWizardsArb.getString(18));
        this.m_fldName.setColumns(30);
        JLabel jLabel3 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_cmbColExpr, (String)(Product.isRaptor() ? CmWizardsArb.getString(409) : CmWizardsArb.getString(407)));
        this.m_cmbColExpr.addItemListener(this);
        this.m_cmbColExpr.setModel(this.m_mdlCmbColExpr);
        this.m_cmbColExpr.setEditable(true);
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.m_cmbAsc, (String)CmWizardsArb.getString(408));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.m_btnAddColExpr, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnRemoveColExpr, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnUpColExpr, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.m_btnDownColExpr, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        jScrollPane.getViewport().add((Component)this.m_lstColExprs, null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel2.add(Box.createHorizontalStrut(150), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel3.add((Component)this.m_cmbColExpr, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jLabel4, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
        jPanel3.add((Component)this.m_cmbAsc, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        JLabel jLabel5 = new JLabel(CmWizardsArb.getString(391));
        JLabel jLabel6 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this.m_cmbCol, (String)CmWizardsArb.getString(394));
        this.m_pnlNormal = new JPanel(new GridBagLayout());
        this.m_pnlNormal.add((Component)this.m_rdbNonUnique, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
        this.m_pnlNormal.add((Component)this.m_rdbUnique, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 15), 0, 0));
        this.m_pnlNormal.add((Component)this.m_rdbBitmap, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlNormal.add((Component)jPanel2, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.m_pnlNormal.add((Component)jPanel3, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlText = new JPanel(new GridBagLayout());
        this.m_pnlText.add((Component)jLabel6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 12), 0, 0));
        this.m_pnlText.add((Component)this.m_cmbCol, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlText.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add((Component)this.m_fldName, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)jLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add((Component)this.m_rdbNormal, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_rdbText, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_gbcNormalText = new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0);
        this.add((Component)this.m_pnlNormal, this.m_gbcNormalText);
    }

    protected void init(DBObjectProvider dBObjectProvider, Table table, IndexInfoVerifier indexInfoVerifier, WizardCallbacks wizardCallbacks, boolean bl) {
        this.m_prov = dBObjectProvider;
        this.m_table = table;
        this.m_verifier = indexInfoVerifier;
        this.m_callbacks = wizardCallbacks;
        this.m_lstColExprs.getSelectionModel().removeListSelectionListener(this.m_mdlColExprsListSelectionListener);
        this.m_mdlColExprs.removeListDataListener(this);
        this.m_mdlColExprs.removeAllElements();
        this.m_index = null;
        this.m_mdlCmbColExpr.removeAllElements();
        this.m_mdlColExprsListSelectionListener = new 1();
        this.m_mdlColExprs.addListDataListener(this);
        this.m_cmbAsc.addActionListener(this);
        this.m_cmbAsc.setEditable(false);
        if (this.m_cmbAsc.getItemCount() == 0) {
            this.m_cmbAsc.addItem(null);
            this.m_cmbAsc.addItem("ASC");
            this.m_cmbAsc.addItem("DESC");
        }
        this.m_lstColExprs.getSelectionModel().addListSelectionListener(this.m_mdlColExprsListSelectionListener);
        this.m_cmbCol.addActionListener(this);
        this.m_cmbCol.setEditable(false);
        this.updateTableColumns(table);
        this.updateIndexData(null);
        this.updateColExpr(null);
        this.updateButtons();
        this.updateListContents(this.m_mdlColExprs);
        if (indexInfoVerifier != null) {
            boolean bl2 = this.m_mdlColExprs.size() > 0;
            this.m_fldName.setEnabled(bl && indexInfoVerifier.canRenameIndex(null));
            this.m_rdbBitmap.setEnabled(bl && indexInfoVerifier.canEditIndex(null));
            this.m_rdbNonUnique.setEnabled(bl && indexInfoVerifier.canEditIndex(null));
            this.m_rdbUnique.setEnabled(bl && indexInfoVerifier.canEditIndex(null));
            this.m_btnAddColExpr.setEnabled(bl && indexInfoVerifier.canEditIndex(null));
            this.m_btnDownColExpr.setEnabled(bl && bl2 && indexInfoVerifier.canEditIndex(null));
            this.m_btnRemoveColExpr.setEnabled(bl && bl2 && indexInfoVerifier.canEditIndex(null));
            this.m_btnUpColExpr.setEnabled(bl && bl2 && indexInfoVerifier.canEditIndex(null));
            this.m_cmbColExpr.setEditable(bl2 && indexInfoVerifier.canEditIndex(null));
            this.m_cmbColExpr.setEnabled(bl2 && indexInfoVerifier.canEditIndex(null));
            this.m_cmbAsc.setEnabled(bl && indexInfoVerifier.canEditIndex(null) && !this.m_rdbBitmap.isSelected());
            this.m_cmbCol.setEnabled(bl && indexInfoVerifier.canEditIndex(null));
        }
    }

    private void updateTableColumns(Table table) {
        this.m_cmbColExpr.removeItemListener(this);
        this.m_mdlCmbColExpr.removeAllElements();
        if (table != null) {
            Column[] columnArray = table.getColumns();
            int n = 0;
            while (n < columnArray.length) {
                Column column = columnArray[n];
                this.m_mdlCmbColExpr.addElement(column.getName());
                ++n;
            }
        }
        this.m_cmbColExpr.addItemListener(this);
    }

    public JTextField getNameField() {
        return this.m_fldName;
    }

    public void commit() throws TraversalException {
        if (this.m_index != null) {
            this.saveIndexAttributes();
            this.m_index.setName(this.m_prov.getInternalName(this.m_fldName.getText()));
            if (this.m_verifier != null) {
                this.m_verifier.verifyIndex(this.m_oldIndex, this.m_index);
            }
        }
    }

    private void saveIndexAttributes() {
        if (this.m_index != null) {
            OracleIndexProperties oracleIndexProperties = (OracleIndexProperties)this.m_index.getProperty("OracleIndexProperties");
            IndexObject[] indexObjectArray = null;
            if (this.m_rdbNormal.isSelected()) {
                this.m_index.setIndexType(1);
                if (this.m_rdbUnique.isSelected()) {
                    this.m_index.setIndexType(2);
                } else if (this.m_rdbBitmap.isSelected()) {
                    this.m_index.setIndexType(3);
                }
                indexObjectArray = new IndexObject[this.m_mdlColExprs.size()];
                int n = 0;
                while (n < this.m_mdlColExprs.size()) {
                    indexObjectArray[n] = (IndexObject)this.m_mdlColExprs.getElementAt(n);
                    ++n;
                }
            } else {
                this.m_index.setIndexType(4);
                if (oracleIndexProperties == null) {
                    oracleIndexProperties = new OracleIndexProperties();
                    this.m_index.setProperty("OracleIndexProperties", (Object)oracleIndexProperties);
                }
                oracleIndexProperties.setIndexDomainType(1);
                SimpleSQLFragment simpleSQLFragment = new SimpleSQLFragment((String)this.m_cmbCol.getSelectedItem());
                indexObjectArray = new IndexObject[]{new IndexObject((SQLFragment)simpleSQLFragment)};
            }
            this.m_index.setColumnExpressions(indexObjectArray);
        }
    }

    public void setIndex(Index index) {
        this.m_index = index;
        if (index != null) {
            this.populateName(index);
            this.populateIndexType(index);
        }
    }

    public void setTable(Table table) {
        if (table != this.m_table) {
            this.m_table = table;
            this.updateTableColumns(table);
        }
    }

    public Index getIndex() {
        return this.m_index;
    }

    public void updateIndexData(Index index) {
        this.saveIndexAttributes();
        this.m_index = index;
        if (index == null) {
            this.m_fldName.setText("");
            this.m_fldName.setEnabled(false);
            this.m_oldIndex = null;
        } else {
            if (this.m_isNewIndex) {
                this.m_oldIndex = null;
                this.m_isNewIndex = false;
            } else {
                this.m_oldIndex = (Index)index.copyTo(null);
            }
            this.populateName(index);
        }
        this.populateIndexType(this.m_index);
        this.populateUniqueness(this.m_index);
        this.populateColumnExpressions(this.m_index);
        this.populateColumns(this.m_index);
        this.m_fldName.requestFocusInWindow();
    }

    public void setNewIndex(boolean bl) {
        this.m_isNewIndex = bl;
    }

    private void switchToNormalIndex() {
        this.remove(this.m_pnlText);
        this.add((Component)this.m_pnlNormal, this.m_gbcNormalText);
        String string = (String)this.m_cmbCol.getSelectedItem();
        if (ModelUtil.hasLength((String)string)) {
            this.m_cmbColExpr.setSelectedItem(string);
        }
        this.validate();
        this.repaint();
    }

    private void switchToTextIndex() {
        ArrayList arrayList;
        this.remove(this.m_pnlNormal);
        this.add((Component)this.m_pnlText, this.m_gbcNormalText);
        String string = (String)this.m_cmbColExpr.getSelectedItem();
        if (ModelUtil.hasLength((String)string) && (arrayList = new ArrayList(ParserUtils.getColumnNames((String)string))).size() > 0) {
            this.m_cmbCol.setSelectedItem(arrayList.get(0));
        }
        this.validate();
        this.repaint();
    }

    private void switchIndexType() {
        if (this.m_rdbNormal.isSelected()) {
            this.switchToNormalIndex();
        } else if (this.m_rdbText.isSelected()) {
            this.switchToTextIndex();
        }
    }

    private void switchUnique() {
        if (this.m_rdbBitmap.isSelected()) {
            this.m_cmbAsc.setSelectedItem(null);
            this.m_cmbAsc.setEnabled(false);
        } else {
            this.m_cmbAsc.setEnabled(this.m_verifier.canEditIndex(null));
        }
    }

    private void updateColExpr(IndexObject indexObject) {
        if (indexObject == null) {
            this.m_cmbColExpr.setSelectedItem("");
            this.m_cmbColExpr.setEnabled(false);
            this.m_cmbAsc.setSelectedItem(null);
            this.m_cmbAsc.setEnabled(false);
        } else {
            this.m_cmbColExpr.setSelectedItem(indexObject.getExpression().getSQLText());
            this.m_cmbAsc.setSelectedItem(indexObject.getOrder());
            this.m_cmbColExpr.setEnabled(this.m_verifier == null || this.m_verifier.canEditIndex(null));
            this.m_cmbAsc.setEnabled((this.m_verifier == null || this.m_verifier.canEditIndex(null)) && !this.m_rdbBitmap.isSelected());
        }
    }

    private void updateSelColExpr(Object object) {
        if (object != null) {
            this.m_lstColExprs.setSelectedValue(object, true);
            this.updateColExpr((IndexObject)object);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        String string;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this.m_lstColExprs.getSelectedIndex();
        IndexObject indexObject = n != -1 ? (IndexObject)this.m_mdlColExprs.get(n) : null;
        SQLFragment sQLFragment = indexObject == null ? null : indexObject.getExpression();
        String string2 = string = sQLFragment == null ? null : sQLFragment.getSQLText();
        if (string != null) {
            bl = true;
            IndexObject indexObject2 = n > 0 ? (IndexObject)this.m_mdlColExprs.get(n - 1) : null;
            IndexObject indexObject3 = n < this.m_mdlColExprs.getSize() - 1 ? (IndexObject)this.m_mdlColExprs.get(n + 1) : null;
            bl2 = indexObject2 != null;
            bl3 = indexObject3 != null;
        }
        this.m_btnRemoveColExpr.setEnabled(this.m_index != null && this.m_verifier != null && bl && this.m_verifier.canEditIndex(this.m_index));
        this.m_btnAddColExpr.setEnabled(this.m_index != null && this.m_verifier != null && this.m_verifier.canEditIndex(this.m_index));
        this.m_btnUpColExpr.setEnabled(this.m_index != null && this.m_verifier != null && bl2 && this.m_verifier.canEditIndex(this.m_index));
        this.m_btnDownColExpr.setEnabled(this.m_index != null && this.m_verifier != null && bl3 && this.m_verifier.canEditIndex(this.m_index));
    }

    public void populateName(Index index) {
        if (index != null) {
            this.m_fldName.setText(this.m_prov.getExternalName(index.getName()));
        }
        this.m_fldName.setEnabled(this.m_isNewIndex || this.m_verifier == null || this.m_verifier.canRenameIndex(index));
    }

    public void populateIndexType(Index index) {
        if (index == null) {
            this.m_rdbNormal.setSelected(true);
            this.m_rdbNormal.setEnabled(false);
            this.m_rdbText.setEnabled(false);
        } else {
            this.m_rdbNormal.setSelected(1 == index.getIndexType());
            this.m_rdbText.setSelected(4 == index.getIndexType());
            this.m_rdbNormal.setEnabled(true);
            this.m_rdbText.setEnabled(true);
        }
        this.switchIndexType();
    }

    public void populateUniqueness(Index index) {
        if (index == null) {
            this.m_rdbNonUnique.setSelected(true);
            this.m_rdbNonUnique.setEnabled(false);
            this.m_rdbUnique.setEnabled(false);
            this.m_rdbBitmap.setEnabled(false);
        } else {
            this.m_rdbNonUnique.setSelected(1 == index.getIndexType());
            this.m_rdbUnique.setSelected(2 == index.getIndexType());
            this.m_rdbBitmap.setSelected(3 == index.getIndexType());
            this.m_rdbNonUnique.setEnabled(true);
            this.m_rdbUnique.setEnabled(true);
            this.m_rdbBitmap.setEnabled(true);
        }
    }

    public void populateColumns(Index index) {
        this.m_cmbCol.removeAllItems();
        if (index != null && index.getTable() != null) {
            Column[] columnArray = index.getTable().getColumns();
            int n = 0;
            while (n < columnArray.length) {
                this.m_cmbCol.addItem(columnArray[n].getName());
                ++n;
            }
            IndexObject[] indexObjectArray = index.getColumnExpressions();
            if (indexObjectArray != null && indexObjectArray.length > 0) {
                IndexObject indexObject = indexObjectArray[0];
                String string = indexObject.getExpression().getSQLText();
                this.m_cmbCol.setSelectedItem(string);
            }
        }
        this.m_cmbCol.setEnabled(this.m_index != null);
    }

    public void populateColumnExpressions(Index index) {
        this.m_cmbColExpr.setSelectedItem(null);
        this.m_cmbAsc.setSelectedIndex(0);
        this.m_mdlColExprs.removeAllElements();
        if (index != null) {
            IndexObject[] indexObjectArray = index.getColumnExpressions();
            int n = 0;
            while (n < indexObjectArray.length) {
                this.m_mdlColExprs.addElement(indexObjectArray[n]);
                ++n;
            }
            if (indexObjectArray != null && indexObjectArray.length > 0) {
                this.m_lstColExprs.setSelectedIndex(0);
                this.updateColExpr(indexObjectArray[0]);
            }
        }
    }

    private void updateListContents(Object object) {
        boolean bl = false;
        if (this.m_mdlColExprs == object) {
            bl = this.m_mdlColExprs.getSize() > 0;
            this.m_lstColExprs.setFocusable(bl);
            this.m_cmbColExpr.setEditable(bl && (this.m_verifier == null || this.m_verifier.canEditIndex(null)));
            this.m_cmbColExpr.setEnabled(bl && (this.m_verifier == null || this.m_verifier.canEditIndex(null)));
        }
        if (this.m_callbacks != null) {
            Boolean bl2 = this.m_index == null || bl;
            this.m_callbacks.wizardEnableButtons(Boolean.TRUE, bl2, bl2);
        }
    }

    private void swap(int n, int n2) {
        Object e = this.m_mdlColExprs.getElementAt(n);
        Object e2 = this.m_mdlColExprs.getElementAt(n2);
        this.m_mdlColExprs.setElementAt(e, n2);
        this.m_mdlColExprs.setElementAt(e2, n);
    }

    private void updateIndexName() {
        this.logActionStart(WH_EDIT_COLUMN_EXPRESSION, true);
        String string = (String)this.m_cmbColExpr.getSelectedItem();
        String string2 = (String)this.m_cmbAsc.getSelectedItem();
        int n = this.m_lstColExprs.getSelectedIndex();
        if (n >= 0) {
            SQLFragment sQLFragment = OracleIndexBuilder.createExpression((String)string, (Relation)this.m_table);
            IndexObject indexObject = new IndexObject(sQLFragment, string2);
            this.m_mdlColExprs.setElementAt(indexObject, n);
        }
        this.m_lstColExprs.repaint();
        this.logActionEnd(WH_EDIT_COLUMN_EXPRESSION);
    }

    public void logActionStart(String string, boolean bl) {
        if (bl || this.m_whatsHappening.size() != 0) {
            // empty if block
        }
        this.m_whatsHappening.add(0, string);
    }

    public void logActionEnd(String string) {
        if (this.m_whatsHappening.size() == 0) {
            // empty if block
        }
        this.m_whatsHappening.remove(0);
    }

    public int logSize() {
        return this.m_whatsHappening.size();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_rdbNonUnique || object == this.m_rdbUnique || object == this.m_rdbBitmap) {
            this.switchUnique();
        } else if (object == this.m_rdbNormal || object == this.m_rdbText) {
            this.switchIndexType();
        } else if (object != this.m_cmbCol) {
            if (object == this.m_cmbAsc) {
                this.logActionStart(WH_SET_ASC_DESC, true);
                if (this.logSize() == 1) {
                    this.m_cmbColExpr.requestFocusInWindow();
                }
                this.updateIndexName();
                this.logActionEnd(WH_SET_ASC_DESC);
            } else if (object == this.m_btnAddColExpr) {
                this.logActionStart(WH_ADD_A_COLUMN_EXPRESSION, false);
                this.m_lstColExprs.clearSelection();
                if (this.m_lstColExprs.getSelectedValue() == null) {
                    int n = this.m_mdlColExprs.size();
                    String string = this.m_table.getColumns()[0].getName();
                    Constraint[] constraintArray = this.m_table.getConstraints();
                    int n2 = 0;
                    while (n2 < constraintArray.length) {
                        if ("PKConstraint".equals(constraintArray[n2].getConstraintType())) {
                            string = ((PKConstraint)constraintArray[n2]).getColumns()[0].getName();
                            break;
                        }
                        if ("UniqueConstraint".equals(constraintArray[n2].getConstraintType())) {
                            string = ((UniqueConstraint)constraintArray[n2]).getColumns()[0].getName();
                        }
                        ++n2;
                    }
                    String string2 = string;
                    SQLFragment sQLFragment = OracleIndexBuilder.createExpression((String)string2, (Relation)this.m_table);
                    IndexObject indexObject = new IndexObject(sQLFragment);
                    this.m_mdlColExprs.addElement(indexObject);
                    this.m_lstColExprs.setSelectedIndex(this.m_mdlColExprs.size() - 1);
                    this.m_cmbColExpr.requestFocusInWindow();
                }
                this.logActionEnd(WH_ADD_A_COLUMN_EXPRESSION);
            } else if (object == this.m_btnRemoveColExpr) {
                this.logActionStart(WH_REMOVE_A_COLUMN_EXPRESSION, false);
                int n = this.m_lstColExprs.getSelectedIndex();
                if (n != -1) {
                    int n3 = n == this.m_mdlColExprs.size() - 1 ? n - 1 : n + 1;
                    this.m_lstColExprs.setSelectedIndex(n3);
                    this.m_mdlColExprs.removeElementAt(n);
                    if (n3 == -1) {
                        this.updateSelColExpr(null);
                        this.updateColExpr(null);
                    } else {
                        this.updateButtons();
                    }
                }
                this.logActionEnd(WH_REMOVE_A_COLUMN_EXPRESSION);
            } else if (object == this.m_btnUpColExpr) {
                this.logActionStart(WH_MOVE_A_COLUMN_EXPRESSION_UP, false);
                int n = this.m_lstColExprs.getSelectedIndex();
                if (n > 0) {
                    this.swap(n--, n);
                    this.m_lstColExprs.setSelectedIndex(n);
                }
                this.logActionEnd(WH_MOVE_A_COLUMN_EXPRESSION_UP);
            } else if (object == this.m_btnDownColExpr) {
                this.logActionStart(WH_MOVE_A_COLUMN_EXPRESSION_DOWN, false);
                int n = this.m_lstColExprs.getSelectedIndex();
                if (n < this.m_mdlColExprs.getSize() - 1) {
                    this.swap(n++, n);
                    this.m_lstColExprs.setSelectedIndex(n);
                }
                this.logActionEnd(WH_MOVE_A_COLUMN_EXPRESSION_DOWN);
            }
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateListContents(listDataEvent.getSource());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateIndexName();
    }

    static String ra$WH_CHANGE_COLEXPR_SELECTION() {
        return WH_CHANGE_COLEXPR_SELECTION;
    }

    static JList ra$m_lstColExprs(IndexEditorPanel indexEditorPanel) {
        return indexEditorPanel.m_lstColExprs;
    }

    static void mav$updateSelColExpr(IndexEditorPanel indexEditorPanel, Object object) {
        indexEditorPanel.updateSelColExpr(object);
    }

    public final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            IndexEditorPanel.this.logActionStart(IndexEditorPanel.ra$WH_CHANGE_COLEXPR_SELECTION(), true);
            IndexEditorPanel.mav$updateSelColExpr(IndexEditorPanel.this, IndexEditorPanel.ra$m_lstColExprs(IndexEditorPanel.this).getSelectedValue());
            IndexEditorPanel.this.logActionEnd(IndexEditorPanel.ra$WH_CHANGE_COLEXPR_SELECTION());
        }
    }
}

