/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ui.DBObjectOnePagePanel;
import oracle.jdeveloper.cm.dt.ui.DBObjectRenderer;
import oracle.jdeveloper.cm.dt.ui.SchemaPicker;
import oracle.jdeveloper.cm.dt.ui.TablePicker;
import oracle.jdeveloper.cm.dt.ui.table.IndexEditorPanel;
import oracle.jdeveloper.cm.dt.verifier.table.IndexInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class IndexInfoPanel
extends DBObjectOnePagePanel
implements DocumentListener,
ActionListener {
    private DBObjectProvider m_prov;
    private Schema[] m_existingSchemas;
    private Schema m_schema;
    private Table m_table;
    private Index m_index;
    private JTextField m_fldName;
    private boolean m_userHasEdittedName;
    private BorderLayout m_layMain;
    private JMultiLineLabel m_lblTop;
    private JPanel m_pnlContext;
    private GridBagLayout m_layCenter;
    private JLabel m_lblOwner;
    private JLabel m_lblTable;
    private SchemaPicker m_cmbOwner;
    private TablePicker m_cmbTable;
    private DBObjectRenderer m_renderer;
    IndexEditorPanel m_pnlDetails;
    private Map _schemaMap;

    void $init$() {
        this.m_layMain = new BorderLayout();
        this.m_lblTop = new JMultiLineLabel();
        this.m_pnlContext = new JPanel();
        this.m_layCenter = new GridBagLayout();
        this.m_lblOwner = new JLabel();
        this.m_lblTable = new JLabel();
        this.m_cmbOwner = new SchemaPicker();
        this.m_cmbTable = new TablePicker();
        this.m_renderer = new DBObjectRenderer();
        this.m_pnlDetails = new IndexEditorPanel();
        this._schemaMap = new HashMap();
    }

    public IndexInfoPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getHeaderTitle() {
        return CmWizardsArb.getString(1);
    }

    public Image getHeaderImage() {
        return ConnectionArb.getImage(446);
    }

    public String getHeaderDescription() {
        return CmWizardsArb.getString(386);
    }

    private void jbInit() throws Exception {
        this.m_fldName = this.m_pnlDetails.getNameField();
        this.m_fldName.getDocument().addDocumentListener(this);
        this.setLayout(this.m_layMain);
        this.setTopLabel(CmWizardsArb.getString(385));
        this.m_lblTop.setPreferredAspectRatio(0.0f);
        this.m_lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add((Component)this.m_lblTop, "North");
        this.m_pnlContext.setLayout(this.m_layCenter);
        this.setOwnerLabel(CmWizardsArb.getString(17));
        this.m_cmbOwner.setRenderer(this.m_renderer);
        this.setTableLabel(CmWizardsArb.getString(387));
        this.m_cmbTable.setRenderer(this.m_renderer);
        this.m_cmbTable.addPropertyChangeListener("model", new 1());
        this.m_pnlContext.add((Component)this.m_lblOwner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        this.m_pnlContext.add((Component)((Object)this.m_cmbOwner), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlContext.add((Component)this.m_lblTable, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.m_pnlContext.add((Component)((Object)this.m_cmbTable), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.m_pnlContext, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.m_pnlDetails, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(jPanel, "Center");
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_prov = (DBObjectProvider)traversableContext.find("DBObjectProvider");
        this.m_index = (Index)traversableContext.find("NewObject");
        IndexInfoVerifier indexInfoVerifier = (IndexInfoVerifier)traversableContext.find("IndexVerifier");
        this.m_existingSchemas = (Schema[])traversableContext.find("SchemaList");
        this.m_schema = (Schema)traversableContext.find("Schema");
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        this.m_pnlDetails.init(this.m_prov, this.m_index.getTable(), indexInfoVerifier, wizardCallbacks, true);
        this.init(this.m_index, indexInfoVerifier);
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.commit((Index)traversableContext.find("OriginalObject"), (Index)traversableContext.find("NewObject"), (Schema[])traversableContext.find("SchemaList"), traversableContext.getDirection() != 2);
    }

    protected void init(Index index, IndexInfoVerifier indexInfoVerifier) {
        this.m_userHasEdittedName = ModelUtil.hasLength((String)index.getName());
        super.init(this.m_prov, indexInfoVerifier);
        this.m_cmbOwner.setProvider(this.m_prov);
        this.m_cmbTable.setProvider(this.m_prov);
        this.m_renderer.setProvider(this.m_prov);
        this.m_pnlDetails.setNewIndex(ModelUtil.hasLength((String)this.m_index.getName()) ^ true);
        this.m_pnlDetails.setIndex(this.m_index);
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel();
        int n = 0;
        while (n < this.m_existingSchemas.length) {
            nonNullableComboBoxModel.addElement(this.m_existingSchemas[n]);
            ++n;
        }
        Table table = index.getTable();
        Schema schema = index.getSchema();
        if (schema == null) {
            schema = this.m_schema;
        }
        if (nonNullableComboBoxModel.getIndexOf(schema) < 0) {
            nonNullableComboBoxModel.addElement(schema);
        }
        nonNullableComboBoxModel.setSelectedItem(schema);
        this.m_cmbOwner.setModel((ComboBoxModel)nonNullableComboBoxModel);
        this.m_cmbOwner.addActionListener(this);
        this.m_cmbTable.addActionListener(this);
        this.populateTableCombo(table, schema);
        this.m_lblOwner.setEnabled(indexInfoVerifier == null || indexInfoVerifier.canAddIndexes());
        this.m_cmbOwner.setEnabled(indexInfoVerifier == null || indexInfoVerifier.canAddIndexes());
        this.m_cmbOwner.setEditable(false);
        String string = this.getExternalName(index.getName());
        this.m_lblTable.setEnabled(indexInfoVerifier == null || indexInfoVerifier.canAddIndexes());
        this.m_cmbTable.setEnabled(indexInfoVerifier == null || indexInfoVerifier.canAddIndexes());
        this.m_cmbTable.setEditable(false);
        this.m_pnlDetails.populateName(index);
        this.m_pnlDetails.populateIndexType(index);
        this.m_pnlDetails.populateUniqueness(index);
        this.m_pnlDetails.populateColumnExpressions(index);
        this.m_pnlDetails.populateColumns(index);
        this.m_fldName.requestFocusInWindow();
    }

    private void populateTableCombo(Table table, Schema schema) {
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel();
        this.m_cmbTable.setSchema(schema);
        String string = null;
        if (table != null) {
            String string2 = table.getName();
            nonNullableComboBoxModel.addElement(string2);
            string = string2;
        } else {
            String[] stringArray = new String[]{};
            try {
                stringArray = this.m_prov.listObjects("TABLE", schema);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            int n = 0;
            while (n < stringArray.length) {
                nonNullableComboBoxModel.addElement(stringArray[n]);
                ++n;
            }
            if (ModelUtil.hasLength((String)stringArray[0])) {
                string = stringArray[0];
            }
        }
        this.m_cmbTable.setModel((ComboBoxModel)nonNullableComboBoxModel);
        if (string != null) {
            nonNullableComboBoxModel.setSelectedItem(string);
        }
        try {
            this.m_table = this.m_cmbTable.getTable();
            this.m_pnlDetails.setTable(this.m_table);
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
    }

    protected void commit(Index index, Index index2, Schema[] schemaArray, boolean bl) throws TraversalException {
        IndexInfoVerifier indexInfoVerifier = (IndexInfoVerifier)this.getVerifier();
        DBObjectProvider dBObjectProvider = this.getProvider();
        Table table = this.m_cmbTable.getTable();
        Table table2 = (Table)table.copyTo(null);
        table2.addIndex(index2);
        index2.setTable(table2);
        this.m_pnlDetails.commit();
        if (!bl || indexInfoVerifier != null) {
            // empty if block
        }
    }

    public void setOwnerLabel(String string) {
        ResourceUtils.resLabel((JLabel)this.m_lblOwner, (Component)((Object)this.m_cmbOwner), (String)string);
    }

    public void setTableLabel(String string) {
        ResourceUtils.resLabel((JLabel)this.m_lblTable, (Component)((Object)this.m_cmbTable), (String)string);
    }

    public void setTopLabel(String string) {
        this.m_lblTop.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_cmbOwner) {
            Schema schema = null;
            try {
                schema = this.m_cmbOwner.getSchema(this.m_existingSchemas);
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
            if (schema != this.m_schema) {
                this.m_schema = schema;
                this.m_cmbTable.setSchema(this.m_schema);
                this.populateTableCombo(null, schema);
            }
        } else if (object == this.m_cmbTable) {
            this.updateTableName();
        }
    }

    private void updateTableName() {
        Table table = null;
        try {
            table = this.m_cmbTable.getTable();
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
        this.createDefIndexName(table);
    }

    private void createDefIndexName(Table table) {
        if (table != null && table != this.m_table) {
            this.m_table = table;
            String string = this.m_fldName.getText();
            if (!this.m_userHasEdittedName) {
                String string2 = table.getName() + "_INDEX";
                string = this.m_prov.getUniqueName("INDEX", (DBObject)table, string2);
                this.m_index.setName(string);
                this.m_pnlDetails.populateName(this.m_index);
            }
            this.m_index.setTable(table);
            table.addIndex(this.m_index);
            this.m_pnlDetails.setTable(table);
            this.m_pnlDetails.populateColumnExpressions(this.m_index);
            this.m_pnlDetails.populateColumns(this.m_index);
            this.m_pnlDetails.populateIndexType(this.m_index);
            this.m_pnlDetails.updateButtons();
            this.m_fldName.requestFocusInWindow();
        }
    }

    private void updateIndexName() {
        if (ModelUtil.hasLength((String)this.m_fldName.getText())) {
            this.m_userHasEdittedName |= ModelUtil.areEqual((Object)this.m_index.getName(), (Object)this.m_fldName.getText()) ^ true;
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateIndexName();
    }

    static void mav$updateTableName(IndexInfoPanel indexInfoPanel) {
        indexInfoPanel.updateTableName();
    }

    public final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            IndexInfoPanel.mav$updateTableName(IndexInfoPanel.this);
        }
    }
}

