/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.table;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.table.BaseConstraintPanel;
import oracle.jdeveloper.cm.dt.ui.table.ConstraintColumnSelectionPanel;
import oracle.jdeveloper.cm.dt.verifier.table.ConstraintsInfoVerifier;

public class PKConstraintPanel
extends BaseInfoPanel {
    protected GridBagLayout layMain;
    protected ConstraintColumnSelectionPanel pnlColumns;
    protected Table _tbl;
    private PKConstraint _pk;
    private PKConstraint _onEntryPk;
    private Namespace _cNamespace;

    void $init$() {
        this.layMain = new GridBagLayout();
    }

    public PKConstraintPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected ConstraintColumnSelectionPanel createColumnPanel() {
        return new ConstraintColumnSelectionPanel();
    }

    private void jbInit() throws Exception {
        this.pnlColumns = this.createColumnPanel();
        this.setLayout(this.layMain);
        this.add(this.pnlColumns, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this._cNamespace = new Namespace((Namespace)traversableContext);
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        if (wizardCallbacks != null) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
        this.init((DBObjectProvider)traversableContext.find("DBObjectProvider"), (ConstraintsInfoVerifier)traversableContext.find("ConstraintsInfoVerifier"));
        this._tbl = (Table)traversableContext.find("NewObject");
        this._pk = PKConstraintPanel._findPK((Relation)this._tbl);
        if (this._pk == null) {
            this._pk = new PKConstraint();
            this._pk.setName(BaseConstraintPanel.findUniqueName(this._tbl, (Constraint)this._pk, new Constraint[0]));
            this._pk.setEnabled(true);
            this._pk.setID(TemporaryObjectID.createID((DBObject)this._pk));
            this._onEntryPk = null;
        } else {
            this._onEntryPk = (PKConstraint)this._pk.copyTo((Object)this._onEntryPk);
        }
        ConstraintsInfoVerifier constraintsInfoVerifier = (ConstraintsInfoVerifier)this.getVerifier();
        boolean bl = this._pk != null && (constraintsInfoVerifier == null || constraintsInfoVerifier.canModifyConstraint((Constraint)this._pk));
        this._cNamespace.put("Con", (Object)this._pk);
        this._cNamespace.put("Modifiable", (Object)bl);
        this.pnlColumns.init(this._cNamespace);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl = traversableContext.getDirection() == 2;
        TraversalException traversalException = null;
        try {
            this.pnlColumns.commit();
        }
        catch (TraversalException traversalException2) {
            traversalException = traversalException2;
        }
        PKConstraint pKConstraint = PKConstraintPanel._findPK((Relation)this._tbl);
        Column[] columnArray = this._pk.getColumns();
        if (columnArray.length == 0) {
            if (pKConstraint != null) {
                this._tbl.removeConstraint((Constraint)pKConstraint);
            }
        } else {
            ConstraintsInfoVerifier constraintsInfoVerifier;
            if (traversalException != null) {
                throw traversalException;
            }
            if (ModelUtil.areDifferent((Object)this._onEntryPk, (Object)this._pk) && (constraintsInfoVerifier = (ConstraintsInfoVerifier)this.getVerifier()) != null) {
                if (this._onEntryPk == null) {
                    Table table = (Table)this._tbl.copyTo(null);
                    table.addConstraint((Constraint)this._pk);
                }
                constraintsInfoVerifier.verifyConstraint((Constraint)this._onEntryPk, (Constraint)this._pk);
            }
            if (pKConstraint != null) {
                if (pKConstraint != this._pk) {
                    this._pk.copyTo((Object)pKConstraint);
                }
                DBObjectID dBObjectID = pKConstraint.getID();
                DBObject dBObject = null;
                try {
                    dBObject = dBObjectID.resolveID();
                }
                catch (DBException dBException) {
                    // empty catch block
                }
                if (dBObject != pKConstraint) {
                    pKConstraint.setID(TemporaryObjectID.createID((DBObject)pKConstraint, (DBObject)this._pk));
                }
            } else {
                this._tbl.addConstraint((Constraint)this._pk);
            }
        }
    }

    private static PKConstraint _findPK(Relation relation) {
        Constraint[] constraintArray = relation.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            if ("PKConstraint".equals(constraintArray[n].getConstraintType())) {
                return (PKConstraint)constraintArray[n];
            }
            ++n;
        }
        return null;
    }
}

