/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.ui.table;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.jdeveloper.cm.dt.ui.BaseInfoPanel;
import oracle.jdeveloper.cm.dt.ui.table.HashPartitionQuantityPanel;
import oracle.jdeveloper.cm.dt.ui.table.PartitionListPanel;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class PartitionDefinitionPanel
extends BaseInfoPanel
implements ActionListener {
    private boolean m_subpartTemplates;
    private boolean m_editing;
    private boolean m_alive;
    private DBObjectProvider m_pro;
    private Table m_table;
    private OracleTablePartitions m_parts;
    private String[] m_tablespaces;
    private JCheckBox m_hashCheckBox;
    private HashPartitionQuantityPanel m_hashPanel;
    private PartitionListPanel m_listPanel;

    public PartitionDefinitionPanel() {
        this(false);
    }

    public PartitionDefinitionPanel(boolean bl) {
        this.m_subpartTemplates = bl;
    }

    private void layoutComponents() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        if (this.m_listPanel == null) {
            this.m_listPanel = new PartitionListPanel();
        }
        this.add(this.m_listPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void layoutHashComponents(boolean bl) {
        OracleTablePartitions.ObjectType objectType = this.m_parts.getObjectType();
        this.removeAll();
        this.setLayout(new GridBagLayout());
        if (this.m_hashCheckBox == null) {
            this.m_hashCheckBox = new JCheckBox();
        } else {
            this.m_hashCheckBox.removeActionListener(this);
        }
        this.m_hashCheckBox.setSelected(bl);
        this.m_hashCheckBox.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_hashCheckBox, (String)(objectType == OracleTablePartitions.ObjectType.PARTITION ? CmWizardsArb.getString(529) : (objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE ? CmWizardsArb.getString(530) : CmWizardsArb.getString(531))));
        JPanel jPanel = null;
        if (bl) {
            if (this.m_listPanel == null) {
                this.m_listPanel = new PartitionListPanel();
            }
            jPanel = this.m_listPanel;
        } else {
            if (this.m_hashPanel == null) {
                this.m_hashPanel = new HashPartitionQuantityPanel();
            }
            jPanel = this.m_hashPanel;
        }
        int n = 0;
        this.add(this.m_hashCheckBox, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(jPanel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        DBObjectProvider dBObjectProvider = (DBObjectProvider)traversableContext.get("DBObjectProvider");
        Table table = (Table)traversableContext.get("NewObject");
        Table table2 = (Table)traversableContext.get("OriginalObject");
        String[] stringArray = (String[])traversableContext.find("Tablespaces");
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        if (this.m_subpartTemplates) {
            OracleTablePartitions oracleTablePartitions2 = oracleTablePartitions = oracleTablePartitions == null ? null : oracleTablePartitions.getSubpartitionModel();
        }
        if (oracleTablePartitions == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            this.init(dBObjectProvider, table, oracleTablePartitions, stringArray, table2 != null);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Table table = (Table)traversableContext.get("NewObject");
        OracleTablePartitions oracleTablePartitions = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
        OracleTablePartitions oracleTablePartitions2 = null;
        if (this.m_subpartTemplates) {
            oracleTablePartitions2 = oracleTablePartitions;
            OracleTablePartitions oracleTablePartitions3 = oracleTablePartitions = oracleTablePartitions == null ? null : oracleTablePartitions.getSubpartitionModel();
        }
        if (oracleTablePartitions != null) {
            try {
                this.commit(table, oracleTablePartitions, oracleTablePartitions2, traversableContext.getDirection() != 2);
            }
            catch (ValidationException validationException) {
                throw new TraversalException(validationException.getMessage(), validationException.getTitle());
            }
        }
    }

    protected void init(DBObjectProvider dBObjectProvider, Table table, OracleTablePartitions oracleTablePartitions, String[] stringArray, boolean bl) {
        this.m_alive = false;
        this.m_pro = dBObjectProvider;
        this.m_table = table;
        this.m_parts = oracleTablePartitions;
        this.m_tablespaces = stringArray;
        this.m_editing = bl;
        OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
        TablePartition[] tablePartitionArray = oracleTablePartitions.getPartitions();
        if (partitionType == OracleTablePartitions.PartitionType.HASH) {
            if (tablePartitionArray != null && tablePartitionArray.length > 0) {
                this.layoutHashComponents(true);
                this.m_listPanel.init(this.m_pro, oracleTablePartitions, this.m_table, this.m_tablespaces, this.m_editing);
                if (this.m_editing) {
                    this.m_hashCheckBox.setEnabled(false);
                }
                this.m_alive = true;
            } else if (!this.m_editing || oracleTablePartitions.getHashQuantity() != null) {
                this.layoutHashComponents(false);
                this.m_hashPanel.init(table, oracleTablePartitions, stringArray);
                this.m_alive = true;
            }
        } else if (partitionType == OracleTablePartitions.PartitionType.LIST || partitionType == OracleTablePartitions.PartitionType.RANGE) {
            this.layoutComponents();
            this.m_listPanel.init(this.m_pro, oracleTablePartitions, this.m_table, this.m_tablespaces, this.m_editing);
            this.m_alive = true;
        }
    }

    protected void commit(Table table, OracleTablePartitions oracleTablePartitions, OracleTablePartitions oracleTablePartitions2, boolean bl) throws ValidationException {
        if (this.m_alive) {
            OracleTablePartitions.PartitionType partitionType = oracleTablePartitions.getPartitionType();
            if (partitionType == OracleTablePartitions.PartitionType.HASH && !this.m_hashCheckBox.isSelected()) {
                oracleTablePartitions.setPartitions(null);
                this.m_hashPanel.commit(table, oracleTablePartitions);
            } else {
                oracleTablePartitions.setPartitions(this.m_listPanel.getPartitions());
                oracleTablePartitions.setHashQuantity(null);
                oracleTablePartitions.setHashQuantityTablespaces(null);
            }
            if (bl) {
                if (this.m_subpartTemplates) {
                    oracleTablePartitions2.validateSubpartitionModel(table);
                } else {
                    oracleTablePartitions.validatePartitions(table);
                }
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.m_hashCheckBox != null) {
            this.m_hashCheckBox.setEnabled(bl);
        }
        if (this.m_hashPanel != null) {
            this.m_hashPanel.setEnabled(bl);
        }
        if (this.m_listPanel != null) {
            this.m_listPanel.setEnabled(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != null && object == this.m_hashCheckBox) {
            if (this.m_hashCheckBox.isSelected()) {
                this.layoutHashComponents(true);
                this.m_listPanel.init(this.m_pro, this.m_parts, this.m_table, this.m_tablespaces, this.m_editing);
            } else {
                this.layoutHashComponents(false);
                this.m_hashPanel.init(this.m_table, this.m_parts, this.m_tablespaces);
            }
            this.repaint();
        }
    }
}

