/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.verifier.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.jdeveloper.cm.dt.verifier.relation.AbstractRelationVerifier;
import oracle.jdeveloper.cm.dt.verifier.table.ColumnInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public abstract class AbstractColumnInfoVerifier
extends AbstractRelationVerifier
implements ColumnInfoVerifier {
    private static HashSet noDefValDataTypes = new HashSet<String>(Arrays.asList("BLOB", "BFILE", "LONG RAW", "CLOB", "NCLOB"));
    private static final String[] ORA_TYPES = new String[]{"VARCHAR2", "NUMBER", "DATE", "CLOB", "BLOB"};

    protected AbstractColumnInfoVerifier() {
    }

    public boolean canAddColumns() {
        return this.isEditable() && this.getModifiedRelation().getColumns().length < 1000;
    }

    public boolean canAddColumn(Column column) {
        return this.isEditable();
    }

    public boolean canRemoveColumns() {
        return this.isEditable();
    }

    public boolean canRemoveColumn(Column column) {
        return this.isEditable();
    }

    public boolean canReorderColumns() {
        return this.isEditable();
    }

    public boolean canMoveColumnUp(Column column) {
        return this.isEditable();
    }

    public boolean canMoveColumnDown(Column column) {
        return this.isEditable();
    }

    public boolean canRenameColumn(Column column) {
        return this.isEditable();
    }

    public boolean canChangeColumnType(Column column) {
        return this.isEditable();
    }

    public boolean canChangeColumnSize(Column column) {
        return this.isEditable();
    }

    public boolean canChangeColumnNotNullState(Column column) {
        return this.isEditable();
    }

    public boolean canChangeColumnDefaultValue(Column column) {
        return this.isEditable();
    }

    public boolean canChangeColumnComment(Column column) {
        return this.isEditable();
    }

    public boolean canTakeDefaultValue(DataType dataType) {
        boolean bl;
        boolean bl2 = bl = dataType == null;
        if (!(bl || dataType instanceof ComplexType || noDefValDataTypes.contains(dataType.getName()))) {
            bl = true;
        }
        return bl;
    }

    public void verifyColumn(Column column, Column column2) throws TraversalException {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider != null) {
            try {
                dBObjectProvider.validateObject((DBObject)column, (DBObject)column2);
            }
            catch (ValidationException validationException) {
                this.processValidationException(validationException);
            }
        }
    }

    protected String getErrorTitle() {
        return CmWizardsArb.getString(63);
    }

    protected String getInvalidNameMessage(String string) {
        return CmWizardsArb.format(ModelUtil.hasLength((String)string) ? 61 : 62, this.getModifiedRelation().getName(), string);
    }

    protected String getChildType() {
        return "COLUMN";
    }

    public DataType[] getPreferredTypes() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider instanceof BaseOracleDatabase) {
            return this.getOraclePreferredTypes();
        }
        return null;
    }

    protected final DataType[] getOraclePreferredTypes() {
        ArrayList<DataType> arrayList = new ArrayList<DataType>();
        DataTypeRegistry dataTypeRegistry = DataTypeRegistry.getInstance();
        int n = 0;
        while (n < ORA_TYPES.length) {
            DataType dataType = dataTypeRegistry.findDataType(ORA_TYPES[n], Oracle10gR2.class);
            if (dataType != null) {
                arrayList.add(dataType);
            }
            ++n;
        }
        return arrayList.toArray(new DataType[arrayList.size()]);
    }

    public DataType getDefaultType() {
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (dBObjectProvider instanceof BaseOracleDatabase) {
            return dBObjectProvider.getDataType("VARCHAR2");
        }
        if (dBObjectProvider != null) {
            return dBObjectProvider.getDataType("CHAR");
        }
        return null;
    }
}

