/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm.dt.verifier.table;

import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.jdeveloper.cm.dt.verifier.table.AbstractTableVerifier;
import oracle.jdeveloper.cm.dt.verifier.table.IndexInfoVerifier;
import oracle.jdevimpl.cm.dt.wizards.CmWizardsArb;

public class AbstractIndexInfoVerifier
extends AbstractTableVerifier
implements IndexInfoVerifier {
    protected String getErrorTitle() {
        return CmWizardsArb.format(411, this.getModifiedRelationName());
    }

    protected String getInvalidNameMessage(String string) {
        return CmWizardsArb.format(ModelUtil.hasLength((String)string) ? 412 : 413, string);
    }

    protected String getChildType() {
        return "INDEX";
    }

    public void verifyIndex(Index index, Index index2) throws TraversalException {
        try {
            this.getProvider().validateObject((DBObject)index, (DBObject)index2);
        }
        catch (ValidationException validationException) {
            this.processValidationException(validationException);
        }
    }

    public boolean canRenameIndex(Index index) {
        return this.getOriginalIndex(index) == null;
    }

    public boolean canRemoveIndexes() {
        return this.isEditable();
    }

    public boolean canRemoveIndex(Index index) {
        return this.isEditable();
    }

    public boolean canReorderIndexes() {
        return this.getOriginalRelation() == null;
    }

    public boolean canMoveIndexUp(Index index) {
        return this.getOriginalRelation() == null;
    }

    public boolean canMoveIndexDown(Index index) {
        return this.getOriginalRelation() == null;
    }

    public boolean canAddIndexes() {
        return this.getOriginalRelation() == null;
    }

    public boolean canAddIndex(Index index) {
        return this.getOriginalIndex(index) == null;
    }

    public boolean canEditIndex(Index index) {
        return this.getOriginalRelation() == null;
    }

    protected Index getOriginalIndex(Index index) {
        Index index2 = null;
        Table table = (Table)this.getOriginalRelation();
        if (index != null && table != null) {
            index2 = table.getIndex(index.getName());
        }
        return index2;
    }

    protected boolean hasNewIndex() {
        boolean bl = true;
        if (this.getOriginalRelation() != null) {
            bl = false;
            Index[] indexArray = ((Table)this.getModifiedRelation()).getIndexes();
            int n = 0;
            while (n < indexArray.length) {
                if (this.getOriginalIndex(indexArray[n]) == null) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    protected String getModifiedRelationName() {
        String string = "";
        SchemaObject schemaObject = this.getModifiedObject();
        if (schemaObject instanceof Index) {
            schemaObject = ((Index)schemaObject).getTable();
        }
        if (schemaObject != null) {
            string = schemaObject.getName();
        }
        return string;
    }
}

